/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.internal;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.bytes.MappedBytesStore;
import net.openhft.chronicle.bytes.MappedBytesStoreFactory;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.bytes.NewChunkListener;
import net.openhft.chronicle.bytes.PageUtil;
import net.openhft.chronicle.bytes.SyncMode;
import net.openhft.chronicle.bytes.domestic.ReentrantFileLock;
import net.openhft.chronicle.bytes.internal.ChunkedMappedBytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.annotation.Positive;
import net.openhft.chronicle.core.io.CleaningRandomAccessFile;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.io.ThreadingIllegalStateException;
import net.openhft.chronicle.core.onoes.ExceptionHandler;
import net.openhft.chronicle.core.util.Longs;
import org.jetbrains.annotations.NotNull;

public class ChunkedMappedFile
extends MappedFile {
    @NotNull
    private final RandomAccessFile raf;
    private final FileChannel fileChannel;
    private final long chunkSize;
    private final long overlapSize;
    private final int pageSize;
    private final List<MappedBytesStore> stores = new ArrayList<MappedBytesStore>();
    private final long capacity;
    private long[] chunkCount = new long[]{0L};
    private SyncMode syncMode = DEFAULT_SYNC_MODE;

    public ChunkedMappedFile(@NotNull File file, @NotNull RandomAccessFile raf, @NonNegative long chunkSize, @NonNegative long overlapSize, @NonNegative long capacity, boolean readOnly) throws IORuntimeException {
        this(file, raf, chunkSize, overlapSize, PageUtil.getPageSize(file.getAbsolutePath()), capacity, readOnly);
    }

    public ChunkedMappedFile(@NotNull File file, @NotNull RandomAccessFile raf, @NonNegative long chunkSize, @NonNegative long overlapSize, @Positive int pageSize, @NonNegative long capacity, boolean readOnly) throws IORuntimeException {
        super(file, readOnly);
        this.validateArgs(chunkSize, overlapSize, pageSize, capacity);
        this.raf = raf;
        this.fileChannel = raf.getChannel();
        this.capacity = OS.mapAlign(capacity, pageSize);
        this.chunkSize = OS.mapAlign(chunkSize, pageSize);
        this.overlapSize = OS.mapAlign(overlapSize, pageSize);
        this.pageSize = pageSize;
        Jvm.doNotCloseOnInterrupt(this.getClass(), this.fileChannel);
    }

    private void validateArgs(long chunkSize, long overlapSize, int pageSize, long capacity) {
        Longs.requireNonNegative(chunkSize);
        Longs.requireNonNegative(overlapSize);
        Longs.requirePositive(pageSize);
        Longs.requireNonNegative(capacity);
        if (this.overlapSize > this.chunkSize) {
            throw new IllegalArgumentException("overlapSize cannot be greater than chunkSize");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void warmup() {
        ArrayList<Exception> errorsDuringWarmup = new ArrayList<Exception>();
        ExceptionHandler error = Jvm.error().defaultHandler();
        ExceptionHandler warn = Jvm.warn().defaultHandler();
        ExceptionHandler debug = Jvm.debug().defaultHandler();
        try {
            Jvm.setExceptionHandlers(error, null, null);
            Path path = Files.createTempDirectory("warmup", new FileAttribute[0]);
            File file = Files.createTempFile(path.toFile().toPath(), "delete_warming_up", "me", new FileAttribute[0]).toFile();
            file.deleteOnExit();
            long mapAlignment = OS.mapAlignment();
            int chunks = 64;
            int compileThreshold = Jvm.compileThreshold();
            for (int j = 0; j <= compileThreshold; j += 64) {
                ChunkedMappedFile.warmupChunks(errorsDuringWarmup, file, mapAlignment, 64);
            }
            Thread.yield();
            Files.delete(file.toPath());
        }
        catch (IOException e) {
            Jvm.setExceptionHandlers(error, warn, debug);
            Jvm.warn().on(ChunkedMappedFile.class, "Error during warmup", (Throwable)e);
        }
        finally {
            Jvm.setExceptionHandlers(error, warn, debug);
            if (!errorsDuringWarmup.isEmpty()) {
                Jvm.warn().on(ChunkedMappedFile.class, errorsDuringWarmup.size() + " errors during warmup: " + errorsDuringWarmup);
            }
        }
    }

    private static void warmupChunks(List<Exception> errorsDuringWarmup, File file, long mapAlignment, @NonNegative int chunks) {
        try {
            try (@NotNull CleaningRandomAccessFile raf = new CleaningRandomAccessFile(file, "rw");
                 ChunkedMappedFile mappedFile = new ChunkedMappedFile(file, raf, mapAlignment, 0L, mapAlignment * (long)chunks, false);){
                ChunkedMappedFile.warmup0(mapAlignment, chunks, mappedFile);
            }
            Thread.yield();
        }
        catch (Exception e) {
            errorsDuringWarmup.add(e);
        }
    }

    private static void warmup0(long mapAlignment, @NonNegative int chunks, @NotNull ChunkedMappedFile mappedFile) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        try {
            ReferenceOwner warmup = ReferenceOwner.temporary("warmup");
            for (int i = 0; i < chunks; ++i) {
                mappedFile.acquireBytesForRead(warmup, (long)i * mapAlignment).release(warmup);
                mappedFile.acquireBytesForWrite(warmup, (long)i * mapAlignment).release(warmup);
            }
        }
        catch (IOException | IllegalArgumentException | IllegalStateException | BufferOverflowException | BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public MappedBytesStore acquireByteStore(ReferenceOwner owner, @NonNegative long position, BytesStore<?, ?> oldByteStore, @NotNull MappedBytesStoreFactory mappedBytesStoreFactory) throws IOException, IllegalArgumentException, ClosedIllegalStateException, ThreadingIllegalStateException {
        MappedBytesStore mbs;
        this.throwExceptionIfClosed();
        if (position < 0L) {
            throw new IORuntimeException("Attempt to access a negative position: " + position);
        }
        int chunk = (int)(position / this.chunkSize);
        List<MappedBytesStore> list = this.stores;
        synchronized (list) {
            while (this.stores.size() <= chunk) {
                this.stores.add(null);
            }
            mbs = this.stores.get(chunk);
        }
        if (mbs != null) {
            if (mbs == oldByteStore) {
                return mbs;
            }
            if (mbs.tryReserve(owner)) {
                return mbs;
            }
        }
        this.resizeRafIfTooSmall(chunk);
        list = this.stores;
        synchronized (list) {
            MappedBytesStore mbs1 = this.stores.get(chunk);
            if (mbs1 != null && mbs1.tryReserve(owner)) {
                return mbs1;
            }
            long mappedSize = this.chunkSize + this.overlapSize;
            FileChannel.MapMode mode = this.readOnly() ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE;
            long startOfMap = (long)chunk * this.chunkSize;
            long beginNs = System.nanoTime();
            this.throwExceptionIfClosed();
            long address = OS.map(this.fileChannel, mode, startOfMap, mappedSize, this.pageSize);
            MappedBytesStore mbs2 = mappedBytesStoreFactory.create(owner, this, (long)chunk * this.chunkSize, address, mappedSize, this.chunkSize, this.pageSize);
            mbs2.syncMode(this.syncMode);
            if (RETAIN) {
                mbs2.reserve(this);
            }
            this.stores.set(chunk, mbs2);
            long elapsedNs = System.nanoTime() - beginNs;
            if (this.newChunkListener != null) {
                this.newChunkListener.onNewChunk(this.file().getPath(), chunk, elapsedNs / 1000L);
            }
            this.chunkCount[0] = this.chunkCount[0] + 1L;
            if (elapsedNs >= 2000000L) {
                Jvm.perf().on(this.getClass(), "Took " + elapsedNs / 1000000L + " ms to add mapping for " + this.file());
            }
            return mbs2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void syncMode(SyncMode syncMode) {
        List<MappedBytesStore> list = this.stores;
        synchronized (list) {
            for (MappedBytesStore store : this.stores) {
                store.syncMode(syncMode);
            }
        }
        this.syncMode = syncMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resizeRafIfTooSmall(@NonNegative int chunk) throws IOException {
        Jvm.safepoint();
        long minSize = ((long)chunk + 1L) * this.chunkSize + this.overlapSize;
        long size = this.fileChannel.size();
        Jvm.safepoint();
        if (size >= minSize || this.readOnly()) {
            return;
        }
        try {
            String string = this.internalizedToken();
            synchronized (string) {
                size = this.fileChannel.size();
                if (size < minSize) {
                    long beginNs = System.nanoTime();
                    try (ReentrantFileLock ignore = ReentrantFileLock.lock(this.file(), this.fileChannel);){
                        size = this.fileChannel.size();
                        if (size < minSize) {
                            Jvm.safepoint();
                            this.raf.setLength(minSize);
                            Jvm.safepoint();
                        }
                    }
                    long elapsedNs = System.nanoTime() - beginNs;
                    if (elapsedNs >= 1000000L) {
                        Jvm.perf().on(this.getClass(), "Took " + elapsedNs / 1000L + " us to grow file " + this.file());
                    }
                }
            }
        }
        catch (IOException ioe) {
            throw new IOException("Failed to resize to " + minSize, ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void performRelease() {
        try {
            List<MappedBytesStore> list = this.stores;
            synchronized (list) {
                for (int i = 0; i < this.stores.size(); ++i) {
                    MappedBytesStore mbs = this.stores.get(i);
                    if (mbs != null && RETAIN) {
                        try {
                            mbs.release(this);
                        }
                        catch (ClosedIllegalStateException e) {
                            Jvm.debug().on(this.getClass(), e);
                        }
                    }
                    this.stores.set(i, null);
                }
            }
        }
        finally {
            Closeable.closeQuietly((Object)this.raf);
            this.setClosed();
        }
    }

    @Override
    @NotNull
    public String referenceCounts() {
        @NotNull StringBuilder sb = new StringBuilder();
        sb.append("refCount: ").append(this.refCount());
        for (MappedBytesStore mbs : this.stores) {
            long count = 0L;
            if (mbs != null) {
                count = mbs.refCount();
            }
            sb.append(", ").append(count);
        }
        return sb.toString();
    }

    @Override
    public long capacity() {
        return this.capacity;
    }

    @Override
    public long chunkSize() {
        return this.chunkSize;
    }

    @Override
    public long overlapSize() {
        return this.overlapSize;
    }

    @Override
    public NewChunkListener getNewChunkListener() {
        return this.newChunkListener;
    }

    @Override
    public void setNewChunkListener(NewChunkListener listener) {
        this.newChunkListener = listener;
    }

    @Override
    public long actualSize() throws IORuntimeException, IllegalStateException {
        boolean interrupted = Thread.interrupted();
        try {
            long l = this.fileChannelSize();
            return l;
        }
        catch (ArrayIndexOutOfBoundsException aiooe) {
            long l = this.actualSize();
            return l;
        }
        catch (ClosedByInterruptException cbie) {
            this.close();
            interrupted = true;
            throw new ClosedIllegalStateException("FileChannel closed", cbie);
        }
        catch (IOException e) {
            boolean open = this.fileChannel.isOpen();
            if (open) {
                throw new IORuntimeException(e);
            }
            this.close();
            throw new IllegalStateException(e);
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private long fileChannelSize() throws IOException, ArrayIndexOutOfBoundsException {
        return this.fileChannel.size();
    }

    @Override
    @NotNull
    public RandomAccessFile raf() {
        return this.raf;
    }

    @Override
    protected void finalize() throws Throwable {
        this.warnAndReleaseIfNotReleased();
        super.finalize();
    }

    @Override
    protected boolean threadSafetyCheck(boolean isUsed) {
        return true;
    }

    @Override
    public FileLock lock(long position, @NonNegative long size, boolean shared) throws IOException {
        return this.fileChannel.lock(position, size, shared);
    }

    @Override
    public FileLock tryLock(@NonNegative long position, @NonNegative long size, boolean shared) throws IOException {
        return this.fileChannel.tryLock(position, size, shared);
    }

    @Override
    public long chunkCount() {
        return this.chunkCount[0];
    }

    @Override
    public void chunkCount(long[] chunkCount) {
        this.chunkCount = chunkCount;
    }

    @Override
    public MappedBytes createBytesFor() throws ClosedIllegalStateException {
        return new ChunkedMappedBytes(this);
    }
}

