/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.internal.fieldinfo;

import java.lang.reflect.Field;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.wire.BracketType;
import net.openhft.chronicle.wire.internal.fieldinfo.UnsafeFieldInfo;
import org.jetbrains.annotations.NotNull;

public final class LongFieldInfo
extends UnsafeFieldInfo {
    public LongFieldInfo(String name, Class<?> type, BracketType bracketType, @NotNull Field field) {
        super(name, type, bracketType, field);
    }

    @Override
    public long getLong(Object object) {
        try {
            return UnsafeMemory.unsafeGetLong(object, this.getOffset());
        }
        catch (NoSuchFieldException e) {
            Jvm.debug().on(LongFieldInfo.class, e);
            return Long.MIN_VALUE;
        }
    }

    @Override
    public void set(Object object, long value) throws IllegalArgumentException {
        try {
            UnsafeMemory.unsafePutLong(object, this.getOffset(), value);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public boolean isEqual(Object a, Object b) {
        return this.getLong(a) == this.getLong(b);
    }

    @Override
    public void copy(Object source, Object destination) {
        this.set(destination, this.getLong(source));
    }
}

