/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.util.function.BiFunction;
import java.util.function.Function;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.wire.BracketType;
import net.openhft.chronicle.wire.SerializationStrategy;
import net.openhft.chronicle.wire.ValueIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ScalarStrategy<E>
implements SerializationStrategy {
    final BiFunction<? super E, ValueIn, E> read;
    private final Class<E> type;

    ScalarStrategy(Class<E> type, @NotNull BiFunction<? super E, ValueIn, E> read) {
        this.type = type;
        this.read = read;
    }

    @NotNull
    static <E> ScalarStrategy<E> of(Class<E> clazz, @NotNull BiFunction<? super E, ValueIn, E> read) {
        return new ScalarStrategy<E>(clazz, read);
    }

    @Nullable
    static <E> ScalarStrategy<E> text(Class<E> clazz, @NotNull Function<String, E> func) {
        return new ScalarStrategy<Object>(clazz, (o, in) -> {
            @Nullable String text = in.text();
            return text == null ? null : func.apply(text);
        });
    }

    @Override
    @NotNull
    public BracketType bracketType() {
        return BracketType.NONE;
    }

    @Override
    @NotNull
    public <T> T newInstanceOrNull(Class<T> type) {
        return Jvm.uncheckedCast(ObjectUtils.newInstance(this.type));
    }

    public Class<E> type() {
        return this.type;
    }

    @Override
    @Nullable
    public <T> T readUsing(Class<?> clazz, T using, @NotNull ValueIn in, BracketType bracketType) {
        if (in.isNull()) {
            return null;
        }
        return (T)this.read.apply(using, in);
    }

    @NotNull
    public String toString() {
        return "ScalarStrategy<" + this.type.getName() + ">";
    }
}

