/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single.namedtailer;

import java.io.IOException;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.TableStoreWriteLock;
import net.openhft.chronicle.queue.impl.single.namedtailer.IndexUpdater;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexUpdaterFactory {
    @Nullable
    public static IndexUpdater createIndexUpdater(@Nullable String tailerName, @NotNull SingleChronicleQueue queue) {
        if (tailerName == null) {
            return null;
        }
        if (tailerName.startsWith("replicated:")) {
            return new VersionedIndexUpdater(tailerName, queue, queue.indexForId(tailerName), queue.indexVersionForId(tailerName));
        }
        return new StandardIndexUpdater(queue.indexForId(tailerName));
    }

    public static class VersionedIndexUpdater
    implements IndexUpdater,
    java.io.Closeable {
        private final TableStoreWriteLock versionIndexLock;
        private final LongValue indexValue;
        private final LongValue indexVersionValue;

        public VersionedIndexUpdater(@NotNull String tailerName, @NotNull SingleChronicleQueue queue, @NotNull LongValue indexValue, @NotNull LongValue indexVersionValue) {
            this.versionIndexLock = queue.versionIndexLockForId(tailerName);
            this.versionIndexLock.forceUnlockIfProcessIsDead();
            this.indexValue = indexValue;
            this.indexVersionValue = indexVersionValue;
        }

        @Override
        public void close() throws IOException {
            Closeable.closeQuietly(this.versionIndexLock, this.indexValue, this.indexVersionValue);
        }

        @Override
        public void update(long index) {
            try {
                this.versionIndexLock.lock();
                this.indexValue.setVolatileValue(index);
                this.indexVersionValue.addAtomicValue(1L);
            }
            finally {
                this.versionIndexLock.unlock();
            }
        }

        @Override
        public LongValue index() {
            return this.indexValue;
        }
    }

    public static class StandardIndexUpdater
    implements IndexUpdater,
    java.io.Closeable {
        private final LongValue indexValue;

        public StandardIndexUpdater(@NotNull LongValue indexValue) {
            this.indexValue = indexValue;
        }

        @Override
        public void close() throws IOException {
            Closeable.closeQuietly((Object)this.indexValue);
        }

        @Override
        public void update(long index) {
            this.indexValue.setValue(index);
        }

        @Override
        public LongValue index() {
            return this.indexValue;
        }
    }
}

