/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.queue.impl.single.StoreAppender;
import net.openhft.chronicle.wire.Wire;
import net.openhft.posix.MSyncFlag;
import net.openhft.posix.PosixAPI;

public class MicroToucher {
    private final StoreAppender appender;
    private long lastPageTouched = 0L;
    private volatile long lastPageToSync = 0L;
    private long lastPageSynced = 0L;

    public MicroToucher(StoreAppender appender) {
        this.appender = appender;
    }

    public boolean execute() {
        Wire bufferWire = this.appender.wire();
        if (bufferWire == null) {
            return false;
        }
        long lastPosition = this.appender.lastPosition;
        long lastPage = lastPosition & 0xFFFFFFFFFFFFF000L;
        long nextPage = lastPosition + 4095L & 0xFFFFFFFFFFFFF000L;
        Bytes<?> bytes = bufferWire.bytes();
        if (nextPage != this.lastPageTouched) {
            this.lastPageTouched = nextPage;
            try {
                BytesStore<?, ?> bs = bytes.bytesStore();
                if (bs.inside(nextPage, 8L)) {
                    this.touchPage(nextPage, bs);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return true;
        }
        this.lastPageToSync = lastPage;
        return false;
    }

    public void bgExecute() {
        long lastPage = this.lastPageToSync;
        long start = this.lastPageSynced;
        long length = Math.min(0x800000L, lastPage - start);
        if (length < 0x800000L) {
            return;
        }
        Wire bufferWire = this.appender.wire();
        if (bufferWire == null) {
            return;
        }
        BytesStore<?, ?> bytes = bufferWire.bytes().bytesStore();
        this.sync(bytes, start, length);
        this.lastPageSynced += length;
    }

    private void sync(BytesStore<?, ?> bytes, long start, long length) {
        if (!bytes.inside(start, length)) {
            return;
        }
        PosixAPI.posix().msync(bytes.addressForRead(start), length, MSyncFlag.MS_ASYNC);
    }

    protected boolean touchPage(long nextPage, BytesStore<?, ?> bs) {
        return bs.compareAndSwapLong(nextPage, 0L, 0L);
    }
}

