/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.ref;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.ref.AbstractReference;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.values.BooleanValue;
import org.jetbrains.annotations.NotNull;

public class TextBooleanReference
extends AbstractReference
implements BooleanValue {
    private static final int FALSE = 1936482662;
    private static final int TRUE = 1970435104;

    public static void write(boolean value, BytesStore<?, ?> bytes, @NonNegative long offset) throws IllegalStateException, BufferOverflowException {
        bytes.writeVolatileInt(offset, value ? 1970435104 : 1936482662);
        bytes.writeByte(offset + 4L, (byte)101);
    }

    @Override
    public long maxSize() {
        return 5L;
    }

    @Override
    @NotNull
    public String toString() {
        try {
            return "value: " + this.getValue();
        }
        catch (IllegalStateException | BufferUnderflowException e) {
            return e.toString();
        }
    }

    @Override
    public boolean getValue() throws IllegalStateException, BufferUnderflowException {
        this.throwExceptionIfClosed();
        return this.bytesStore.readVolatileInt(this.offset) == 1970435104;
    }

    @Override
    public void setValue(boolean value) throws IllegalStateException {
        this.throwExceptionIfClosedInSetter();
        TextBooleanReference.write(value, this.bytesStore, this.offset);
    }
}

