/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.ref;

import net.openhft.chronicle.bytes.ref.BinaryLongReference;
import net.openhft.chronicle.bytes.ref.TwoLongReference;
import org.jetbrains.annotations.NotNull;

public class BinaryTwoLongReference
extends BinaryLongReference
implements TwoLongReference {
    @Override
    public long maxSize() {
        return 16L;
    }

    @Override
    @NotNull
    public String toString() {
        try {
            return this.bytesStore == null ? "bytes is null" : "value: " + this.getValue() + ", value2: " + this.getValue2();
        }
        catch (Exception e) {
            return e.toString();
        }
    }

    @Override
    public long getValue2() throws IllegalStateException {
        try {
            return this.bytesStore.readLong(this.offset + 8L);
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
    }

    @Override
    public void setValue2(long value) throws IllegalStateException {
        try {
            this.bytesStore.writeLong(this.offset + 8L, value);
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
    }

    @Override
    public long getVolatileValue2() throws IllegalStateException {
        try {
            return this.bytesStore.readVolatileLong(this.offset + 8L);
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
    }

    @Override
    public void setVolatileValue2(long value) throws IllegalStateException {
        try {
            this.bytesStore.writeVolatileLong(this.offset + 8L, value);
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
    }

    @Override
    public void setOrderedValue2(long value) throws IllegalStateException {
        try {
            this.bytesStore.writeOrderedLong(this.offset + 8L, value);
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
    }

    @Override
    public long addValue2(long delta) throws IllegalStateException {
        try {
            return this.bytesStore.addAndGetLong(this.offset + 8L, delta);
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
    }

    @Override
    public long addAtomicValue2(long delta) throws IllegalStateException {
        try {
            return this.addValue2(delta);
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
    }

    @Override
    public boolean compareAndSwapValue2(long expected, long value) throws IllegalStateException {
        try {
            return this.bytesStore.compareAndSwapLong(this.offset + 8L, expected, value);
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
    }
}

