/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.pool;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.scoped.ScopedResourcePool;
import net.openhft.chronicle.core.scoped.ScopedThreadLocal;
import org.jetbrains.annotations.NotNull;

public final class BytesPool {
    private static final int DEFAULT_BYTES_POOL_SIZE_PER_THREAD = Jvm.getInteger("chronicle.bytesPool.instancesPerThread", 4);
    final ThreadLocal<Bytes<?>> bytesTL = new ThreadLocal();

    public static ScopedResourcePool<Bytes<?>> createThreadLocal() {
        return BytesPool.createThreadLocal(DEFAULT_BYTES_POOL_SIZE_PER_THREAD);
    }

    public static ScopedResourcePool<Bytes<?>> createThreadLocal(int instancesPerThread) {
        return new ScopedThreadLocal(BytesPool::createBytes, Bytes::clear, instancesPerThread);
    }

    @NotNull
    private static Bytes<?> createBytes() {
        NativeBytes<Void> bbb = Bytes.allocateElasticDirect(256L);
        IOTools.unmonitor(bbb);
        return bbb;
    }
}

