/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.internal;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.bytes.internal.ReferenceCountedUtil;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.io.ReferenceChangeListener;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.io.ThreadingIllegalStateException;
import net.openhft.chronicle.core.util.Ints;
import net.openhft.chronicle.core.util.Longs;
import net.openhft.chronicle.core.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public final class NoBytesStore
implements BytesStore<NoBytesStore, Void> {
    public static final BytesStore<?, ?> NO_BYTES_STORE = new NoBytesStore();
    public static final long NO_PAGE;
    @NotNull
    public static final Bytes<?> NO_BYTES;
    private static final ByteBuffer BYTE_BUFFER;

    private NoBytesStore() {
    }

    @NotNull
    public static <T, B extends BytesStore<B, T>> BytesStore<B, T> noBytesStore() {
        return NO_BYTES_STORE;
    }

    private static BufferUnderflowException throwBUE(long offset) {
        Longs.requireNonNegative(offset);
        return new BufferUnderflowException();
    }

    @Override
    public void reserve(ReferenceOwner owner) throws IllegalStateException {
    }

    @Override
    public void release(ReferenceOwner owner) throws IllegalStateException {
    }

    @Override
    public void releaseLast(ReferenceOwner id) throws IllegalStateException {
    }

    @Override
    public int refCount() {
        return 1;
    }

    @Override
    public void addReferenceChangeListener(ReferenceChangeListener referenceChangeListener) {
    }

    @Override
    public void removeReferenceChangeListener(ReferenceChangeListener referenceChangeListener) {
    }

    @Override
    public boolean tryReserve(ReferenceOwner owner) {
        return false;
    }

    @Override
    @NotNull
    public NoBytesStore writeByte(@NonNegative long offset, byte i8) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public NoBytesStore writeShort(@NonNegative long offset, short i) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public NoBytesStore writeInt(@NonNegative long offset, int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public NoBytesStore writeOrderedInt(@NonNegative long offset, int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public NoBytesStore writeLong(@NonNegative long offset, long i) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public NoBytesStore writeOrderedLong(@NonNegative long offset, long i) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public NoBytesStore writeFloat(@NonNegative long offset, float d) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public NoBytesStore writeDouble(@NonNegative long offset, double d) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public NoBytesStore writeVolatileByte(@NonNegative long offset, byte i8) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public NoBytesStore writeVolatileShort(@NonNegative long offset, short i16) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public NoBytesStore writeVolatileInt(@NonNegative long offset, int i32) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public NoBytesStore writeVolatileLong(@NonNegative long offset, long i64) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public NoBytesStore write(@NonNegative long offsetInRDO, byte[] byteArray, @NonNegative int offset, @NonNegative int length) {
        Longs.requireNonNegative(offsetInRDO);
        ObjectUtils.requireNonNull(byteArray);
        Ints.requireNonNegative(offset);
        Ints.requireNonNegative(length);
        if (length != 0) {
            throw new UnsupportedOperationException();
        }
        return this;
    }

    @Override
    public void write(@NonNegative long offsetInRDO, @NotNull ByteBuffer bytes, @NonNegative int offset, @NonNegative int length) {
        ObjectUtils.requireNonNull(bytes);
        if (length != 0) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    @NotNull
    public NoBytesStore write(@NonNegative long writeOffset, @NotNull RandomDataInput bytes, @NonNegative long readOffset, @NonNegative long length) {
        Longs.requireNonNegative(writeOffset);
        ReferenceCountedUtil.throwExceptionIfReleased(bytes);
        Longs.requireNonNegative(readOffset);
        Longs.requireNonNegative(length);
        if (length != 0L) {
            throw new UnsupportedOperationException();
        }
        return this;
    }

    @Override
    public byte readByte(@NonNegative long offset) {
        throw NoBytesStore.throwBUE(offset);
    }

    @Override
    public int peekUnsignedByte(@NonNegative long offset) {
        return -1;
    }

    @Override
    public short readShort(@NonNegative long offset) {
        throw NoBytesStore.throwBUE(offset);
    }

    @Override
    public int readInt(@NonNegative long offset) {
        throw NoBytesStore.throwBUE(offset);
    }

    @Override
    public long readLong(@NonNegative long offset) {
        throw NoBytesStore.throwBUE(offset);
    }

    @Override
    public float readFloat(@NonNegative long offset) {
        throw NoBytesStore.throwBUE(offset);
    }

    @Override
    public double readDouble(@NonNegative long offset) {
        throw NoBytesStore.throwBUE(offset);
    }

    @Override
    public byte readVolatileByte(@NonNegative long offset) throws BufferUnderflowException {
        throw NoBytesStore.throwBUE(offset);
    }

    @Override
    public short readVolatileShort(@NonNegative long offset) throws BufferUnderflowException {
        throw NoBytesStore.throwBUE(offset);
    }

    @Override
    public int readVolatileInt(@NonNegative long offset) throws BufferUnderflowException {
        throw NoBytesStore.throwBUE(offset);
    }

    @Override
    public long readVolatileLong(@NonNegative long offset) throws BufferUnderflowException {
        throw NoBytesStore.throwBUE(offset);
    }

    @Override
    public boolean isDirectMemory() {
        return false;
    }

    @NotNull
    public NoBytesStore copy() {
        return this;
    }

    @Override
    @NotNull
    public Bytes<Void> bytesForRead() throws ClosedIllegalStateException, ThreadingIllegalStateException {
        return VanillaBytes.wrap(this);
    }

    @Override
    @NonNegative
    public long capacity() {
        return 0L;
    }

    @Override
    public Void underlyingObject() {
        return null;
    }

    @Override
    public boolean inside(@NonNegative long offset) {
        return false;
    }

    @Override
    public boolean inside(@NonNegative long offset, @NonNegative long bufferSize) {
        return offset == 0L && bufferSize == 0L;
    }

    @Override
    public long copyTo(@NotNull BytesStore<?, ?> store) {
        ObjectUtils.requireNonNull(store);
        return 0L;
    }

    @Override
    public void nativeWrite(long address, @NonNegative long position, @NonNegative long size) {
        Longs.requireNonNegative(size | position);
        if ((size | position) > 0L) {
            throw new BufferOverflowException();
        }
    }

    @Override
    public long write8bit(@NonNegative long position, @NotNull BytesStore<?, ?> bs) {
        ObjectUtils.requireNonNull(bs);
        Longs.requireNonNegative(position);
        throw new BufferOverflowException();
    }

    @Override
    public long write8bit(@NonNegative long position, @NotNull String s, @NonNegative int start, @NonNegative int length) {
        ObjectUtils.requireNonNull(s);
        Longs.requireNonNegative(start | length);
        throw new BufferOverflowException();
    }

    @Override
    public void nativeRead(@NonNegative long position, long address, @NonNegative long size) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean compareAndSwapInt(@NonNegative long offset, int expected, int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void testAndSetInt(@NonNegative long offset, int expected, int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean compareAndSwapLong(@NonNegative long offset, long expected, long value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equalBytes(@NotNull BytesStore<?, ?> bytesStore, long length) {
        ObjectUtils.requireNonNull(bytesStore);
        Longs.requireNonNegative(length);
        return length == 0L;
    }

    @Override
    public void move(@NonNegative long from, @NonNegative long to, @NonNegative long length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long addressForRead(@NonNegative long offset) throws BufferUnderflowException {
        Longs.requireNonNegative(offset);
        throw new BufferOverflowException();
    }

    @Override
    public long addressForWrite(@NonNegative long offset) throws BufferOverflowException {
        Longs.requireNonNegative(offset);
        throw new BufferOverflowException();
    }

    @Override
    public long addressForWritePosition() throws UnsupportedOperationException, BufferOverflowException {
        return this.addressForWrite(this.writePosition());
    }

    @Override
    @NotNull
    public Bytes<Void> bytesForWrite() {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public boolean sharedMemory() {
        return false;
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(Object obj) {
        return obj instanceof BytesStore && ((BytesStore)obj).length() == 0;
    }

    @Override
    public String toString() {
        return "";
    }

    static {
        BYTE_BUFFER = ByteBuffer.allocate(4096);
        NO_PAGE = OS.memory().allocate(OS.pageSize());
        NO_BYTES = new NativeBytes(NoBytesStore.noBytesStore());
        IOTools.unmonitor(NO_BYTES);
    }
}

