/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.internal;

import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.bytes.internal.HeapBytesStore;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import org.jetbrains.annotations.NotNull;

public class EmbeddedBytes<U>
extends VanillaBytes<U> {
    private EmbeddedBytes(@NotNull BytesStore<?, ?> bytesStore, long writePosition, long writeLimit) throws IllegalStateException, IllegalArgumentException {
        super(bytesStore, writePosition, writeLimit);
    }

    public static <U> EmbeddedBytes<U> wrap(BytesStore<?, U> bytesStore) {
        return EmbeddedBytes.wrap((HeapBytesStore)Jvm.uncheckedCast(bytesStore));
    }

    public static <U> EmbeddedBytes<U> wrap(HeapBytesStore<U> bytesStore) {
        long wp = bytesStore.start();
        int length = bytesStore.readUnsignedByte(wp - 1L);
        return new EmbeddedBytes<U>(bytesStore, wp, wp + (long)length);
    }

    @Override
    protected void uncheckedWritePosition(@NonNegative long writePosition) {
        super.uncheckedWritePosition(writePosition);
        this.bytesStore.writeUnsignedByte(this.lengthOffset(), (int)writePosition);
    }

    @Override
    @NonNegative
    public long writePosition() {
        try {
            return this.bytesStore.readUnsignedByte(this.lengthOffset());
        }
        catch (ClosedIllegalStateException ignored) {
            return 0L;
        }
    }

    private long lengthOffset() {
        return this.bytesStore.start() - 1L;
    }
}

