/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import net.openhft.chronicle.bytes.ByteStringAppender;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.internal.BytesInternal;
import net.openhft.chronicle.bytes.internal.HasUncheckedRandomDataInput;
import net.openhft.chronicle.bytes.internal.ReferenceCountedUtil;
import net.openhft.chronicle.bytes.internal.UncheckedRandomDataInput;
import net.openhft.chronicle.bytes.internal.UnsafeText;
import net.openhft.chronicle.bytes.internal.migration.HashCodeEqualsUtil;
import net.openhft.chronicle.bytes.render.DecimalAppender;
import net.openhft.chronicle.bytes.render.Decimaliser;
import net.openhft.chronicle.bytes.render.StandardDecimaliser;
import net.openhft.chronicle.bytes.util.DecoratedBufferOverflowException;
import net.openhft.chronicle.bytes.util.DecoratedBufferUnderflowException;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.core.io.AbstractReferenceCounted;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.Monitorable;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.io.ThreadingIllegalStateException;
import net.openhft.chronicle.core.scoped.ScopedResource;
import net.openhft.chronicle.core.util.Ints;
import net.openhft.chronicle.core.util.Longs;
import net.openhft.chronicle.core.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBytes<U>
extends AbstractReferenceCounted
implements Bytes<U>,
HasUncheckedRandomDataInput,
DecimalAppender {
    private static final boolean BYTES_BOUNDS_UNCHECKED = Jvm.getBoolean("bytes.bounds.unchecked", false);
    private static final byte[] MIN_VALUE_TEXT = "-9223372036854775808".getBytes(StandardCharsets.ISO_8859_1);
    @Deprecated
    private static final boolean APPEND_0 = Jvm.getBoolean("bytes.append.0", true);
    @UsedViaReflection
    private final String name;
    private final UncheckedRandomDataInput uncheckedRandomDataInput = new UncheckedRandomDataInputHolder();
    @NotNull
    protected BytesStore<?, U> bytesStore;
    protected long readPosition;
    protected long writeLimit;
    protected boolean isPresent;
    private long writePosition;
    private int lastDecimalPlaces = 0;
    private boolean lenient = false;
    private boolean lastNumberHadDigits = false;
    private Decimaliser decimaliser = StandardDecimaliser.STANDARD;
    private boolean append0 = APPEND_0;

    AbstractBytes(@NotNull BytesStore<Bytes<U>, U> bytesStore, @NonNegative long writePosition, @NonNegative long writeLimit) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        this(bytesStore, writePosition, writeLimit, "");
    }

    AbstractBytes(@NotNull BytesStore<Bytes<U>, U> bytesStore, @NonNegative long writePosition, @NonNegative long writeLimit, String name) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        super(bytesStore.isDirectMemory());
        this.bytesStore(bytesStore);
        bytesStore.reserve(this);
        this.readPosition = bytesStore.readPosition();
        this.uncheckedWritePosition(writePosition);
        this.writeLimit = writeLimit;
        this.name = name;
    }

    @Override
    public boolean isDirectMemory() {
        return this.bytesStore.isDirectMemory();
    }

    @Override
    public boolean canReadDirect(@NonNegative long length) {
        long remaining = this.writePosition() - this.readPosition;
        return this.bytesStore.isDirectMemory() && remaining >= length;
    }

    @Override
    public void move(@NonNegative long from, @NonNegative long to, @NonNegative long length) throws BufferUnderflowException, ClosedIllegalStateException, ArithmeticException, ThreadingIllegalStateException {
        if (from < 0L || to < 0L) {
            throw new IllegalArgumentException();
        }
        if (length == 0L) {
            return;
        }
        assert (DISABLE_SINGLE_THREADED_CHECK || this.threadSafetyCheck(true));
        long start = this.start();
        this.ensureCapacity(to + length);
        this.bytesStore.move(from - start, to - start, length);
    }

    @Override
    @NotNull
    public Bytes<U> compact() throws ClosedIllegalStateException, ThreadingIllegalStateException {
        long readRemaining;
        assert (DISABLE_SINGLE_THREADED_CHECK || this.threadSafetyCheck(true));
        long start = this.start();
        if (this.readPosition - start < (readRemaining = Math.max(0L, this.readRemaining())) / 4L) {
            return this;
        }
        if (readRemaining > 0L && start < this.readPosition) {
            this.bytesStore.move(this.readPosition, start, readRemaining);
        }
        this.readPosition = start;
        this.uncheckedWritePosition(start + readRemaining);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> clear() throws ClosedIllegalStateException, ThreadingIllegalStateException {
        long start = this.start();
        long capacity = this.capacity();
        if (this.readPosition == start && this.writePosition() == start && this.writeLimit == capacity) {
            return this;
        }
        assert (DISABLE_SINGLE_THREADED_CHECK || this.threadSafetyCheck(true));
        this.readPosition = start;
        this.uncheckedWritePosition(start);
        this.writeLimit = capacity;
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> clearAndPad(@NonNegative long length) throws BufferOverflowException, ThreadingIllegalStateException {
        long l;
        assert (DISABLE_SINGLE_THREADED_CHECK || this.threadSafetyCheck(true));
        long start = this.start();
        if (start + length > this.capacity()) {
            throw this.newBOERange(start, length, "clearAndPad failed. Start: %d + length: %d > capacity: %d", this.capacity());
        }
        this.readPosition = l = start + length;
        this.uncheckedWritePosition(l);
        this.writeLimit = this.capacity();
        return this;
    }

    @Override
    public long readLimit() {
        return this.writePosition();
    }

    @Override
    public long writeLimit() {
        return this.writeLimit;
    }

    @Override
    @NonNegative
    public long realCapacity() {
        return this.bytesStore.capacity();
    }

    @Override
    public boolean canWriteDirect(@NonNegative long count) {
        return this.isDirectMemory() && Math.min(this.writeLimit, this.bytesStore.realCapacity()) >= count + this.writePosition();
    }

    @Override
    @NonNegative
    public long capacity() {
        return this.bytesStore.capacity();
    }

    @Override
    @Nullable
    public U underlyingObject() {
        return this.bytesStore.underlyingObject();
    }

    @Override
    public int length() {
        return (int)Math.min(Integer.MAX_VALUE, this.readRemaining());
    }

    @Override
    @NonNegative
    public long start() {
        return this.bytesStore.start();
    }

    @Override
    @NonNegative
    public long readPosition() {
        return this.readPosition;
    }

    @Override
    @NonNegative
    public long writePosition() {
        return this.writePosition;
    }

    @Override
    public boolean compareAndSwapInt(@NonNegative long offset, int expected, int value) throws BufferOverflowException, ClosedIllegalStateException {
        this.writeCheckOffset(offset, 4L);
        return this.bytesStore.compareAndSwapInt(offset, expected, value);
    }

    @Override
    public void testAndSetInt(@NonNegative long offset, int expected, int value) throws BufferOverflowException, ClosedIllegalStateException {
        this.writeCheckOffset(offset, 4L);
        this.bytesStore.testAndSetInt(offset, expected, value);
    }

    @Override
    public boolean compareAndSwapLong(@NonNegative long offset, long expected, long value) throws BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        this.writeCheckOffset(offset, 8L);
        return this.bytesStore.compareAndSwapLong(offset, expected, value);
    }

    @Override
    @NotNull
    public AbstractBytes<U> append(double d) throws BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        if (!this.decimaliser().toDecimal(d, (DecimalAppender)this)) {
            this.append8bit(Double.toString(d));
        }
        return this;
    }

    @NotNull
    private AbstractBytes<U> appendX23(double d) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        boolean fits = this.canWriteDirect(32L);
        if (fits) {
            long address = this.addressForWrite(this.writePosition());
            long address2 = UnsafeText.appendDouble(address, d);
            this.writeSkip(address2 - address);
            return this;
        }
        try (ScopedResource<Bytes<?>> stlBytes = BytesInternal.acquireBytesScoped();){
            Bytes<?> bytes = stlBytes.get();
            bytes.append(d);
            this.append(bytes);
        }
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> append(float f) throws BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        if (!this.decimaliser().toDecimal(f, (DecimalAppender)this)) {
            this.append8bit(Float.toString(f));
        }
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> append(int value) throws BufferOverflowException, IllegalArgumentException, ClosedIllegalStateException, ThreadingIllegalStateException {
        this.appendLong(value);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> append(long value) throws BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        if (value == Long.MIN_VALUE) {
            this.write(MIN_VALUE_TEXT);
        } else {
            this.appendLong(value);
        }
        return this;
    }

    private void appendLong(long value) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        this.ensureCapacity(this.writePosition() + 21L);
        long length = this.bytesStore().appendAndReturnLength(this.writePosition(), value < 0L, Math.abs(value), 0, false);
        this.writeSkip(length);
    }

    @Override
    public Decimaliser decimaliser() {
        return this.decimaliser;
    }

    @Override
    public Bytes<U> decimaliser(Decimaliser decimaliser) {
        this.decimaliser = decimaliser;
        return this;
    }

    @Override
    public boolean fpAppend0() {
        return this.append0;
    }

    @Override
    public Bytes<U> fpAppend0(boolean append0) {
        this.append0 = append0;
        return this;
    }

    @Override
    public void append(boolean negative, long mantissa, int exponent) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        this.ensureCapacity(this.writePosition() + (long)BytesInternal.digitsForExponent(exponent));
        long length = this.bytesStore().appendAndReturnLength(this.writePosition(), negative, mantissa, exponent, this.fpAppend0());
        this.writeSkip(length);
    }

    @Override
    public long appendAndReturnLength(long writePosition, boolean negative, long mantissa, int exponent, boolean append0) {
        return this.bytesStore().appendAndReturnLength(writePosition, negative, mantissa, exponent, append0);
    }

    @Override
    @NotNull
    public Bytes<U> append(double d, int decimalPlaces) throws BufferOverflowException, IllegalArgumentException, ClosedIllegalStateException, ArithmeticException {
        BytesInternal.append((ByteStringAppender)this, d, decimalPlaces);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> readPosition(@NonNegative long position) throws BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        if (this.readPosition == position) {
            return this;
        }
        assert (DISABLE_SINGLE_THREADED_CHECK || this.threadSafetyCheck(true));
        if (position < this.start()) {
            throw new DecoratedBufferUnderflowException(String.format("readPosition failed. Position: %d < start: %d", position, this.start()));
        }
        if (position > this.readLimit()) {
            throw new DecoratedBufferUnderflowException(String.format("readPosition failed. Position: %d > readLimit: %d", position, this.readLimit()));
        }
        this.readPosition = position;
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> readLimit(@NonNegative long limit) throws BufferUnderflowException, ThreadingIllegalStateException {
        if (this.writePosition() == limit) {
            return this;
        }
        assert (DISABLE_SINGLE_THREADED_CHECK || this.threadSafetyCheck(true));
        if (limit < this.start()) {
            throw this.limitLessThanStart(limit);
        }
        if (limit > this.writeLimit()) {
            throw this.limitGreaterThanWriteLimit(limit);
        }
        this.uncheckedWritePosition(limit);
        return this;
    }

    private DecoratedBufferUnderflowException limitGreaterThanWriteLimit(long limit) {
        return new DecoratedBufferUnderflowException(String.format("readLimit failed. Limit: %d > writeLimit: %d", limit, this.writeLimit()));
    }

    private DecoratedBufferUnderflowException limitLessThanStart(long limit) {
        return new DecoratedBufferUnderflowException(String.format("readLimit failed. Limit: %d < start: %d", limit, this.start()));
    }

    @Override
    @NotNull
    public Bytes<U> writePosition(@NonNegative long position) throws BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        if (this.writePosition() == position) {
            return this;
        }
        if (position > this.writeLimit()) {
            throw this.writePositionTooLarge(position);
        }
        if (position < this.start()) {
            throw this.writePositionTooSmall(position);
        }
        if (position < this.readPosition()) {
            this.readPosition = position;
        }
        if (this.isElastic()) {
            this.ensureCapacity(position);
        }
        this.uncheckedWritePosition(position);
        return this;
    }

    @NotNull
    private DecoratedBufferOverflowException writePositionTooSmall(@NonNegative long position) {
        return new DecoratedBufferOverflowException(String.format("writePosition failed. Position: %d < start: %d", position, this.start()));
    }

    private DecoratedBufferOverflowException writePositionTooLarge(@NonNegative long position) {
        return new DecoratedBufferOverflowException(String.format("writePosition failed. Position: %d > writeLimit: %d", position, this.writeLimit()));
    }

    @Override
    @NotNull
    public Bytes<U> readSkip(long bytesToSkip) throws BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        assert (DISABLE_SINGLE_THREADED_CHECK || this.threadSafetyCheck(true));
        if (this.lenient) {
            bytesToSkip = Math.min(bytesToSkip, this.readRemaining());
        }
        this.readOffsetPositionMoved(bytesToSkip);
        return this;
    }

    @Override
    public long readPositionForHeader(boolean skipPadding) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        long position = this.readPosition();
        if (skipPadding) {
            return this.readSkip(BytesUtil.padOffset(position)).readPosition();
        }
        return position;
    }

    @Override
    public void uncheckedReadSkipOne() {
        ++this.readPosition;
    }

    @Override
    public void uncheckedReadSkipBackOne() {
        --this.readPosition;
    }

    @Override
    @NotNull
    public Bytes<U> writeSkip(long bytesToSkip) throws BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        long writePos = this.writePosition();
        assert (DISABLE_SINGLE_THREADED_CHECK || this.threadSafetyCheck(true));
        this.writeCheckOffset(writePos, bytesToSkip);
        this.uncheckedWritePosition(writePos + bytesToSkip);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> writeLimit(@NonNegative long limit) throws BufferOverflowException {
        if (this.writeLimit == limit) {
            return this;
        }
        if (limit < this.start()) {
            throw this.writeLimitTooSmall(limit);
        }
        long capacity = this.capacity();
        if (limit > capacity) {
            throw this.writeLimitTooBig(limit, capacity);
        }
        this.writeLimit = limit;
        return this;
    }

    @NotNull
    private DecoratedBufferOverflowException writeLimitTooBig(@NonNegative long limit, @NonNegative long capacity) {
        return new DecoratedBufferOverflowException(String.format("writeLimit failed. Limit: %d > capacity: %d", limit, capacity));
    }

    @NotNull
    private DecoratedBufferOverflowException writeLimitTooSmall(@NonNegative long limit) {
        return new DecoratedBufferOverflowException(String.format("writeLimit failed. Limit: %d < start: %d", limit, this.start()));
    }

    @Override
    protected void performRelease() throws ClosedIllegalStateException {
        try {
            this.bytesStore.release(this);
        }
        catch (ClosedIllegalStateException e) {
            Jvm.warn().on(this.getClass(), e);
        }
    }

    @Override
    public int readUnsignedByte() throws ClosedIllegalStateException, ThreadingIllegalStateException {
        try {
            long offset = this.readOffsetPositionMoved(1L);
            return this.bytesStore.readUnsignedByte(offset);
        }
        catch (BufferUnderflowException e) {
            return -1;
        }
    }

    @Override
    public int readUnsignedByte(@NonNegative long offset) throws BufferUnderflowException, ClosedIllegalStateException {
        return this.readByte(offset) & 0xFF;
    }

    @Override
    public int uncheckedReadUnsignedByte() {
        try {
            int unsignedByte = this.bytesStore.readUnsignedByte(this.readPosition);
            ++this.readPosition;
            return unsignedByte;
        }
        catch (BufferUnderflowException | ClosedIllegalStateException e) {
            return -1;
        }
    }

    @Override
    public byte readByte() throws ClosedIllegalStateException, ThreadingIllegalStateException {
        try {
            long offset = this.readOffsetPositionMoved(1L);
            return this.bytesStore.readByte(offset);
        }
        catch (BufferUnderflowException e) {
            if (this.lenient) {
                return 0;
            }
            throw e;
        }
    }

    @Override
    public int peekUnsignedByte() throws ClosedIllegalStateException, ThreadingIllegalStateException {
        try {
            return this.readPosition >= this.writePosition() ? -1 : this.bytesStore.readUnsignedByte(this.readPosition);
        }
        catch (BufferUnderflowException e) {
            return -1;
        }
    }

    @Override
    public short readShort() throws BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        try {
            long offset = this.readOffsetPositionMoved(2L);
            return this.bytesStore.readShort(offset);
        }
        catch (BufferUnderflowException e) {
            if (this.lenient) {
                return 0;
            }
            throw e;
        }
    }

    @Override
    public int readInt() throws BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        try {
            long offset = this.readOffsetPositionMoved(4L);
            return this.bytesStore.readInt(offset);
        }
        catch (BufferUnderflowException e) {
            if (this.lenient) {
                return 0;
            }
            throw e;
        }
    }

    @Override
    public byte readVolatileByte(@NonNegative long offset) throws BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        this.readCheckOffset(offset, 1L, true);
        return this.bytesStore.readVolatileByte(offset);
    }

    @Override
    public short readVolatileShort(@NonNegative long offset) throws BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        this.readCheckOffset(offset, 2L, true);
        return this.bytesStore.readVolatileShort(offset);
    }

    @Override
    public int readVolatileInt(@NonNegative long offset) throws BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        this.readCheckOffset(offset, 4L, true);
        return this.bytesStore.readVolatileInt(offset);
    }

    @Override
    public long readVolatileLong(@NonNegative long offset) throws BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        this.readCheckOffset(offset, 8L, true);
        return this.bytesStore.readVolatileLong(offset);
    }

    @Override
    public long readLong() throws BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        try {
            long offset = this.readOffsetPositionMoved(8L);
            return this.bytesStore.readLong(offset);
        }
        catch (BufferUnderflowException e) {
            if (this.lenient) {
                return 0L;
            }
            throw e;
        }
    }

    @Override
    public float readFloat() throws BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        try {
            long offset = this.readOffsetPositionMoved(4L);
            return this.bytesStore.readFloat(offset);
        }
        catch (BufferUnderflowException e) {
            if (this.lenient) {
                return 0.0f;
            }
            throw e;
        }
    }

    @Override
    public double readDouble() throws BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        try {
            long offset = this.readOffsetPositionMoved(8L);
            return this.bytesStore.readDouble(offset);
        }
        catch (BufferUnderflowException e) {
            if (this.lenient) {
                return 0.0;
            }
            throw e;
        }
    }

    @Override
    public int readVolatileInt() throws BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        try {
            long offset = this.readOffsetPositionMoved(4L);
            return this.bytesStore.readVolatileInt(offset);
        }
        catch (BufferUnderflowException e) {
            if (this.lenient) {
                return 0;
            }
            throw e;
        }
    }

    @Override
    public long readVolatileLong() throws BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        try {
            long offset = this.readOffsetPositionMoved(8L);
            return this.bytesStore.readVolatileLong(offset);
        }
        catch (BufferUnderflowException e) {
            if (this.lenient) {
                return 0L;
            }
            throw e;
        }
    }

    protected long readOffsetPositionMoved(@NonNegative long adding) throws BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        long offset = this.readPosition;
        assert (DISABLE_SINGLE_THREADED_CHECK || this.threadSafetyCheck(true));
        this.readCheckOffset(this.readPosition, Math.toIntExact(adding), false);
        this.readPosition += adding;
        assert (this.readPosition <= this.readLimit());
        return offset;
    }

    @Override
    @NotNull
    public Bytes<U> writeByte(@NonNegative long offset, byte i) throws BufferOverflowException, ClosedIllegalStateException {
        this.writeCheckOffset(offset, 1L);
        this.bytesStore.writeByte(offset, i);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> writeShort(@NonNegative long offset, short i) throws BufferOverflowException, ClosedIllegalStateException {
        this.writeCheckOffset(offset, 2L);
        this.bytesStore.writeShort(offset, i);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> writeInt(@NonNegative long offset, int i) throws BufferOverflowException, ClosedIllegalStateException {
        this.writeCheckOffset(offset, 4L);
        this.bytesStore.writeInt(offset, i);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> writeOrderedInt(@NonNegative long offset, int i) throws BufferOverflowException, ClosedIllegalStateException {
        this.writeCheckOffset(offset, 4L);
        this.bytesStore.writeOrderedInt(offset, i);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> writeLong(@NonNegative long offset, long i) throws BufferOverflowException, ClosedIllegalStateException {
        this.writeCheckOffset(offset, 8L);
        this.bytesStore.writeLong(offset, i);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> writeOrderedLong(@NonNegative long offset, long i) throws BufferOverflowException, ClosedIllegalStateException {
        this.writeCheckOffset(offset, 8L);
        this.bytesStore.writeOrderedLong(offset, i);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> writeFloat(@NonNegative long offset, float d) throws BufferOverflowException, ClosedIllegalStateException {
        this.writeCheckOffset(offset, 4L);
        this.bytesStore.writeFloat(offset, d);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> writeDouble(@NonNegative long offset, double d) throws BufferOverflowException, ClosedIllegalStateException {
        this.writeCheckOffset(offset, 8L);
        this.bytesStore.writeDouble(offset, d);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> writeVolatileByte(@NonNegative long offset, byte i8) throws BufferOverflowException, ClosedIllegalStateException {
        this.writeCheckOffset(offset, 1L);
        this.bytesStore.writeVolatileByte(offset, i8);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> writeVolatileShort(@NonNegative long offset, short i16) throws BufferOverflowException, ClosedIllegalStateException {
        this.writeCheckOffset(offset, 2L);
        this.bytesStore.writeVolatileShort(offset, i16);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> writeVolatileInt(@NonNegative long offset, int i32) throws BufferOverflowException, ClosedIllegalStateException {
        this.writeCheckOffset(offset, 4L);
        this.bytesStore.writeVolatileInt(offset, i32);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> writeVolatileLong(@NonNegative long offset, long i64) throws BufferOverflowException, ClosedIllegalStateException {
        this.writeCheckOffset(offset, 8L);
        this.bytesStore.writeVolatileLong(offset, i64);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> write(@NotNull RandomDataInput bytes) throws ClosedIllegalStateException, BufferOverflowException, ThreadingIllegalStateException {
        assert (bytes != this) : "you should not write to yourself !";
        return (Bytes)this.write(bytes, bytes.readPosition(), Math.min(this.writeLimit() - this.writePosition(), bytes.readRemaining()));
    }

    @Override
    public Bytes<U> write(@NotNull BytesStore<?, ?> bytes) throws BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        assert (bytes != this) : "you should not write to yourself !";
        ObjectUtils.requireNonNull(bytes);
        if (bytes.readRemaining() > this.writeRemaining()) {
            throw new BufferOverflowException();
        }
        return (Bytes)this.write(bytes, bytes.readPosition(), bytes.readRemaining());
    }

    @Override
    @NotNull
    public Bytes<U> write(@NonNegative long offsetInRDO, byte[] byteArray, @NonNegative int offset, @NonNegative int length) throws BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        int copy;
        Longs.requireNonNegative(offsetInRDO);
        ObjectUtils.requireNonNull(byteArray);
        Ints.requireNonNegative(offset);
        Ints.requireNonNegative(length);
        for (long remaining = (long)length; remaining > 0L; remaining -= (long)copy) {
            copy = (int)Math.min(remaining, (long)this.safeCopySize());
            this.writeCheckOffset(offsetInRDO, copy);
            this.bytesStore.write(offsetInRDO, byteArray, offset, copy);
            offsetInRDO += (long)copy;
            offset += copy;
        }
        return this;
    }

    @Override
    public void write(@NonNegative long offsetInRDO, @NotNull ByteBuffer bytes, @NonNegative int offset, @NonNegative int length) throws BufferOverflowException, ClosedIllegalStateException {
        ObjectUtils.requireNonNull(bytes);
        if (this.bytesStore.inside(offsetInRDO, length)) {
            this.writeCheckOffset(offsetInRDO, length);
            this.bytesStore.write(offsetInRDO, bytes, offset, length);
        } else if ((long)bytes.remaining() <= this.writeRemaining()) {
            int i;
            bytes.get(offset + length - 1);
            if (bytes.order() == ByteOrder.nativeOrder()) {
                for (i = 0; i < length - 7; i += 8) {
                    this.writeLong(offsetInRDO + (long)i, bytes.getLong(offset + i));
                }
            } else {
                while (i < length - 7) {
                    this.writeLong(offsetInRDO + (long)i, Long.reverseBytes(bytes.getLong(offset + i)));
                    i += 8;
                }
            }
            while (i < length) {
                this.writeByte(offsetInRDO + (long)i, bytes.get(offset + i));
                ++i;
            }
        } else {
            throw new DecoratedBufferOverflowException("Unable to write " + length + " with " + this.writeRemaining() + " remaining");
        }
    }

    @Override
    @NotNull
    public Bytes<U> write(@NonNegative long writeOffset, @NotNull RandomDataInput bytes, @NonNegative long readOffset, @NonNegative long length) throws BufferOverflowException, BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        int copy;
        Longs.requireNonNegative(writeOffset);
        ReferenceCountedUtil.throwExceptionIfReleased(bytes);
        Longs.requireNonNegative(readOffset);
        Longs.requireNonNegative(length);
        this.throwExceptionIfReleased();
        for (long remaining = length; remaining > 0L; remaining -= (long)copy) {
            copy = (int)Math.min(remaining, (long)this.safeCopySize());
            this.writeCheckOffset(writeOffset, copy);
            this.bytesStore.write(writeOffset, bytes, readOffset, (long)copy);
            writeOffset += (long)copy;
            readOffset += (long)copy;
        }
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> write8bit(@NotNull String text, @NonNegative int start, @NonNegative int length) throws BufferOverflowException, IndexOutOfBoundsException, ArithmeticException, ClosedIllegalStateException, BufferUnderflowException, ThreadingIllegalStateException {
        ObjectUtils.requireNonNull(text);
        long toWriteLength = (long)UnsafeMemory.INSTANCE.stopBitLength(length) + (long)length;
        long position = this.writeOffsetPositionMoved(toWriteLength, 0L);
        this.bytesStore.write8bit(position, text, start, length);
        this.uncheckedWritePosition(this.writePosition() + toWriteLength);
        return this;
    }

    @NotNull
    public Bytes<U> write8bit(@Nullable BytesStore<?, ?> bs) throws BufferOverflowException, ClosedIllegalStateException, BufferUnderflowException, ThreadingIllegalStateException {
        if (bs == null) {
            BytesInternal.writeStopBitNeg1(this);
            return this;
        }
        long readRemaining = bs.readRemaining();
        long toWriteLength = (long)UnsafeMemory.INSTANCE.stopBitLength(readRemaining) + readRemaining;
        long position = this.writeOffsetPositionMoved(toWriteLength, 0L);
        this.bytesStore.write8bit(position, bs);
        this.uncheckedWritePosition(this.writePosition() + toWriteLength);
        return this;
    }

    @Override
    public long write8bit(@NonNegative long position, @NotNull BytesStore<?, ?> bs) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        if (position < this.start()) {
            if (position < 0L) {
                throw new IllegalArgumentException();
            }
            throw new BufferUnderflowException();
        }
        if (position + bs.readRemaining() > this.writeLimit) {
            throw new BufferOverflowException();
        }
        this.ensureCapacity(position + bs.readRemaining());
        return this.bytesStore.write8bit(position, bs);
    }

    @Override
    public long write8bit(@NonNegative long position, @NotNull String s, @NonNegative int start, @NonNegative int length) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        if (position < this.start()) {
            if (position < 0L) {
                throw new IllegalArgumentException();
            }
            throw new BufferUnderflowException();
        }
        if (position + (long)length > this.writeLimit) {
            throw new BufferOverflowException();
        }
        this.ensureCapacity(position + (long)length);
        return this.bytesStore.write8bit(position, s, start, length);
    }

    protected void writeCheckOffset(@NonNegative long offset, @NonNegative long adding) throws BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        if (BYTES_BOUNDS_UNCHECKED) {
            return;
        }
        this.writeCheckOffset0(offset, adding);
    }

    private void writeCheckOffset0(@NonNegative long offset, @NonNegative long adding) throws DecoratedBufferOverflowException {
        long start = this.start();
        if (offset < start || offset + adding < start) {
            throw this.newBOELower(offset);
        }
        if (offset + adding > this.writeLimit()) {
            throw this.newBOERange(offset, adding, "writeCheckOffset failed. Offset: %d + adding %d> writeLimit: %d", this.writeLimit());
        }
    }

    @NotNull
    private DecoratedBufferOverflowException newBOERange(@NonNegative long offset, long adding, String msg, @NonNegative long limit) {
        return new DecoratedBufferOverflowException(String.format(msg, offset, adding, limit));
    }

    @NotNull
    private DecoratedBufferOverflowException newBOELower(@NonNegative long offset) {
        if (offset < 0L) {
            throw new IllegalArgumentException("offset: " + offset);
        }
        return new DecoratedBufferOverflowException(String.format("writeCheckOffset failed. Offset: %d < start: %d", offset, this.start()));
    }

    @Override
    public byte readByte(@NonNegative long offset) throws BufferUnderflowException, ClosedIllegalStateException {
        this.readCheckOffset(offset, 1L, true);
        return this.bytesStore.readByte(offset);
    }

    @Override
    public int peekUnsignedByte(@NonNegative long offset) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        return offset < this.start() || this.readLimit() <= offset ? -1 : this.bytesStore.peekUnsignedByte(offset);
    }

    @Override
    public short readShort(@NonNegative long offset) throws BufferUnderflowException, ClosedIllegalStateException {
        this.readCheckOffset(offset, 2L, true);
        return this.bytesStore.readShort(offset);
    }

    @Override
    public int readInt(@NonNegative long offset) throws BufferUnderflowException, ClosedIllegalStateException {
        this.readCheckOffset(offset, 4L, true);
        return this.bytesStore.readInt(offset);
    }

    @Override
    public long readLong(@NonNegative long offset) throws BufferUnderflowException, ClosedIllegalStateException {
        this.readCheckOffset(offset, 8L, true);
        return this.bytesStore.readLong(offset);
    }

    @Override
    public float readFloat(@NonNegative long offset) throws BufferUnderflowException, ClosedIllegalStateException {
        this.readCheckOffset(offset, 4L, true);
        return this.bytesStore.readFloat(offset);
    }

    @Override
    public double readDouble(@NonNegative long offset) throws BufferUnderflowException, ClosedIllegalStateException {
        this.readCheckOffset(offset, 8L, true);
        return this.bytesStore.readDouble(offset);
    }

    protected void readCheckOffset(@NonNegative long offset, long adding, boolean given) throws BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        if (BYTES_BOUNDS_UNCHECKED) {
            return;
        }
        this.readCheckOffset0(offset, adding, given);
    }

    private void readCheckOffset0(@NonNegative long offset, long adding, boolean given) throws DecoratedBufferUnderflowException {
        long limit0;
        if (offset < this.start()) {
            throw this.newBOEReadLower(offset);
        }
        long l = limit0 = given ? this.writeLimit() : this.readLimit();
        if (offset + adding > limit0) {
            throw this.newBOEReadUpper(offset, adding, given);
        }
    }

    @NotNull
    private DecoratedBufferUnderflowException newBOEReadUpper(@NonNegative long offset, long adding, boolean given) {
        if (offset < 0L) {
            throw new IllegalArgumentException("offset: " + offset);
        }
        long limit2 = given ? this.writeLimit() : this.readLimit();
        return new DecoratedBufferUnderflowException(String.format("readCheckOffset0 failed. Offset: %d + adding: %d > limit: %d (given: %s)", offset, adding, limit2, given));
    }

    @NotNull
    private DecoratedBufferUnderflowException newBOEReadLower(@NonNegative long offset) {
        if (offset < 0L) {
            throw new IllegalArgumentException("offset: " + offset);
        }
        return new DecoratedBufferUnderflowException(String.format("readCheckOffset0 failed. Offset: %d < start: %d", offset, this.start()));
    }

    void prewriteCheckOffset(@NonNegative long offset, long subtracting) throws BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        if (BYTES_BOUNDS_UNCHECKED) {
            return;
        }
        this.prewriteCheckOffset0(offset, subtracting);
    }

    private void prewriteCheckOffset0(@NonNegative long offset, long subtracting) throws BufferOverflowException {
        if (offset - subtracting < this.start()) {
            throw this.newBOERange(offset, subtracting, "prewriteCheckOffset0 failed. Offset: %d - subtracting: %d < start: %d", this.start());
        }
        long limit0 = this.readLimit();
        if (offset > limit0) {
            throw new DecoratedBufferOverflowException(String.format("prewriteCheckOffset0 failed. Offset: %d > readLimit: %d", offset, limit0));
        }
    }

    @Override
    @NotNull
    public Bytes<U> writeByte(byte i8) throws BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        long offset = this.writeOffsetPositionMoved(1L);
        this.bytesStore.writeByte(offset, i8);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> prewrite(byte[] bytes) throws BufferOverflowException, ClosedIllegalStateException {
        long offset = this.prewriteOffsetPositionMoved(bytes.length);
        this.bytesStore.write(offset, bytes);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> prewrite(@NotNull BytesStore<?, ?> bytes) throws BufferOverflowException, ClosedIllegalStateException {
        long offset = this.prewriteOffsetPositionMoved(bytes.readRemaining());
        this.bytesStore.write(offset, bytes);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> prewriteByte(byte i8) throws BufferOverflowException, ClosedIllegalStateException {
        long offset = this.prewriteOffsetPositionMoved(1L);
        this.bytesStore.writeByte(offset, i8);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> prewriteInt(int i) throws BufferOverflowException, ClosedIllegalStateException {
        long offset = this.prewriteOffsetPositionMoved(4L);
        this.bytesStore.writeInt(offset, i);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> prewriteShort(short i) throws BufferOverflowException, ClosedIllegalStateException {
        long offset = this.prewriteOffsetPositionMoved(2L);
        this.bytesStore.writeShort(offset, i);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> prewriteLong(long l) throws BufferOverflowException, ClosedIllegalStateException {
        long offset = this.prewriteOffsetPositionMoved(8L);
        this.bytesStore.writeLong(offset, l);
        return this;
    }

    protected final long writeOffsetPositionMoved(@NonNegative long adding) throws BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        return this.writeOffsetPositionMoved(adding, adding);
    }

    protected long writeOffsetPositionMoved(@NonNegative long adding, @NonNegative long advance) throws BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        long oldPosition = this.writePosition();
        assert (DISABLE_SINGLE_THREADED_CHECK || this.threadSafetyCheck(true));
        this.writeCheckOffset(oldPosition, adding);
        this.uncheckedWritePosition(this.writePosition() + advance);
        return oldPosition;
    }

    protected void uncheckedWritePosition(@NonNegative long writePosition) {
        this.writePosition = writePosition;
    }

    protected long prewriteOffsetPositionMoved(@NonNegative long subtracting) throws BufferOverflowException {
        this.prewriteCheckOffset(this.readPosition, subtracting);
        this.readPosition -= subtracting;
        return this.readPosition;
    }

    @Override
    @NotNull
    public Bytes<U> writeShort(short i16) throws BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        long offset = this.writeOffsetPositionMoved(2L);
        this.bytesStore.writeShort(offset, i16);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> writeInt(int i) throws BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        long offset = this.writeOffsetPositionMoved(4L);
        this.bytesStore.writeInt(offset, i);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> writeIntAdv(int i, @NonNegative int advance) throws BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        if (advance < 0) {
            throw new IllegalArgumentException();
        }
        long offset = this.writeOffsetPositionMoved(4L, advance);
        this.bytesStore.writeInt(offset, i);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> writeLong(long i64) throws BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        long offset = this.writeOffsetPositionMoved(8L);
        this.bytesStore.writeLong(offset, i64);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> writeLongAdv(long i64, @NonNegative int advance) throws BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        if (advance < 0) {
            throw new IllegalArgumentException();
        }
        long offset = this.writeOffsetPositionMoved(8L, advance);
        this.bytesStore.writeLong(offset, i64);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> writeFloat(float f) throws BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        long offset = this.writeOffsetPositionMoved(4L);
        this.bytesStore.writeFloat(offset, f);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> writeDouble(double d) throws BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        long offset = this.writeOffsetPositionMoved(8L);
        this.bytesStore.writeDouble(offset, d);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> writeDoubleAndInt(double d, int i) throws BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        long offset = this.writeOffsetPositionMoved(12L);
        this.bytesStore.writeDouble(offset, d);
        this.bytesStore.writeInt(offset + 8L, i);
        return this;
    }

    @Override
    public int read(byte[] bytes, @NonNegative int off, @NonNegative int len) throws BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        int totalToCopy;
        int currentBatchSize;
        ObjectUtils.requireNonNull(bytes);
        long remaining = this.readRemaining();
        if (remaining <= 0L) {
            return -1;
        }
        int currentOffset = off;
        for (int remainingToCopy = totalToCopy = (int)Math.min((long)len, remaining); remainingToCopy > 0; remainingToCopy -= currentBatchSize) {
            currentBatchSize = Math.min(remainingToCopy, this.safeCopySize());
            long offsetInRDO = this.readOffsetPositionMoved(currentBatchSize);
            this.bytesStore.read(offsetInRDO, bytes, currentOffset, currentBatchSize);
            currentOffset += currentBatchSize;
        }
        return totalToCopy;
    }

    @Override
    public long read(@NonNegative long offsetInRDI, byte[] bytes, @NonNegative int offset, @NonNegative int length) throws ClosedIllegalStateException {
        int len = Maths.toUInt31(Math.min((long)length, Longs.requireNonNegative(this.readLimit() - offsetInRDI)));
        return this.bytesStore.read(offsetInRDI, bytes, offset, len);
    }

    @Override
    @NotNull
    public Bytes<U> write(byte[] byteArray, @NonNegative int offset, @NonNegative int length) throws BufferOverflowException, ClosedIllegalStateException, IllegalArgumentException, ThreadingIllegalStateException {
        int copy;
        Ints.requireNonNegative(offset);
        Ints.requireNonNegative(length);
        if (length + offset > byteArray.length) {
            throw new DecoratedBufferOverflowException("bytes.length=" + byteArray.length + ", length=" + length + ", offset=" + offset);
        }
        if ((long)length > this.writeRemaining()) {
            throw new DecoratedBufferOverflowException(String.format("write failed. Length: %d > writeRemaining: %d", length, this.writeRemaining()));
        }
        this.ensureCapacity(this.writePosition() + (long)length);
        int pos = offset;
        for (int remaining = length; remaining > 0; remaining -= copy) {
            copy = Math.min(remaining, this.safeCopySize());
            long offsetInRDO = this.writeOffsetPositionMoved(copy);
            this.bytesStore.write(offsetInRDO, byteArray, pos, copy);
            pos += copy;
        }
        return this;
    }

    protected int safeCopySize() {
        return 65536;
    }

    @Override
    @NotNull
    public Bytes<U> writeSome(@NotNull ByteBuffer buffer) throws BufferOverflowException, ClosedIllegalStateException, BufferUnderflowException, ThreadingIllegalStateException {
        int length = (int)Math.min((long)buffer.remaining(), this.writeRemaining());
        this.ensureCapacity(this.writePosition() + (long)length);
        this.bytesStore.write(this.writePosition(), buffer, buffer.position(), length);
        this.uncheckedWritePosition(this.writePosition() + (long)length);
        buffer.position(buffer.position() + length);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> writeBoolean(boolean flag) throws BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        return this.writeByte(flag ? (byte)89 : 78);
    }

    @Override
    @NotNull
    public Bytes<U> writeOrderedInt(int i) throws BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        long offset = this.writeOffsetPositionMoved(4L);
        this.bytesStore.writeOrderedInt(offset, i);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> writeOrderedLong(long i) throws BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        long offset = this.writeOffsetPositionMoved(8L);
        this.bytesStore.writeOrderedLong(offset, i);
        return this;
    }

    @Override
    public long addressForRead(@NonNegative long offset) throws BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        this.readCheckOffset(offset, 0L, true);
        return this.bytesStore.addressForRead(offset);
    }

    @Override
    public long addressForWrite(@NonNegative long offset) throws BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        this.writeCheckOffset(offset, 0L);
        return this.bytesStore.addressForWrite(offset);
    }

    @Override
    public long addressForWritePosition() throws BufferOverflowException, ClosedIllegalStateException {
        long offset = this.writePosition();
        this.writeCheckOffset(offset, this.isElastic() ? Math.min(64L, this.capacity() - offset) : 0L);
        return this.bytesStore.addressForWrite(offset);
    }

    public int hashCode() {
        return HashCodeEqualsUtil.hashCode(this);
    }

    public boolean equals(Object obj) {
        return obj instanceof BytesStore && BytesInternal.contentEqual(this, (BytesStore)obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public String toString() {
        ReferenceOwner toStringOwner = ReferenceOwner.temporary("toString");
        this.reserve(toStringOwner);
        try {
            String string = BytesInternal.toString(this);
            return string;
        }
        catch (Exception e) {
            String string = e.toString();
            return string;
        }
        finally {
            this.release(toStringOwner);
        }
    }

    @Override
    public void nativeRead(@NonNegative long position, long address, @NonNegative long size) throws BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        this.ensureCapacity(position + size);
        this.bytesStore.nativeRead(position, address, size);
    }

    @Override
    public void nativeWrite(long address, @NonNegative long position, @NonNegative long size) throws BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        this.ensureCapacity(position + size);
        this.bytesStore.nativeWrite(address, position, size);
    }

    @Override
    @NotNull
    public BytesStore<?, U> bytesStore() {
        return this.bytesStore;
    }

    protected void bytesStore(BytesStore<?, U> bytesStore) {
        this.bytesStore = BytesInternal.failIfBytesOnBytes(bytesStore);
    }

    @Override
    public int lastDecimalPlaces() {
        return this.lastDecimalPlaces;
    }

    @Override
    public void lastDecimalPlaces(int lastDecimalPlaces) {
        this.lastDecimalPlaces = Math.max(0, lastDecimalPlaces);
    }

    @Override
    public boolean lastNumberHadDigits() {
        return this.lastNumberHadDigits;
    }

    @Override
    public void lastNumberHadDigits(boolean lastNumberHadDigits) {
        this.lastNumberHadDigits = lastNumberHadDigits;
    }

    @Override
    public boolean isElastic() {
        return false;
    }

    @Override
    public void lenient(boolean lenient) {
        this.lenient = lenient;
    }

    @Override
    public boolean lenient() {
        return this.lenient;
    }

    @Override
    public int byteCheckSum() throws IORuntimeException, BufferUnderflowException, ClosedIllegalStateException {
        return this.byteCheckSum(this.readPosition(), this.readLimit());
    }

    @Override
    public int byteCheckSum(@NonNegative long start, @NonNegative long end) throws BufferUnderflowException, ClosedIllegalStateException {
        if (end < Integer.MAX_VALUE && this.isDirectMemory()) {
            return this.byteCheckSum((int)start, (int)end);
        }
        return Bytes.super.byteCheckSum(start, end);
    }

    @Override
    public boolean startsWith(@Nullable BytesStore<?, ?> bytesStore) throws ClosedIllegalStateException {
        return bytesStore != null && BytesInternal.startsWithUnchecked(this, bytesStore);
    }

    @Override
    @NotNull
    public UncheckedRandomDataInput acquireUncheckedInput() {
        return this.uncheckedRandomDataInput;
    }

    public int byteCheckSum(@NonNegative int start, @NonNegative int end) throws BufferUnderflowException, ClosedIllegalStateException {
        int sum = 0;
        for (int i = start; i < end; ++i) {
            sum += this.readByte(i);
        }
        return sum & 0xFF;
    }

    protected boolean isImmutableEmptyByteStore() {
        return this.bytesStore.capacity() == 0L;
    }

    @Override
    public int copyTo(byte[] bytes) throws BufferUnderflowException, ClosedIllegalStateException {
        this.throwExceptionIfReleased();
        return (int)this.read(this.readPosition(), bytes, 0, bytes.length);
    }

    @Override
    public void unmonitor() {
        super.unmonitor();
        Monitorable.unmonitor(this.bytesStore);
    }

    private final class UncheckedRandomDataInputHolder
    implements UncheckedRandomDataInput {
        private UncheckedRandomDataInputHolder() {
        }

        @Override
        public byte readByte(@NonNegative long offset) throws ClosedIllegalStateException {
            return AbstractBytes.this.bytesStore.readByte(offset);
        }

        @Override
        public short readShort(@NonNegative long offset) throws ClosedIllegalStateException {
            return AbstractBytes.this.bytesStore.readShort(offset);
        }

        @Override
        public int readInt(@NonNegative long offset) throws ClosedIllegalStateException {
            return AbstractBytes.this.bytesStore.readInt(offset);
        }

        @Override
        public long readLong(@NonNegative long offset) throws ClosedIllegalStateException {
            return AbstractBytes.this.bytesStore.readLong(offset);
        }
    }

    static final class ReportUnoptimised {
        private ReportUnoptimised() {
        }

        static void reportOnce() {
        }

        static {
            Jvm.reportUnoptimised();
        }
    }
}

