/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.jitter;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.util.Time;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;

public class QueueWriteJitterMain {
    public static final String PROFILE_OF_THE_THREAD = "profile of the thread";
    static int runTime = Integer.getInteger("runTime", 600);
    static int size = Integer.getInteger("size", 128);
    static int sampleTime = Integer.getInteger("sampleTime", 30);
    static volatile boolean running = true;
    static volatile long writeStarted = Long.MAX_VALUE;

    public static void main(String[] args) {
        new QueueWriteJitterMain().run();
    }

    protected void run() {
        MappedFile.warmup();
        String path = "test-q-" + Time.uniqueId();
        System.out.println("Writing to " + path);
        Thread pretoucher = new Thread(() -> {
            try {
                ChronicleQueue q = this.createQueue(path);
                Throwable throwable = null;
                try {
                    try {
                        ExcerptAppender appender = q.createAppender();
                        Throwable throwable2 = null;
                        try {
                            try {
                                while (true) {
                                    Thread.sleep(50L);
                                    appender.pretouch();
                                }
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                        }
                        catch (Throwable throwable4) {
                            if (appender != null) {
                                if (throwable2 != null) {
                                    try {
                                        appender.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable2.addSuppressed(throwable5);
                                    }
                                } else {
                                    appender.close();
                                }
                            }
                            throw throwable4;
                        }
                    }
                    catch (Throwable throwable6) {
                        throwable = throwable6;
                        throw throwable6;
                    }
                }
                catch (Throwable throwable7) {
                    if (q != null) {
                        if (throwable != null) {
                            try {
                                q.close();
                            }
                            catch (Throwable throwable8) {
                                throwable.addSuppressed(throwable8);
                            }
                        } else {
                            q.close();
                        }
                    }
                    throw throwable7;
                }
            }
            catch (InterruptedException ie) {
                if (running) {
                    ie.printStackTrace();
                }
                return;
            }
        });
        pretoucher.setDaemon(true);
        pretoucher.start();
        Thread writer = new Thread(() -> {
            try (ChronicleQueue q = this.createQueue(path);
                 ExcerptAppender appender = q.createAppender();){
                while (running) {
                    writeStarted = System.nanoTime();
                    Jvm.safepoint();
                    try (DocumentContext dc = appender.writingDocument(false);){
                        Jvm.safepoint();
                        Bytes bytes = dc.wire().bytes();
                        for (int i = 0; i < size; i += 8) {
                            bytes.writeLong((long)i);
                        }
                        Jvm.safepoint();
                    }
                    Jvm.safepoint();
                    writeStarted = Long.MAX_VALUE;
                    this.waitForNext(Math.min(100, sampleTime));
                }
            }
        });
        writer.setDaemon(true);
        writer.start();
        Jvm.pause((long)100L);
        try (ChronicleQueue q = this.createQueue(path);){
            ExcerptTailer tailer = q.createTailer();
            long start0 = System.currentTimeMillis();
            do {
                if (writeStarted < Long.MAX_VALUE) {
                    StackTraceElement[] stes;
                    while (writeStarted + (long)(sampleTime * 1000) > System.nanoTime()) {
                        Thread.yield();
                    }
                    if (writeStarted < Long.MAX_VALUE && !(stes = writer.getStackTrace())[1].getMethodName().equals("waitForNext")) {
                        StringBuilder sb = new StringBuilder();
                        sb.append(PROFILE_OF_THE_THREAD);
                        Jvm.trimStackTrace((StringBuilder)sb, (StackTraceElement[])stes);
                        System.out.println(sb);
                    }
                }
                try (DocumentContext dc = tailer.readingDocument();){
                    if (!dc.isPresent()) {
                        this.waitForNext(Math.min(100, sampleTime));
                    }
                }
                Thread.yield();
            } while (System.currentTimeMillis() < start0 + (long)(runTime * 1000));
        }
        running = false;
        pretoucher.interrupt();
        IOTools.deleteDirWithFiles((String)path, (int)2);
    }

    private void waitForNext(int sampleTime) {
        long start1 = System.nanoTime();
        do {
            Thread.yield();
        } while (System.nanoTime() < start1 + (long)(sampleTime * 1000));
        long time1 = System.nanoTime() - start1;
        if (time1 > (long)(sampleTime * 1000 * 10)) {
            System.out.println("Time paused = " + time1 / 1000L + " us");
        }
    }

    protected ChronicleQueue createQueue(String path) {
        return SingleChronicleQueueBuilder.single((String)path).testBlockSize().build();
    }

    static {
        System.setProperty("jvm.safepoint.enabled", "true");
        System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "info");
    }
}

