/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single.stress.backwardstailer;

import java.io.File;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.TailerDirection;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.rollcycles.LargeRollCycles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LargeCycleFileToEndPerfMain {
    private static final Logger log = LoggerFactory.getLogger(LargeCycleFileToEndPerfMain.class);
    private static final int MESSAGE_COUNT = LargeRollCycles.LARGE_DAILY.defaultIndexCount() * LargeRollCycles.LARGE_DAILY.defaultIndexSpacing() * 25;
    private static final int WARMUP_ITERATIONS = 10000;
    private static final int MESSAGE_SIZE_BYTES = 256;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        File path = Paths.get(OS.getTarget(), LargeCycleFileToEndPerfMain.class.getSimpleName()).toFile();
        LargeCycleFileToEndPerfMain.cleanup(path);
        LargeRollCycles rollCycle = LargeRollCycles.LARGE_DAILY;
        SetTimeProvider timeProvider = new SetTimeProvider();
        timeProvider.set(System.currentTimeMillis());
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.builder().timeProvider((TimeProvider)timeProvider).rollCycle((RollCycle)rollCycle).path(path).build();
             ExcerptAppender appender = queue.createAppender();
             ExcerptTailer tailer = queue.createTailer().direction(TailerDirection.BACKWARD);){
            LargeCycleFileToEndPerfMain.populateQueueData(appender);
            LargeCycleFileToEndPerfMain.warmupToEnd(tailer);
            LargeCycleFileToEndPerfMain.measureToEndPerf(tailer, appender);
        }
        finally {
            LargeCycleFileToEndPerfMain.cleanup(path);
        }
    }

    private static void cleanup(File path) {
        log.info("Cleaning up {}", (Object)path);
        IOTools.deleteDirWithFiles((File)path);
        log.info("Cleaned up {}", (Object)path);
    }

    private static void measureToEndPerf(ExcerptTailer tailer, ExcerptAppender appender) {
        LargeCycleFileToEndPerfMain.line();
        log.info("Measuring single shot tailer.toEnd() performance");
        log.info("tailer.index()[before]: " + tailer.index());
        long start = System.nanoTime();
        tailer.toEnd();
        long elapsed = System.nanoTime() - start;
        log.info("lastIndexAppended: " + appender.lastIndexAppended());
        log.info("tailer.index()[after]: " + tailer.index());
        log.info("Elapsed time micros: {}us", (Object)TimeUnit.NANOSECONDS.toMicros(elapsed));
        log.info("Elapsed time millis: {}ms", (Object)TimeUnit.NANOSECONDS.toMillis(elapsed));
        LargeCycleFileToEndPerfMain.line();
    }

    private static void warmupToEnd(ExcerptTailer tailer) {
        LargeCycleFileToEndPerfMain.line();
        log.info("Running warm up");
        for (int i = 0; i < 10000; ++i) {
            LargeCycleFileToEndPerfMain.writePercentComplete(i, 10000, 500, "tailer.toEnd() warmup");
            tailer.toEnd();
            tailer.toStart();
            System.gc();
        }
        log.info("Warm up complete");
    }

    private static void populateQueueData(ExcerptAppender appender) {
        LargeCycleFileToEndPerfMain.line();
        VanillaBytes bytes = Bytes.allocateDirect((long)256L);
        for (int i = 0; i < MESSAGE_COUNT; ++i) {
            LargeCycleFileToEndPerfMain.writePercentComplete(i, MESSAGE_COUNT, 1000000, "Queue data population");
            bytes.writePosition(256L);
            bytes.readPosition(0L);
            appender.writeBytes((Bytes)bytes);
        }
        log.info("Queue generation is 100% complete");
    }

    private static void writePercentComplete(int i, int total, int emitEveryNth, String prefix) {
        if (i % emitEveryNth == 0) {
            log.info("{} is {}% complete", (Object)prefix, (Object)((int)((double)i / (double)total * 100.0)));
        }
    }

    private static void line() {
        log.info("--------------------------------------------------------------------------------");
    }
}

