/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.StreamCorruptedException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.ExcerptContext;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueStore;
import net.openhft.chronicle.queue.impl.single.StoreTailer;
import net.openhft.chronicle.threads.NamedThreadFactory;
import net.openhft.chronicle.wire.UnrecoverableTimeoutException;
import net.openhft.chronicle.wire.WireType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MoveToWrongIndexThenToEndTest
extends QueueTestCommon {
    private static final int msgSize = 64;
    private static final int numOfToEndCalls = 100;
    private static final long noIndex = 0L;
    private static final RollCycle rollCycle = RollCycles.DEFAULT;
    private final Path basePath = this.getTmpDir().toPath();
    private final SingleChronicleQueue queue = this.createChronicle(this.basePath);
    private final ExcerptAppender appender = this.queue.createAppender();
    private Bytes<ByteBuffer> outbound = Bytes.elasticByteBuffer();

    @Override
    @Before
    public void threadDump() {
        super.threadDump();
    }

    @After
    public void after() {
        this.outbound.releaseLast();
        Closeable.closeQuietly((Object[])new Object[]{this.appender, this.queue});
    }

    private void waitFor(Semaphore semaphore, String message) throws InterruptedException {
        boolean ok = semaphore.tryAcquire(5L, TimeUnit.SECONDS);
        Assert.assertTrue((String)message, (boolean)ok);
    }

    private void append() {
        this.outbound.clear();
        this.outbound.write(new byte[64], 0, 64);
        this.appender.writeBytes(this.outbound);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBufferUnderflowException() throws InterruptedException {
        this.finishedNormally = false;
        this.append();
        this.append();
        long lastIndex = this.getLastIndex(this.basePath);
        ExecutorService executor = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("executor"));
        try {
            Semaphore l0 = new Semaphore(0);
            Semaphore l1 = new Semaphore(0);
            AtomicReference refThrowable = new AtomicReference();
            executor.execute(() -> {
                try (SingleChronicleQueue chronicle = this.createChronicle(this.basePath);){
                    ExcerptTailer tailer = chronicle.createTailer();
                    tailer.moveToIndex(lastIndex);
                    l0.release();
                    for (int i = 0; i < 100; ++i) {
                        tailer.toEnd();
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    refThrowable.set(e);
                }
                finally {
                    l1.release();
                }
            });
            this.waitFor(l0, "tailer start");
            this.append();
            this.append();
            this.waitFor(l1, "tailer finish");
            Assert.assertNull((String)"refThrowable", refThrowable.get());
        }
        finally {
            try {
                executor.shutdown();
            }
            finally {
                if (!executor.isShutdown()) {
                    executor.shutdownNow();
                }
            }
        }
        this.finishedNormally = true;
    }

    /*
     * Exception decompiling
     */
    private long getLastIndex(Path queuePath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long approximateLastIndex(int cycle, SingleChronicleQueue queue, StoreTailer tailer) {
        try (SingleChronicleQueueStore wireStore = queue.storeForCycle(cycle, queue.epoch(), false, null);){
            if (wireStore == null) {
                long l = 0L;
                return l;
            }
            long baseIndex = rollCycle.toIndex(cycle, 0L);
            tailer.moveToIndex(baseIndex);
            long seq = wireStore.sequenceForPosition((ExcerptContext)tailer, Long.MAX_VALUE, false);
            long sequenceNumber = seq + 1L;
            long index = rollCycle.toIndex(cycle, sequenceNumber);
            int cycleOfIndex = rollCycle.toCycle(index);
            if (cycleOfIndex != cycle) {
                throw new IllegalStateException("Expected cycle " + cycle + " but got " + cycleOfIndex);
            }
            long l = index;
            return l;
        }
        catch (StreamCorruptedException | UnrecoverableTimeoutException e) {
            throw new IllegalStateException(e);
        }
    }

    private SingleChronicleQueue createChronicle(Path queuePath) {
        SingleChronicleQueueBuilder builder = SingleChronicleQueueBuilder.builder();
        builder.path(queuePath);
        builder.wireType(WireType.FIELDLESS_BINARY);
        builder.rollCycle(rollCycle);
        return builder.build();
    }
}

