/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import net.openhft.chronicle.queue.impl.single.IndexingTestCommon;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class IndexingMoveToIndexTest
extends IndexingTestCommon {
    IndexingMoveToIndexTest() {
    }

    @Test
    void noDataNegativeIndex() {
        Assertions.assertFalse((boolean)this.tailer.moveToIndex(-1L));
        Assertions.assertEquals((long)0L, (long)this.tailer.index());
    }

    @Test
    void someDataNegativeIndex() {
        this.appender.writeText((CharSequence)"a");
        Assertions.assertFalse((boolean)this.tailer.moveToIndex(-1L));
        Assertions.assertEquals((long)0L, (long)this.tailer.index());
    }

    @Test
    void noData() {
        Assertions.assertFalse((boolean)this.tailer.moveToIndex(0L));
        Assertions.assertEquals((long)0L, (long)this.tailer.index());
    }

    @Test
    void onEntry() {
        this.appender.writeText((CharSequence)"test");
        Assertions.assertTrue((boolean)this.tailer.moveToIndex(0L));
        Assertions.assertEquals((long)0L, (long)this.tailer.index());
    }

    @Test
    void moveNonExistent() {
        this.appender.writeText((CharSequence)"test");
        Assertions.assertFalse((boolean)this.tailer.moveToIndex(1L));
        Assertions.assertEquals((long)1L, (long)this.tailer.index());
        Assertions.assertNull((Object)this.tailer.readText());
    }

    @Test
    void moveNonExistentAtEndOfCycle() {
        this.appender.writeText((CharSequence)"a");
        this.timeProvider.advanceMillis(1001L);
        this.appender.writeText((CharSequence)"b");
        this.timeProvider.advanceMillis(1001L);
        this.appender.writeText((CharSequence)"c");
        this.timeProvider.advanceMillis(1001L);
        long nonExistentIndex = this.queue.rollCycle().toIndex(1, 10L);
        Assertions.assertFalse((boolean)this.tailer.moveToIndex(nonExistentIndex));
        Assertions.assertEquals((long)nonExistentIndex, (long)this.tailer.index());
    }
}

