/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.bench;

import java.io.PrintStream;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.util.NanoSampler;
import net.openhft.chronicle.jlbh.JLBH;
import net.openhft.chronicle.jlbh.JLBHOptions;
import net.openhft.chronicle.jlbh.JLBHTask;
import net.openhft.chronicle.jlbh.TeamCityHelper;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;

public class QueueLargeMessageJLBHBenchmark
implements JLBHTask {
    private static final int MSG_THROUGHPUT = Integer.getInteger("throughput", 50000000);
    private static final int ITERATIONS = Integer.getInteger("iterations", 1000);
    private static final int MSG_LENGTH = Integer.getInteger("length", 1000000);
    private static final String PATH = System.getProperty("path", "replica");
    private static final boolean MSG_DIRECT = Jvm.getBoolean((String)"direct");
    static byte[] bytesArr = new byte[MSG_LENGTH];
    static Bytes<?> bytesArr2 = Bytes.allocateDirect((long)MSG_LENGTH);
    private SingleChronicleQueue sourceQueue;
    private SingleChronicleQueue sinkQueue;
    private ExcerptTailer tailer;
    private ExcerptAppender appender;
    private JLBH jlbh;
    private NanoSampler writeTime;

    public static void main(String[] args) {
        int throughput = MSG_THROUGHPUT / MSG_LENGTH;
        JLBHOptions lth = new JLBHOptions().warmUpIterations(12000).iterations(ITERATIONS).throughput(throughput).recordOSJitter(false).skipFirstRun(true).runs(5).jlbhTask((JLBHTask)new QueueLargeMessageJLBHBenchmark());
        new JLBH(lth).start();
    }

    public void init(JLBH jlbh) {
        IOTools.deleteDirWithFilesOrThrow((String[])new String[]{PATH});
        this.sourceQueue = SingleChronicleQueueBuilder.single((String)PATH).blockSize(0x40000000L).build();
        this.sinkQueue = SingleChronicleQueueBuilder.single((String)PATH).blockSize(0x40000000L).build();
        this.appender = this.sourceQueue.createAppender();
        this.tailer = this.sinkQueue.createTailer();
        this.tailer.singleThreadedCheckDisabled(true);
        this.jlbh = jlbh;
        this.writeTime = jlbh.addProbe("writeTime");
    }

    public void run(long startTimeNS) {
        Bytes bytes;
        if (MSG_DIRECT) {
            bytesArr2.readLimit((long)MSG_LENGTH);
        }
        try (DocumentContext dc = this.appender.writingDocument();){
            bytes = dc.wire().bytes();
            bytes.writeLong(startTimeNS);
            bytes.writeInt(bytes.length());
            if (MSG_DIRECT) {
                bytes.write(bytesArr2);
            } else {
                bytes.write(bytesArr);
            }
        }
        this.writeTime.sampleNanos(System.nanoTime() - startTimeNS);
        dc = this.tailer.readingDocument();
        var4_3 = null;
        try {
            if (dc.wire() != null) {
                bytes = dc.wire().bytes();
                long start = bytes.readLong();
                int length = bytes.readInt();
                assert (length == MSG_LENGTH);
                if (MSG_DIRECT) {
                    bytes.read(bytesArr2.clear(), length);
                } else {
                    bytes.read(bytesArr);
                }
                this.jlbh.sample(System.nanoTime() - start);
            }
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (dc != null) {
                if (var4_3 != null) {
                    try {
                        dc.close();
                    }
                    catch (Throwable throwable) {
                        var4_3.addSuppressed(throwable);
                    }
                } else {
                    dc.close();
                }
            }
        }
    }

    public void complete() {
        this.sinkQueue.close();
        this.sourceQueue.close();
        TeamCityHelper.teamCityStatsLastRun((String)this.getClass().getSimpleName(), (JLBH)this.jlbh, (long)ITERATIONS, (PrintStream)System.out);
    }

    static {
        System.setProperty("disable.thread.safety", "true");
        System.setProperty("jvm.resource.tracing", "false");
        System.setProperty("check.thread.safety", "false");
    }
}

