/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.PageUtil;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.rollcycles.TestRollCycles;
import net.openhft.chronicle.wire.DocumentContext;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class WriteBytesTest
extends QueueTestCommon {
    final Bytes<?> outgoingBytes = Bytes.elasticByteBuffer();
    private final byte[] incomingMsgBytes = new byte[100];
    private final byte[] outgoingMsgBytes = new byte[100];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteBytes() {
        File dir = this.getTmpDir();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).testBlockSize().build();
             ExcerptAppender appender = queue.createAppender();){
            ExcerptTailer tailer = queue.createTailer();
            this.outgoingMsgBytes[0] = 65;
            this.outgoingBytes.write(this.outgoingMsgBytes);
            this.postOneMessage(appender);
            this.fetchOneMessage(tailer, this.incomingMsgBytes);
            this.outgoingBytes.clear();
            this.outgoingMsgBytes[0] = 65;
            this.outgoingMsgBytes[1] = 66;
            this.outgoingBytes.write(this.outgoingMsgBytes);
            this.postOneMessage(appender);
            this.fetchOneMessage(tailer, this.incomingMsgBytes);
        }
        finally {
            try {
                IOTools.deleteDirWithFiles((File)dir, (int)2);
            }
            catch (IORuntimeException iORuntimeException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteBytesAndDump() {
        File dir = this.getTmpDir();
        Assume.assumeFalse((String)"Ignored on hugetlbfs as byte offsets will be different due to page size", (boolean)PageUtil.isHugePage((String)dir.getAbsolutePath()));
        SingleChronicleQueueBuilder builder = SingleChronicleQueueBuilder.binary((File)dir).blockSize(65536).rollCycle((RollCycle)TestRollCycles.TEST4_DAILY).timeProvider((TimeProvider)new SetTimeProvider("2020/10/19T01:01:01"));
        try (SingleChronicleQueue queue = builder.build();
             ExcerptAppender appender = queue.createAppender();){
            for (int i = -128; i <= 127; ++i) {
                byte finalI = (byte)i;
                appender.writeBytes(b -> {
                    Bytes cfr_ignored_0 = (Bytes)b.writeLong((long)finalI * 0x101010101010101L);
                });
            }
            Assert.assertEquals((Object)"--- !!meta-data #binary\nheader: !STStore {\n  wireType: !WireType BINARY_LIGHT,\n  metadata: !SCQMeta {\n    roll: !SCQSRoll { length: 86400000, format: yyyyMMdd'T4', epoch: 0 },\n    deltaCheckpointInterval: 64,\n    sourceId: 0\n  }\n}\n# position: 180, header: 0\n--- !!data #binary\nlisting.highestCycle: 18554\n# position: 216, header: 1\n--- !!data #binary\nlisting.lowestCycle: 18554\n# position: 256, header: 2\n--- !!data #binary\nlisting.modCount: 3\n# position: 288, header: 3\n--- !!data #binary\nchronicle.write.lock: -9223372036854775808\n# position: 328, header: 4\n--- !!data #binary\nchronicle.append.lock: -9223372036854775808\n# position: 368, header: 5\n--- !!data #binary\nchronicle.lastIndexReplicated: -1\n# position: 416, header: 6\n--- !!data #binary\nchronicle.lastAcknowledgedIndexReplicated: -1\n# position: 472, header: 7\n--- !!data #binary\nchronicle.lastIndexMSynced: -1\n...\n# 130548 bytes remaining\n--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    4128,\n    17729624998143\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 32,\n    indexSpacing: 4,\n    index2Index: 200,\n    lastIndex: 256\n  },\n  dataFormat: 1\n}\n# position: 200, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 32, used: 2\n  496,\n  2332,\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 496, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 32, used: 32\n  784,\n  832,\n  880,\n  928,\n  976,\n  1024,\n  1072,\n  1120,\n  1168,\n  1216,\n  1264,\n  1312,\n  1360,\n  1408,\n  1456,\n  1504,\n  1552,\n  1600,\n  1648,\n  1696,\n  1744,\n  1792,\n  1840,\n  1888,\n  1936,\n  1984,\n  2032,\n  2080,\n  2128,\n  2176,\n  2224,\n  2272\n]\n# position: 784, header: 0\n--- !!data #binary\n00000310             80 7f 7f 7f  7f 7f 7f 7f                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 796, header: 1\n--- !!data #binary\n00000320 81 80 80 80 80 80 80 80                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 808, header: 2\n--- !!data #binary\n00000320                                      82 81 81 81              \u00b7\u00b7\u00b7\u00b7\n00000330 81 81 81 81                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 820, header: 3\n--- !!data #binary\n00000330                          83 82 82 82 82 82 82 82          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 832, header: 4\n--- !!data #binary\n00000340             84 83 83 83  83 83 83 83                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 844, header: 5\n--- !!data #binary\n00000350 85 84 84 84 84 84 84 84                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 856, header: 6\n--- !!data #binary\n00000350                                      86 85 85 85              \u00b7\u00b7\u00b7\u00b7\n00000360 85 85 85 85                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 868, header: 7\n--- !!data #binary\n00000360                          87 86 86 86 86 86 86 86          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 880, header: 8\n--- !!data #binary\n00000370             88 87 87 87  87 87 87 87                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 892, header: 9\n--- !!data #binary\n00000380 89 88 88 88 88 88 88 88                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 904, header: 10\n--- !!data #binary\n00000380                                      8a 89 89 89              \u00b7\u00b7\u00b7\u00b7\n00000390 89 89 89 89                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 916, header: 11\n--- !!data #binary\n00000390                          8b 8a 8a 8a 8a 8a 8a 8a          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 928, header: 12\n--- !!data #binary\n000003a0             8c 8b 8b 8b  8b 8b 8b 8b                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 940, header: 13\n--- !!data #binary\n000003b0 8d 8c 8c 8c 8c 8c 8c 8c                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 952, header: 14\n--- !!data #binary\n000003b0                                      8e 8d 8d 8d              \u00b7\u00b7\u00b7\u00b7\n000003c0 8d 8d 8d 8d                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 964, header: 15\n--- !!data #binary\n000003c0                          8f 8e 8e 8e 8e 8e 8e 8e          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 976, header: 16\n--- !!data #binary\n-1.4156185439721035E-29\n# position: 988, header: 17\n--- !!data #binary\n000003e0 91 90 90 90 90 90 90 90                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 1000, header: 18\n--- !!data #binary\n000003e0                                      92 91 91 91              \u00b7\u00b7\u00b7\u00b7\n000003f0 91 91 91 91                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 1012, header: 19\n--- !!data #binary\n000003f0                          93 92 92 92 92 92 92 92          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 1024, header: 20\n--- !!data #binary\n00000400             94 93 93 93  93 93 93 93                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 1036, header: 21\n--- !!data #binary\n00000410 95 94 94 94 94 94 94 94                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 1048, header: 22\n--- !!data #binary\n00000410                                      96 95 95 95              \u00b7\u00b7\u00b7\u00b7\n00000420 95 95 95 95                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 1060, header: 23\n--- !!data #binary\n00000420                          97 96 96 96 96 96 96 96          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 1072, header: 24\n--- !!data #binary\n00000430             98 97 97 97  97 97 97 97                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 1084, header: 25\n--- !!data #binary\n00000440 99 98 98 98 98 98 98 98                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 1096, header: 26\n--- !!data #binary\n00000440                                      9a 99 99 99              \u00b7\u00b7\u00b7\u00b7\n00000450 99 99 99 99                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 1108, header: 27\n--- !!data #binary\n00000450                          9b 9a 9a 9a 9a 9a 9a 9a          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 1120, header: 28\n--- !!data #binary\n00000460             9c 9b 9b 9b  9b 9b 9b 9b                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 1132, header: 29\n--- !!data #binary\n00000470 9d 9c 9c 9c 9c 9c 9c 9c                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 1144, header: 30\n--- !!data #binary\n00000470                                      9e 9d 9d 9d              \u00b7\u00b7\u00b7\u00b7\n00000480 9d 9d 9d 9d                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 1156, header: 31\n--- !!data #binary\n00000480                          9f 9e 9e 9e 9e 9e 9e 9e          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 1168, header: 32\n--- !!data #binary\n00000490             a0 9f 9f 9f  9f 9f 9f 9f                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 1180, header: 33\n--- !!data #binary\n000004a0 a1 a0 a0 a0 a0 a0 a0 a0                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 1192, header: 34\n--- !!data #binary\n41377\n161\n161\n-1\n# position: 1204, header: 35\n--- !!data #binary\n2728567458\n41634\n# position: 1216, header: 36\n--- !!data #binary\n000004c0             a4 a3 a3 a3  a3 a3 a3 a3                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 1228, header: 37\n--- !!data #binary\n000004d0 a5 a4 a4 a4 a4 a4 a4 a4                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 1240, header: 38\n--- !!data #binary\n-1515870811\n!short -23131\n# position: 1252, header: 39\n--- !!data #binary\n000004e0                          a7 a6 a6 a6 a6 a6 a6 a6          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 1264, header: 40\n--- !!data #binary\n000004f0             a8 a7 a7 a7  a7 a7 a7 a7                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 1276, header: 41\n--- !!data #binary\n43176\n168\n168\n-1\n# position: 1288, header: 42\n--- !!data #binary\n00000500                                      aa a9 a9 a9              \u00b7\u00b7\u00b7\u00b7\n00000510 a9 a9 a9 a9                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 1300, header: 43\n--- !!data #binary\n00000510                          ab aa aa aa aa aa aa aa          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 1312, header: 44\n--- !!data #binary\n00000520             ac ab ab ab  ab ab ab ab                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 1324, header: 45\n--- !!data #binary\n00000530 ad ac ac ac ac ac ac ac                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 1336, header: 46\n--- !!data #binary\n00000530                                      ae ad ad ad              \u00b7\u00b7\u00b7\u00b7\n00000540 ad ad ad ad                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 1348, header: 47\n--- !!data #binary\n00000540                          af ae ae ae ae ae ae ae          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 1360, header: 48\n--- !!data #binary\n00000550             b0 af af af  af af af af                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 1372, header: 49\n--- !!data #binary\ntrue\nfalse\nfalse\nfalse\nfalse\nfalse\nfalse\nfalse\n# position: 1384, header: 50\n--- !!data #binary\n00000560                                      b2 b1 b1 b1              \u00b7\u00b7\u00b7\u00b7\n00000570 b1 b1 b1 b1                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 1396, header: 51\n--- !!data #binary\n00000570                          b3 b2 b2 b2 b2 b2 b2 b2          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 1408, header: 52\n--- !!data #binary\n00000580             b4 b3 b3 b3  b3 b3 b3 b3                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 1420, header: 53\n--- !!data #binary\n00000590 b5 b4 b4 b4 b4 b4 b4 b4                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 1432, header: 54\n--- !!data #binary\n00000590                                      b6 b5 b5 b5              \u00b7\u00b7\u00b7\u00b7\n000005a0 b5 b5 b5 b5                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 1444, header: 55\n--- !!data #binary\n000005a0                          b7 b6 b6 b6 b6 b6 b6 b6          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 1456, header: 56\n--- !!data #binary\n000005b0             b8 b7 b7 b7  b7 b7 b7 b7                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 1468, header: 57\n--- !!data #binary\n000005c0 b9 b8 b8 b8 b8 b8 b8 b8                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 1480, header: 58\n--- !!data #binary\n000005c0                                      ba b9 b9 b9              \u00b7\u00b7\u00b7\u00b7\n000005d0 b9 b9 b9 b9                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 1492, header: 59\n--- !!data #binary\n000005d0                          bb ba ba ba ba ba ba ba          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 1504, header: 60\n--- !!data #binary\n000005e0             bc bb bb bb  bb bb bb bb                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 1516, header: 61\n--- !!data #binary\n000005f0 bd bc bc bc bc bc bc bc                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 1528, header: 62\n--- !!data #binary\n000005f0                                      be bd bd bd              \u00b7\u00b7\u00b7\u00b7\n00000600 bd bd bd bd                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 1540, header: 63\n--- !!data #binary\n00000600                          bf be be be be be be be          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 1552, header: 64\n--- !!data #binary\n00000610             c0 bf bf bf  bf bf bf bf                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 1564, header: 65\n--- !!data #binary\n\"\\xC0\": \"\": \"\": \"\": \"\": \"\": \"\":\n# position: 1576, header: 66\n--- !!data #binary\n00000620                                      c2 c1 c1 c1              \u00b7\u00b7\u00b7\u00b7\n00000630 c1 c1 c1 c1                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 1588, header: 67\n--- !!data #binary\n00000630                          c3 c2 c2 c2 c2 c2 c2 c2          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 1600, header: 68\n--- !!data #binary\n00000640             c4 c3 c3 c3  c3 c3 c3 c3                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 1612, header: 69\n--- !!data #binary\n00000650 c5 c4 c4 c4 c4 c4 c4 c4                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 1624, header: 70\n--- !!data #binary\n00000650                                      c6 c5 c5 c5              \u00b7\u00b7\u00b7\u00b7\n00000660 c5 c5 c5 c5                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 1636, header: 71\n--- !!data #binary\n\"\\xC6\\xC6\\xC6\\xC6\\xC6\\xC6\\xC6\":\n# position: 1648, header: 72\n--- !!data #binary\n00000670             c8 c7 c7 c7  c7 c7 c7 c7                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 1660, header: 73\n--- !!data #binary\n00000680 c9 c8 c8 c8 c8 c8 c8 c8                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 1672, header: 74\n--- !!data #binary\n00000680                                      ca c9 c9 c9              \u00b7\u00b7\u00b7\u00b7\n00000690 c9 c9 c9 c9                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 1684, header: 75\n--- !!data #binary\n00000690                          cb ca ca ca ca ca ca ca          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 1696, header: 76\n--- !!data #binary\n000006a0             cc cb cb cb  cb cb cb cb                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 1708, header: 77\n--- !!data #binary\n000006b0 cd cc cc cc cc cc cc cc                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 1720, header: 78\n--- !!data #binary\n000006b0                                      ce cd cd cd              \u00b7\u00b7\u00b7\u00b7\n000006c0 cd cd cd cd                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 1732, header: 79\n--- !!data #binary\n000006c0                          cf ce ce ce ce ce ce ce          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 1744, header: 80\n--- !!data #binary\n000006d0             d0 cf cf cf  cf cf cf cf                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 1756, header: 81\n--- !!data #binary\n000006e0 d1 d0 d0 d0 d0 d0 d0 d0                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 1768, header: 82\n--- !!data #binary\n000006e0                                      d2 d1 d1 d1              \u00b7\u00b7\u00b7\u00b7\n000006f0 d1 d1 d1 d1                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 1780, header: 83\n--- !!data #binary\n000006f0                          d3 d2 d2 d2 d2 d2 d2 d2          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 1792, header: 84\n--- !!data #binary\n00000700             d4 d3 d3 d3  d3 d3 d3 d3                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 1804, header: 85\n--- !!data #binary\n00000710 d5 d4 d4 d4 d4 d4 d4 d4                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 1816, header: 86\n--- !!data #binary\n00000710                                      d6 d5 d5 d5              \u00b7\u00b7\u00b7\u00b7\n00000720 d5 d5 d5 d5                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 1828, header: 87\n--- !!data #binary\n00000720                          d7 d6 d6 d6 d6 d6 d6 d6          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 1840, header: 88\n--- !!data #binary\n00000730             d8 d7 d7 d7  d7 d7 d7 d7                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 1852, header: 89\n--- !!data #binary\n00000740 d9 d8 d8 d8 d8 d8 d8 d8                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 1864, header: 90\n--- !!data #binary\n00000740                                      da d9 d9 d9              \u00b7\u00b7\u00b7\u00b7\n00000750 d9 d9 d9 d9                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 1876, header: 91\n--- !!data #binary\n00000750                          db da da da da da da da          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 1888, header: 92\n--- !!data #binary\n00000760             dc db db db  db db db db                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 1900, header: 93\n--- !!data #binary\n00000770 dd dc dc dc dc dc dc dc                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 1912, header: 94\n--- !!data #binary\n00000770                                      de dd dd dd              \u00b7\u00b7\u00b7\u00b7\n00000780 dd dd dd dd                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 1924, header: 95\n--- !!data #binary\n00000780                          df de de de de de de de          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 1936, header: 96\n--- !!data #binary\n00000790             e0 df df df  df df df df                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 1948, header: 97\n--- !!data #binary\n000007a0 e1 e0 e0 e0 e0 e0 e0 e0                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 1960, header: 98\n--- !!data #binary\n000007a0                                      e2 e1 e1 e1              \u00b7\u00b7\u00b7\u00b7\n000007b0 e1 e1 e1 e1                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 1972, header: 99\n--- !!data #binary\n000007b0                          e3 e2 e2 e2 e2 e2 e2 e2          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 1984, header: 100\n--- !!data #binary\n000007c0             e4 e3 e3 e3  e3 e3 e3 e3                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 1996, header: 101\n--- !!data #binary\n000007d0 e5 e4 e4 e4 e4 e4 e4 e4                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 2008, header: 102\n--- !!data #binary\n000007d0                                      e6 e5 e5 e5              \u00b7\u00b7\u00b7\u00b7\n000007e0 e5 e5 e5 e5                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 2020, header: 103\n--- !!data #binary\n000007e0                          e7 e6 e6 e6 e6 e6 e6 e6          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 2032, header: 104\n--- !!data #binary\n000007f0             e8 e7 e7 e7  e7 e7 e7 e7                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 2044, header: 105\n--- !!data #binary\n00000800 e9 e8 e8 e8 e8 e8 e8 e8                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 2056, header: 106\n--- !!data #binary\n00000800                                      ea e9 e9 e9              \u00b7\u00b7\u00b7\u00b7\n00000810 e9 e9 e9 e9                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 2068, header: 107\n--- !!data #binary\n00000810                          eb ea ea ea ea ea ea ea          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 2080, header: 108\n--- !!data #binary\n00000820             ec eb eb eb  eb eb eb eb                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 2092, header: 109\n--- !!data #binary\n00000830 ed ec ec ec ec ec ec ec                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 2104, header: 110\n--- !!data #binary\n00000830                                      ee ed ed ed              \u00b7\u00b7\u00b7\u00b7\n00000840 ed ed ed ed                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 2116, header: 111\n--- !!data #binary\n00000840                          ef ee ee ee ee ee ee ee          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 2128, header: 112\n--- !!data #binary\n00000850             f0 ef ef ef  ef ef ef ef                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 2140, header: 113\n--- !!data #binary\n00000860 f1 f0 f0 f0 f0 f0 f0 f0                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 2152, header: 114\n--- !!data #binary\n00000860                                      f2 f1 f1 f1              \u00b7\u00b7\u00b7\u00b7\n00000870 f1 f1 f1 f1                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 2164, header: 115\n--- !!data #binary\n00000870                          f3 f2 f2 f2 f2 f2 f2 f2          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 2176, header: 116\n--- !!data #binary\n00000880             f4 f3 f3 f3  f3 f3 f3 f3                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 2188, header: 117\n--- !!data #binary\n00000890 f5 f4 f4 f4 f4 f4 f4 f4                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 2200, header: 118\n--- !!data #binary\n00000890                                      f6 f5 f5 f5              \u00b7\u00b7\u00b7\u00b7\n000008a0 f5 f5 f5 f5                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 2212, header: 119\n--- !!data #binary\n000008a0                          f7 f6 f6 f6 f6 f6 f6 f6          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 2224, header: 120\n--- !!data #binary\n000008b0             f8 f7 f7 f7  f7 f7 f7 f7                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 2236, header: 121\n--- !!data #binary\n000008c0 f9 f8 f8 f8 f8 f8 f8 f8                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 2248, header: 122\n--- !!data #binary\n000008c0                                      fa f9 f9 f9              \u00b7\u00b7\u00b7\u00b7\n000008d0 f9 f9 f9 f9                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 2260, header: 123\n--- !!data #binary\n000008d0                          fb fa fa fa fa fa fa fa          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 2272, header: 124\n--- !!data #binary\n000008e0             fc fb fb fb  fb fb fb fb                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 2284, header: 125\n--- !!data #binary\n000008f0 fd fc fc fc fc fc fc fc                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 2296, header: 126\n--- !!data #binary\n000008f0                                      fe fd fd fd              \u00b7\u00b7\u00b7\u00b7\n00000900 fd fd fd fd                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 2308, header: 127\n--- !!data #binary\n00000900                          ff fe fe fe fe fe fe fe          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 2320, header: 128\n--- !!data #binary\n00000910             00 00 00 00  00 00 00 00                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 2332, header: 128\n--- !!meta-data #binary\nindex: [\n  # length: 32, used: 32\n  2320,\n  2652,\n  2700,\n  2748,\n  2796,\n  2844,\n  2892,\n  2940,\n  2988,\n  3036,\n  3084,\n  3132,\n  3180,\n  3228,\n  3276,\n  3324,\n  3372,\n  3420,\n  3468,\n  3516,\n  3564,\n  3612,\n  3660,\n  3708,\n  3756,\n  3804,\n  3852,\n  3900,\n  3948,\n  3996,\n  4044,\n  4092\n]\n# position: 2616, header: 129\n--- !!data #binary\n00000a30                                      01 01 01 01              \u00b7\u00b7\u00b7\u00b7\n00000a40 01 01 01 01                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 2628, header: 130\n--- !!data #binary\n00000a40                          02 02 02 02 02 02 02 02          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 2640, header: 131\n--- !!data #binary\n00000a50             03 03 03 03  03 03 03 03                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 2652, header: 132\n--- !!data #binary\n00000a60 04 04 04 04 04 04 04 04                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 2664, header: 133\n--- !!data #binary\n00000a60                                      05 05 05 05              \u00b7\u00b7\u00b7\u00b7\n00000a70 05 05 05 05                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 2676, header: 134\n--- !!data #binary\n00000a70                          06 06 06 06 06 06 06 06          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 2688, header: 135\n--- !!data #binary\n00000a80             07 07 07 07  07 07 07 07                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 2700, header: 136\n--- !!data #binary\n00000a90 08 08 08 08 08 08 08 08                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 2712, header: 137\n--- !!data #binary\n00000a90                                      09 09 09 09              \u00b7\u00b7\u00b7\u00b7\n00000aa0 09 09 09 09                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 2724, header: 138\n--- !!data\n\n\n\n\n\n\n\n\n# position: 2736, header: 139\n--- !!data #binary\n00000ab0             0b 0b 0b 0b  0b 0b 0b 0b                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 2748, header: 140\n--- !!data #binary\n00000ac0 0c 0c 0c 0c 0c 0c 0c 0c                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 2760, header: 141\n--- !!data #binary\n00000ac0                                      0d 0d 0d 0d              \u00b7\u00b7\u00b7\u00b7\n00000ad0 0d 0d 0d 0d                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 2772, header: 142\n--- !!data #binary\n00000ad0                          0e 0e 0e 0e 0e 0e 0e 0e          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 2784, header: 143\n--- !!data #binary\n00000ae0             0f 0f 0f 0f  0f 0f 0f 0f                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 2796, header: 144\n--- !!data #binary\n00000af0 10 10 10 10 10 10 10 10                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 2808, header: 145\n--- !!data #binary\n00000af0                                      11 11 11 11              \u00b7\u00b7\u00b7\u00b7\n00000b00 11 11 11 11                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 2820, header: 146\n--- !!data #binary\n00000b00                          12 12 12 12 12 12 12 12          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 2832, header: 147\n--- !!data #binary\n00000b10             13 13 13 13  13 13 13 13                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 2844, header: 148\n--- !!data #binary\n00000b20 14 14 14 14 14 14 14 14                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 2856, header: 149\n--- !!data #binary\n00000b20                                      15 15 15 15              \u00b7\u00b7\u00b7\u00b7\n00000b30 15 15 15 15                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 2868, header: 150\n--- !!data #binary\n00000b30                          16 16 16 16 16 16 16 16          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 2880, header: 151\n--- !!data #binary\n00000b40             17 17 17 17  17 17 17 17                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 2892, header: 152\n--- !!data #binary\n00000b50 18 18 18 18 18 18 18 18                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 2904, header: 153\n--- !!data #binary\n00000b50                                      19 19 19 19              \u00b7\u00b7\u00b7\u00b7\n00000b60 19 19 19 19                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 2916, header: 154\n--- !!data #binary\n00000b60                          1a 1a 1a 1a 1a 1a 1a 1a          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 2928, header: 155\n--- !!data #binary\n00000b70             1b 1b 1b 1b  1b 1b 1b 1b                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 2940, header: 156\n--- !!data #binary\n00000b80 1c 1c 1c 1c 1c 1c 1c 1c                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 2952, header: 157\n--- !!data #binary\n00000b80                                      1d 1d 1d 1d              \u00b7\u00b7\u00b7\u00b7\n00000b90 1d 1d 1d 1d                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 2964, header: 158\n--- !!data #binary\n00000b90                          1e 1e 1e 1e 1e 1e 1e 1e          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 2976, header: 159\n--- !!data #binary\n00000ba0             1f 1f 1f 1f  1f 1f 1f 1f                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 2988, header: 160\n--- !!data\n# position: 3000, header: 161\n--- !!data\n!!!!!!!!\n# position: 3012, header: 162\n--- !!data\n\"\"\"\"\"\"\"\"\n# position: 3024, header: 163\n--- !!data\n########\n# position: 3036, header: 164\n--- !!data\n$$$$$$$$\n# position: 3048, header: 165\n--- !!data\n%%%%%%%%\n# position: 3060, header: 166\n--- !!data\n&&&&&&&&\n# position: 3072, header: 167\n--- !!data\n''''''''\n# position: 3084, header: 168\n--- !!data\n((((((((\n# position: 3096, header: 169\n--- !!data\n))))))))\n# position: 3108, header: 170\n--- !!data\n********\n# position: 3120, header: 171\n--- !!data\n++++++++\n# position: 3132, header: 172\n--- !!data\n,,,,,,,,\n# position: 3144, header: 173\n--- !!data\n--------\n# position: 3156, header: 174\n--- !!data\n........\n# position: 3168, header: 175\n--- !!data\n////////\n# position: 3180, header: 176\n--- !!data\n00000000\n# position: 3192, header: 177\n--- !!data\n11111111\n# position: 3204, header: 178\n--- !!data\n22222222\n# position: 3216, header: 179\n--- !!data\n33333333\n# position: 3228, header: 180\n--- !!data\n44444444\n# position: 3240, header: 181\n--- !!data\n55555555\n# position: 3252, header: 182\n--- !!data\n66666666\n# position: 3264, header: 183\n--- !!data\n77777777\n# position: 3276, header: 184\n--- !!data\n88888888\n# position: 3288, header: 185\n--- !!data\n99999999\n# position: 3300, header: 186\n--- !!data\n::::::::\n# position: 3312, header: 187\n--- !!data\n;;;;;;;;\n# position: 3324, header: 188\n--- !!data\n<<<<<<<<\n# position: 3336, header: 189\n--- !!data\n========\n# position: 3348, header: 190\n--- !!data\n>>>>>>>>\n# position: 3360, header: 191\n--- !!data\n????????\n# position: 3372, header: 192\n--- !!data\n@@@@@@@@\n# position: 3384, header: 193\n--- !!data\nAAAAAAAA\n# position: 3396, header: 194\n--- !!data\nBBBBBBBB\n# position: 3408, header: 195\n--- !!data\nCCCCCCCC\n# position: 3420, header: 196\n--- !!data\nDDDDDDDD\n# position: 3432, header: 197\n--- !!data\nEEEEEEEE\n# position: 3444, header: 198\n--- !!data\nFFFFFFFF\n# position: 3456, header: 199\n--- !!data\nGGGGGGGG\n# position: 3468, header: 200\n--- !!data\nHHHHHHHH\n# position: 3480, header: 201\n--- !!data\nIIIIIIII\n# position: 3492, header: 202\n--- !!data\nJJJJJJJJ\n# position: 3504, header: 203\n--- !!data\nKKKKKKKK\n# position: 3516, header: 204\n--- !!data\nLLLLLLLL\n# position: 3528, header: 205\n--- !!data\nMMMMMMMM\n# position: 3540, header: 206\n--- !!data\nNNNNNNNN\n# position: 3552, header: 207\n--- !!data\nOOOOOOOO\n# position: 3564, header: 208\n--- !!data\nPPPPPPPP\n# position: 3576, header: 209\n--- !!data\nQQQQQQQQ\n# position: 3588, header: 210\n--- !!data\nRRRRRRRR\n# position: 3600, header: 211\n--- !!data\nSSSSSSSS\n# position: 3612, header: 212\n--- !!data\nTTTTTTTT\n# position: 3624, header: 213\n--- !!data\nUUUUUUUU\n# position: 3636, header: 214\n--- !!data\nVVVVVVVV\n# position: 3648, header: 215\n--- !!data\nWWWWWWWW\n# position: 3660, header: 216\n--- !!data\nXXXXXXXX\n# position: 3672, header: 217\n--- !!data\nYYYYYYYY\n# position: 3684, header: 218\n--- !!data\nZZZZZZZZ\n# position: 3696, header: 219\n--- !!data\n[[[[[[[[\n# position: 3708, header: 220\n--- !!data\n\\\\\\\\\\\\\\\\\n# position: 3720, header: 221\n--- !!data\n]]]]]]]]\n# position: 3732, header: 222\n--- !!data\n^^^^^^^^\n# position: 3744, header: 223\n--- !!data\n________\n# position: 3756, header: 224\n--- !!data\n````````\n# position: 3768, header: 225\n--- !!data\naaaaaaaa\n# position: 3780, header: 226\n--- !!data\nbbbbbbbb\n# position: 3792, header: 227\n--- !!data\ncccccccc\n# position: 3804, header: 228\n--- !!data\ndddddddd\n# position: 3816, header: 229\n--- !!data\neeeeeeee\n# position: 3828, header: 230\n--- !!data\nffffffff\n# position: 3840, header: 231\n--- !!data\ngggggggg\n# position: 3852, header: 232\n--- !!data\nhhhhhhhh\n# position: 3864, header: 233\n--- !!data\niiiiiiii\n# position: 3876, header: 234\n--- !!data\njjjjjjjj\n# position: 3888, header: 235\n--- !!data\nkkkkkkkk\n# position: 3900, header: 236\n--- !!data\nllllllll\n# position: 3912, header: 237\n--- !!data\nmmmmmmmm\n# position: 3924, header: 238\n--- !!data\nnnnnnnnn\n# position: 3936, header: 239\n--- !!data\noooooooo\n# position: 3948, header: 240\n--- !!data\npppppppp\n# position: 3960, header: 241\n--- !!data\nqqqqqqqq\n# position: 3972, header: 242\n--- !!data\nrrrrrrrr\n# position: 3984, header: 243\n--- !!data\nssssssss\n# position: 3996, header: 244\n--- !!data\ntttttttt\n# position: 4008, header: 245\n--- !!data\nuuuuuuuu\n# position: 4020, header: 246\n--- !!data\nvvvvvvvv\n# position: 4032, header: 247\n--- !!data\nwwwwwwww\n# position: 4044, header: 248\n--- !!data\nxxxxxxxx\n# position: 4056, header: 249\n--- !!data\nyyyyyyyy\n# position: 4068, header: 250\n--- !!data\nzzzzzzzz\n# position: 4080, header: 251\n--- !!data\n{{{{{{{{\n# position: 4092, header: 252\n--- !!data\n||||||||\n# position: 4104, header: 253\n--- !!data\n}}}}}}}}\n# position: 4116, header: 254\n--- !!data\n~~~~~~~~\n# position: 4128, header: 255\n--- !!data\n\u007f\u007f\u007f\u007f\u007f\u007f\u007f\u007f\n...\n# 126928 bytes remaining\n", (Object)queue.dump());
        }
        finally {
            try {
                IOTools.deleteDirWithFiles((File)dir, (int)2);
            }
            catch (IORuntimeException iORuntimeException) {}
        }
    }

    public boolean postOneMessage(@NotNull ExcerptAppender appender) {
        appender.writeBytes(this.outgoingBytes);
        return true;
    }

    public int fetchOneMessage(@NotNull ExcerptTailer tailer, @NotNull byte[] using) {
        try (DocumentContext dc = tailer.readingDocument();){
            int n = !dc.isPresent() ? -1 : dc.wire().bytes().read(using);
            return n;
        }
    }

    @Override
    public void assertReferencesReleased() {
        this.outgoingBytes.releaseLast();
        super.assertReferencesReleased();
    }
}

