/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.util.Time;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.rollcycles.TestRollCycles;
import org.junit.Assert;
import org.junit.Test;

public class ReadmeTest
extends QueueTestCommon {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createAQueue() {
        String basePath = OS.getTarget() + "/" + this.getClass().getSimpleName() + "-" + Time.uniqueId();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.single((String)basePath).testBlockSize().rollCycle((RollCycle)TestRollCycles.TEST_DAILY).build();
             ExcerptAppender appender = queue.createAppender();){
            appender.writeDocument(w -> w.write((CharSequence)"msg").text("TestMessage"));
            appender.writeText((CharSequence)"TestMessage");
            ExcerptTailer tailer = queue.createTailer();
            tailer.readDocument(w -> System.out.println("msg: " + w.read("msg").text()));
            Assert.assertEquals((Object)"TestMessage", (Object)tailer.readText());
        }
        catch (Throwable throwable) {
            IOTools.deleteDirWithFiles((String[])new String[]{basePath});
            throw throwable;
        }
        IOTools.deleteDirWithFiles((String[])new String[]{basePath});
    }
}

