/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.TailerDirection;
import net.openhft.chronicle.queue.harness.WeeklyRollCycle;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class QueueReadForwardSkippingACycleBiggerThanADayTest
extends QueueTestCommon {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File dataDir;
    private SetTimeProvider timeProvider;

    @Before
    public void setup() throws IOException {
        this.dataDir = this.temporaryFolder.newFolder();
        this.timeProvider = new SetTimeProvider();
    }

    @Test
    public void testReadForwards() {
        Throwable throwable;
        ExcerptAppender excerptAppender;
        WeeklyRollCycle rollingCycle = WeeklyRollCycle.INSTANCE;
        try (SingleChronicleQueue queue = ChronicleQueue.singleBuilder((File)this.dataDir).timeProvider((TimeProvider)this.timeProvider).rollCycle((RollCycle)rollingCycle).build();){
            excerptAppender = queue.createAppender();
            throwable = null;
            try {
                excerptAppender.writeText((CharSequence)"0");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (excerptAppender != null) {
                    if (throwable != null) {
                        try {
                            excerptAppender.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        excerptAppender.close();
                    }
                }
            }
        }
        this.timeProvider.advanceMillis(TimeUnit.DAYS.toMillis(18L));
        queue = ChronicleQueue.singleBuilder((File)this.dataDir).timeProvider((TimeProvider)this.timeProvider).rollCycle((RollCycle)rollingCycle).build();
        var3_3 = null;
        try {
            excerptAppender = queue.createAppender();
            throwable = null;
            try {
                excerptAppender.writeText((CharSequence)"42");
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (excerptAppender != null) {
                    if (throwable != null) {
                        try {
                            excerptAppender.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        excerptAppender.close();
                    }
                }
            }
        }
        catch (Throwable excerptAppender2) {
            var3_3 = excerptAppender2;
            throw excerptAppender2;
        }
        finally {
            if (queue != null) {
                if (var3_3 != null) {
                    try {
                        queue.close();
                    }
                    catch (Throwable excerptAppender2) {
                        var3_3.addSuppressed(excerptAppender2);
                    }
                } else {
                    queue.close();
                }
            }
        }
        queue = ChronicleQueue.singleBuilder((File)this.dataDir).timeProvider((TimeProvider)this.timeProvider).rollCycle((RollCycle)rollingCycle).build();
        var3_3 = null;
        try {
            ExcerptTailer tailer = queue.createTailer().toStart().direction(TailerDirection.FORWARD);
            TestCase.assertEquals((String)"0", (String)tailer.readText());
            TestCase.assertEquals((String)"42", (String)tailer.readText());
            TestCase.assertNull((Object)tailer.readText());
        }
        catch (Throwable throwable6) {
            var3_3 = throwable6;
            throw throwable6;
        }
        finally {
            if (queue != null) {
                if (var3_3 != null) {
                    try {
                        queue.close();
                    }
                    catch (Throwable throwable7) {
                        var3_3.addSuppressed(throwable7);
                    }
                } else {
                    queue.close();
                }
            }
        }
    }
}

