/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.util.Arrays;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.WireType;
import org.junit.Assert;
import org.junit.Test;

public class MappedFileSafeLimitTooSmallTest
extends QueueTestCommon {
    @Test
    public void testMappedFileSafeLimitTooSmall() {
        int arraySize = 40000;
        int blockSize = 240000;
        byte[] data = new byte[40000];
        Arrays.fill(data, (byte)120);
        File tmpDir = this.getTmpDir();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.builder((File)tmpDir, (WireType)WireType.BINARY).blockSize(240000).build();
             ExcerptAppender excerptAppender = queue.createAppender();){
            for (int i = 0; i < 5; ++i) {
                try (DocumentContext dc = excerptAppender.writingDocument();){
                    dc.wire().write((CharSequence)"data").bytes(data);
                    continue;
                }
            }
        }
        queue = SingleChronicleQueueBuilder.builder((File)tmpDir, (WireType)WireType.BINARY).blockSize(240000).build();
        var6_6 = null;
        try {
            for (int i = 0; i < 5; ++i) {
                try (DocumentContext dc = queue.createTailer().readingDocument();){
                    Assert.assertArrayEquals((byte[])data, (byte[])dc.wire().read("data").bytes());
                    continue;
                }
            }
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (queue != null) {
                if (var6_6 != null) {
                    try {
                        queue.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    queue.close();
                }
            }
        }
    }
}

