/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.rollcycles.TestRollCycles;
import org.junit.Assert;
import org.junit.Test;

public class ChronicleQueueMethodsWithoutParametersTest
extends QueueTestCommon {
    @Test
    public void test() {
        File file = this.getTmpDir();
        try (SingleChronicleQueue queue = ChronicleQueue.singleBuilder((File)file).testBlockSize().rollCycle((RollCycle)TestRollCycles.TEST_DAILY).build();){
            SomeListener someListener = (SomeListener)queue.methodWriter(SomeListener.class, new Class[0]);
            SomeManager someManager = new SomeManager();
            MethodReader reader = queue.createTailer().methodReader(new Object[]{someManager});
            Jvm.debug().on(this.getClass(), "Writing to queue");
            someListener.methodWithOneParam(1);
            someListener.methodWithoutParams();
            Jvm.debug().on(this.getClass(), "Reading from queue");
            Assert.assertTrue((boolean)reader.readOne());
            Assert.assertTrue((boolean)reader.readOne());
            Assert.assertFalse((boolean)reader.readOne());
            Assert.assertTrue((boolean)someManager.methodWithOneParamInvoked);
            Assert.assertTrue((boolean)someManager.methodWithoutParamsInvoked);
        }
    }

    public static class SomeManager
    implements SomeListener {
        public boolean methodWithoutParamsInvoked = false;
        public boolean methodWithOneParamInvoked = false;

        @Override
        public void methodWithoutParams() {
            this.methodWithoutParamsInvoked = true;
        }

        @Override
        public void methodWithOneParam(int i) {
            this.methodWithOneParamInvoked = true;
        }
    }

    public static interface SomeListener {
        public void methodWithoutParams();

        public void methodWithOneParam(int var1);
    }
}

