/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.internal.fieldinfo;

import java.lang.reflect.Field;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.wire.BracketType;
import net.openhft.chronicle.wire.internal.fieldinfo.UnsafeFieldInfo;
import org.jetbrains.annotations.NotNull;

public final class CharFieldInfo
extends UnsafeFieldInfo {
    public CharFieldInfo(String name, Class<?> type, BracketType bracketType, @NotNull Field field) {
        super(name, type, bracketType, field);
    }

    @Override
    public char getChar(Object object) {
        try {
            return UnsafeMemory.unsafeGetChar(object, this.getOffset());
        }
        catch (NoSuchFieldException e) {
            Jvm.debug().on(CharFieldInfo.class, e);
            return '\uffff';
        }
    }

    @Override
    public void set(Object object, char value) throws IllegalArgumentException {
        try {
            UnsafeMemory.unsafePutChar(object, this.getOffset(), value);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public boolean isEqual(Object a, Object b) {
        return this.getChar(a) == this.getChar(b);
    }

    @Override
    public void copy(Object source, Object destination) {
        this.set(destination, this.getChar(source));
    }
}

