/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.threads.ExecutorFactory;
import net.openhft.chronicle.threads.VanillaExecutorFactory;
import org.jetbrains.annotations.NotNull;

public enum Threads {

    private static final int MAX_DEPTH_TO_FOLLOW_DELEGATIONS = 20;
    static final long SHUTDOWN_WAIT_MILLIS = Jvm.getLong("SHUTDOWN_WAIT_MS", 500L);
    static final ThreadLocal<List<Object>> listTL = ThreadLocal.withInitial(ArrayList::new);
    static ExecutorFactory executorFactory;

    public static ExecutorService acquireExecutorService(String name, int threads, boolean daemon) {
        return executorFactory.acquireExecutorService(name, threads, daemon);
    }

    public static ScheduledExecutorService acquireScheduledExecutorService(String name, boolean daemon) {
        return executorFactory.acquireScheduledExecutorService(name, daemon);
    }

    public static void executorFactory(ExecutorFactory executorFactory) {
        Threads.executorFactory = executorFactory;
    }

    @NotNull
    public static String threadGroupPrefix() {
        String threadGroupName = Thread.currentThread().getThreadGroup().getName();
        if (!threadGroupName.endsWith("/")) {
            threadGroupName = threadGroupName + "/";
        }
        return threadGroupName;
    }

    public static void shutdownDaemon(@NotNull ExecutorService service) {
        service.shutdownNow();
        try {
            boolean terminated = service.awaitTermination(10L, TimeUnit.MILLISECONDS);
            if (!terminated && !(terminated = service.awaitTermination(1L, TimeUnit.SECONDS))) {
                if (!(service instanceof ThreadPoolExecutor)) {
                    Jvm.warn().on(Threads.class, "*** FAILED TO TERMINATE " + service);
                }
                Threads.warnRunningThreads(service);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static void shutdown(@NotNull ExecutorService service, boolean daemon) {
        if (daemon) {
            Threads.shutdownDaemon(service);
        } else {
            Threads.shutdown(service);
        }
    }

    public static void shutdown(@NotNull ExecutorService service) {
        service.shutdown();
        Threads.unpark(service);
        try {
            if (!service.awaitTermination(SHUTDOWN_WAIT_MILLIS, TimeUnit.MILLISECONDS)) {
                service.shutdownNow();
                if (!service.awaitTermination(10L, TimeUnit.MILLISECONDS)) {
                    if (!(service instanceof ThreadPoolExecutor)) {
                        Jvm.warn().on(Threads.class, "*** FAILED TO TERMINATE " + service);
                    }
                    Threads.warnRunningThreads(service);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private static void warnRunningThreads(@NotNull ExecutorService service) {
        Jvm.pause(100L);
        Threads.forEachThread(service, t -> {
            StringBuilder b = new StringBuilder("**** THE " + t.getName() + " THREAD DID NOT SHUTDOWN ***\n");
            Threads.renderStackTrace(b, t.getStackTrace());
            Jvm.warn().on(Threads.class, b.toString());
        });
    }

    public static void renderStackTrace(StringBuilder stringBuilder, StackTraceElement[] stackTraceElements) {
        for (StackTraceElement s : stackTraceElements) {
            stringBuilder.append("  ").append(s).append("\n");
        }
    }

    public static void unpark(ExecutorService service) {
        Threads.forEachThread(service, LockSupport::unpark);
    }

    public static void interrupt(ExecutorService service) {
        Threads.forEachThread(service, Thread::interrupt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void forEachThread(ExecutorService service, Consumer<Thread> consumer) {
        try {
            if (!(service instanceof ThreadPoolExecutor)) {
                service = Threads.resolveDelegatedExecutorServices(service);
            }
            if (!(service instanceof ThreadPoolExecutor)) {
                return;
            }
            Set workers = (Set)Jvm.getValue(service, "workers");
            if (workers == null) {
                Jvm.warn().on(Threads.class, "Couldn't find workers for " + service.getClass());
                return;
            }
            ReentrantLock mainLock = null;
            try {
                mainLock = (ReentrantLock)Jvm.getValue(service, "mainLock");
            }
            catch (Error e) {
                Jvm.debug().on(Threads.class, e);
            }
            List<Object> objects = listTL.get();
            objects.clear();
            if (mainLock != null) {
                try {
                    mainLock.lock();
                    objects.addAll(workers);
                }
                finally {
                    mainLock.unlock();
                }
            } else {
                objects.addAll(workers);
            }
            for (Object o : objects) {
                Thread t = (Thread)Jvm.getValue(o, "thread");
                if (t.getState() == Thread.State.TERMINATED) continue;
                consumer.accept(t);
            }
        }
        catch (Exception e) {
            Jvm.debug().on(Threads.class, e);
        }
    }

    @NotNull
    private static ExecutorService resolveDelegatedExecutorServices(@NotNull ExecutorService executorService) {
        return Threads.resolveDelegatedExecutorServices(executorService, 0);
    }

    @NotNull
    private static ExecutorService resolveDelegatedExecutorServices(@NotNull ExecutorService executorService, int depth) {
        if (depth > 20) {
            Jvm.warn().on(Threads.class, "Recursion limit hit, there may be a loop");
            return executorService;
        }
        try {
            Object eFieldValue;
            Field eField = Jvm.getFieldOrNull(executorService.getClass(), "e");
            if (eField != null && (eFieldValue = eField.get(executorService)) instanceof ExecutorService) {
                return Threads.resolveDelegatedExecutorServices((ExecutorService)eFieldValue, depth + 1);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            // empty catch block
        }
        return executorService;
    }

    static void loopFinishedQuietly(EventHandler eventHandler) {
        try {
            eventHandler.loopFinished();
        }
        catch (Throwable t) {
            Jvm.warn().on(Threads.class, t);
        }
    }

    static {
        ExecutorFactory instance = VanillaExecutorFactory.INSTANCE;
        try {
            String property = Jvm.getProperty("threads.executor.factory");
            if (property != null) {
                instance = (ExecutorFactory)ObjectUtils.newInstance(property);
            }
        }
        catch (Exception e) {
            Jvm.warn().on(Threads.class, e);
        }
        executorFactory = instance;
    }
}

