/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileLock;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.SyncMode;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.bytes.internal.NativeBytesStore;
import net.openhft.chronicle.bytes.internal.ReferenceCountedUtil;
import net.openhft.chronicle.bytes.internal.Unmapper;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.annotation.Positive;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.io.ThreadingIllegalStateException;
import net.openhft.chronicle.core.util.Longs;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.posix.PosixAPI;
import org.jetbrains.annotations.NotNull;

public class MappedBytesStore
extends NativeBytesStore<Void> {
    protected final Runnable writeCheck;
    private final MappedFile mappedFile;
    private final long start;
    private final long safeLimit;
    private final int pageSize;
    private SyncMode syncMode = MappedFile.DEFAULT_SYNC_MODE;
    private long syncLength = 0L;

    protected MappedBytesStore(ReferenceOwner owner, MappedFile mappedFile, @NonNegative long start, long address, @NonNegative long capacity, @NonNegative long safeCapacity, @Positive int pageSize) throws ClosedIllegalStateException {
        super(address, start + capacity, new Unmapper(address, capacity, pageSize), false);
        this.mappedFile = mappedFile;
        this.start = start;
        this.safeLimit = start + safeCapacity;
        this.writeCheck = mappedFile.readOnly() ? MappedBytesStore::throwReadOnly : MappedBytesStore::readWriteOk;
        this.reserveTransfer(INIT, owner);
        this.pageSize = pageSize;
    }

    public static MappedBytesStore create(ReferenceOwner owner, MappedFile mappedFile, @NonNegative long start, long address, @NonNegative long capacity, @NonNegative long safeCapacity, @Positive int pageSize) throws ClosedIllegalStateException {
        return new MappedBytesStore(owner, mappedFile, start, address, capacity, safeCapacity, pageSize);
    }

    static void throwReadOnly() {
        throw new IllegalStateException("Read Only");
    }

    static void readWriteOk() {
    }

    public long underlyingCapacity() {
        return this.mappedFile.capacity();
    }

    @Override
    @NotNull
    public Bytes<Void> bytesForRead() throws ClosedIllegalStateException, ThreadingIllegalStateException {
        try {
            return (Bytes)new NativeBytes(this).readLimit(this.writeLimit()).readPosition(this.start());
        }
        catch (IllegalArgumentException | BufferUnderflowException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    @NotNull
    public VanillaBytes<Void> bytesForWrite() throws ClosedIllegalStateException, ThreadingIllegalStateException {
        this.writeCheck.run();
        return new NativeBytes<Void>(this);
    }

    @Override
    public boolean inside(@NonNegative long offset) {
        return this.start <= offset && offset < this.safeLimit;
    }

    @Override
    public boolean inside(@NonNegative long offset, @NonNegative long bufferSize) {
        return this.start <= offset && offset + bufferSize <= this.limit;
    }

    @Override
    public long safeLimit() {
        return this.safeLimit;
    }

    @Override
    public byte readByte(@NonNegative long offset) {
        return this.memory.readByte(this.address - this.start + offset);
    }

    @Override
    @NotNull
    public MappedBytesStore writeOrderedInt(@NonNegative long offset, int i) throws IllegalStateException {
        this.writeCheck.run();
        this.memory.writeOrderedInt(this.address - this.start + offset, i);
        return this;
    }

    @Override
    public long translate(@NonNegative long offset) {
        return offset - this.start;
    }

    @Override
    @NonNegative
    public long start() {
        return this.start;
    }

    @Override
    @NonNegative
    public long readPosition() {
        return this.start();
    }

    public FileLock lock(@NonNegative long position, @NonNegative long size, boolean shared) throws IOException {
        return this.mappedFile.lock(position, size, shared);
    }

    public FileLock tryLock(@NonNegative long position, @NonNegative long size, boolean shared) throws IOException {
        return this.mappedFile.tryLock(position, size, shared);
    }

    @Override
    @NotNull
    public MappedBytesStore zeroOut(@NonNegative long start, @NonNegative long end) {
        this.writeCheck.run();
        super.zeroOut(start, end);
        return this;
    }

    @Override
    public boolean compareAndSwapInt(@NonNegative long offset, int expected, int value) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        this.writeCheck.run();
        return super.compareAndSwapInt(offset, expected, value);
    }

    @Override
    public boolean compareAndSwapLong(@NonNegative long offset, long expected, long value) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        this.writeCheck.run();
        return super.compareAndSwapLong(offset, expected, value);
    }

    @Override
    @NotNull
    public MappedBytesStore writeByte(@NonNegative long offset, byte i8) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        this.writeCheck.run();
        super.writeByte(offset, i8);
        return this;
    }

    @Override
    @NotNull
    public MappedBytesStore writeShort(@NonNegative long offset, short i16) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        this.writeCheck.run();
        super.writeShort(offset, i16);
        return this;
    }

    @Override
    @NotNull
    public MappedBytesStore writeInt(@NonNegative long offset, int i32) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        this.writeCheck.run();
        super.writeInt(offset, i32);
        return this;
    }

    @Override
    @NotNull
    public MappedBytesStore writeLong(@NonNegative long offset, long i64) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        this.writeCheck.run();
        super.writeLong(offset, i64);
        return this;
    }

    @Override
    @NotNull
    public MappedBytesStore writeOrderedLong(@NonNegative long offset, long i) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        this.writeCheck.run();
        super.writeOrderedLong(offset, i);
        return this;
    }

    @Override
    @NotNull
    public MappedBytesStore writeFloat(@NonNegative long offset, float f) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        this.writeCheck.run();
        super.writeFloat(offset, f);
        return this;
    }

    @Override
    @NotNull
    public MappedBytesStore writeDouble(@NonNegative long offset, double d) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        this.writeCheck.run();
        super.writeDouble(offset, d);
        return this;
    }

    @Override
    @NotNull
    public MappedBytesStore writeVolatileByte(@NonNegative long offset, byte i8) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        this.writeCheck.run();
        super.writeVolatileByte(offset, i8);
        return this;
    }

    @Override
    @NotNull
    public MappedBytesStore writeVolatileShort(@NonNegative long offset, short i16) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        this.writeCheck.run();
        super.writeVolatileShort(offset, i16);
        return this;
    }

    @Override
    @NotNull
    public MappedBytesStore writeVolatileInt(@NonNegative long offset, int i32) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        this.writeCheck.run();
        super.writeVolatileInt(offset, i32);
        return this;
    }

    @Override
    @NotNull
    public MappedBytesStore writeVolatileLong(@NonNegative long offset, long i64) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        this.writeCheck.run();
        super.writeVolatileLong(offset, i64);
        return this;
    }

    @Override
    @NotNull
    public MappedBytesStore write(@NonNegative long offsetInRDO, byte[] byteArray, @NonNegative int offset, @NonNegative int length) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        this.writeCheck.run();
        super.write(offsetInRDO, byteArray, offset, length);
        return this;
    }

    @Override
    public void write(@NonNegative long offsetInRDO, @NotNull ByteBuffer bytes, @NonNegative int offset, @NonNegative int length) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        ObjectUtils.requireNonNull(bytes);
        this.writeCheck.run();
        super.write(offsetInRDO, bytes, offset, length);
    }

    @Override
    @NotNull
    public MappedBytesStore write(@NonNegative long writeOffset, @NotNull RandomDataInput bytes, @NonNegative long readOffset, @NonNegative long length) throws BufferOverflowException, BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        Longs.requireNonNegative(writeOffset);
        ReferenceCountedUtil.throwExceptionIfReleased(bytes);
        Longs.requireNonNegative(readOffset);
        Longs.requireNonNegative(length);
        this.throwExceptionIfReleased();
        this.writeCheck.run();
        super.write(writeOffset, bytes, readOffset, length);
        return this;
    }

    @Override
    public void write0(@NonNegative long offsetInRDO, @NotNull RandomDataInput bytes, @NonNegative long offset, @NonNegative long length) throws ClosedIllegalStateException {
        ObjectUtils.requireNonNull(bytes);
        this.writeCheck.run();
        super.write0(offsetInRDO, bytes, offset, length);
    }

    @Override
    public void nativeWrite(long address, @NonNegative long position, @NonNegative long size) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        this.writeCheck.run();
        super.nativeWrite(address, position, size);
    }

    @Override
    public long appendUtf8(@NonNegative long pos, char[] chars, @NonNegative int offset, @NonNegative int length) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        this.writeCheck.run();
        return super.appendUtf8(pos, chars, offset, length);
    }

    @Override
    protected void performRelease() {
        if (this.address != 0L && this.syncMode != SyncMode.NONE) {
            this.performMsync(0L, this.safeLimit - this.start, this.syncMode());
        }
        super.performRelease();
    }

    private void performMsync(@NonNegative long offset, long length, SyncMode syncMode) {
        long time0;
        if (syncMode == SyncMode.NONE) {
            return;
        }
        long start0 = System.currentTimeMillis();
        boolean full = offset == 0L;
        int ret = PosixAPI.posix().msync(this.address + offset, length, syncMode.mSyncFlag());
        if (ret != 0) {
            Jvm.error().on(MappedBytesStore.class, "msync failed, " + PosixAPI.posix().lastErrorStr() + ", ret=" + ret + " " + this.mappedFile.file() + " " + Long.toHexString(offset) + " " + Long.toHexString(length));
        }
        if ((time0 = System.currentTimeMillis() - start0) >= 200L) {
            Jvm.perf().on(this.getClass(), "Took " + time0 + " ms to " + (Object)((Object)syncMode) + " " + this.mappedFile.file() + (full ? " (full)" : ""));
        }
    }

    public SyncMode syncMode() {
        return this.syncMode == null ? SyncMode.NONE : this.syncMode;
    }

    public void syncMode(SyncMode syncMode) {
        this.syncMode = syncMode;
    }

    public void syncUpTo(long position) {
        this.syncUpTo(position, this.syncMode);
    }

    public void syncUpTo(long position, SyncMode syncMode) {
        if (syncMode == SyncMode.NONE || this.address == 0L || this.refCount() <= 0) {
            return;
        }
        long positionFromStart = Math.min(this.limit, position) - this.start;
        if (positionFromStart <= this.syncLength) {
            return;
        }
        int mask = -this.pageSize;
        long pageEnd = positionFromStart + (long)this.pageSize - 1L & (long)mask;
        long syncStart = this.syncLength & (long)mask;
        long length2 = pageEnd - syncStart;
        this.performMsync(syncStart, length2, syncMode);
        this.syncLength = positionFromStart;
    }
}

