/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.render;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import net.openhft.chronicle.bytes.render.DecimalAppender;
import net.openhft.chronicle.bytes.render.Decimaliser;
import net.openhft.chronicle.core.Jvm;

public class UsesBigDecimal
implements Decimaliser {
    public static final Decimaliser USES_BIG_DECIMAL = new UsesBigDecimal();
    private static final Field INT_COMPACT = Jvm.getFieldOrNull(BigDecimal.class, "intCompact");
    private static final long NEGATIVE_ZERO_BITS = Long.MIN_VALUE;

    @Override
    public boolean toDecimal(double value, DecimalAppender decimalAppender) {
        if (!Double.isFinite(value) || Double.doubleToLongBits(value) == Long.MIN_VALUE) {
            return false;
        }
        BigDecimal bd = BigDecimal.valueOf(value);
        int exp = bd.scale();
        try {
            if (INT_COMPACT == null) {
                BigInteger bi = bd.unscaledValue();
                long l = bi.longValueExact();
                decimalAppender.append(l < 0L, Math.abs(l), exp);
                return true;
            }
            long l = INT_COMPACT.getLong(bd);
            if (l != Long.MIN_VALUE) {
                decimalAppender.append(l < 0L, Math.abs(l), exp);
                return true;
            }
        }
        catch (ArithmeticException | IllegalAccessException exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean toDecimal(float value, DecimalAppender decimalAppender) {
        if (!Float.isFinite(value)) {
            return false;
        }
        BigDecimal bd = new BigDecimal(Float.toString(value));
        int exp = bd.scale();
        try {
            if (INT_COMPACT == null) {
                BigInteger bi = bd.unscaledValue();
                long l = bi.longValueExact();
                decimalAppender.append(l < 0L, Math.abs(l), exp);
                return true;
            }
            long l = INT_COMPACT.getLong(bd);
            if (l != Long.MIN_VALUE) {
                decimalAppender.append(l < 0L, Math.abs(l), exp);
                return true;
            }
        }
        catch (ArithmeticException | IllegalAccessException exception) {
            // empty catch block
        }
        return false;
    }
}

