/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.namedtailer;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.stream.Stream;
import net.openhft.chronicle.bytes.PageUtil;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class NamedTailerVersioningTest
extends QueueTestCommon {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void nonReplicatedNamedTailerShouldNotCreateVersionInMetdata() {
        File queuePath = this.getTmpDir();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.builder().path(queuePath).build();
             ExcerptAppender appender = queue.createAppender();
             ExcerptTailer tailer = queue.createTailer("named_1");){
            appender.writeText((CharSequence)"Test");
            appender.writeText((CharSequence)"Test");
            appender.writeText((CharSequence)"Test");
            tailer.readText();
            tailer.readText();
            tailer.readText();
            LongValue longValue = queue.metaStore().acquireValueFor((CharSequence)String.format("index.%s.version", "named_1"));
            Assert.assertEquals((long)Long.MIN_VALUE, (long)longValue.getValue());
            longValue.close();
        }
        finally {
            IOTools.deleteDirWithFiles((File)queuePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void verifyBackwardsCompatibility_tailerPositionsAreRetained() throws IOException, URISyntaxException {
        Assume.assumeFalse((String)"This test must be ignored on hugetlbfs because the test file was generated on a standard linux file system", (boolean)PageUtil.isHugePage((String)OS.getTarget()));
        Path templatePath = Paths.get(this.getClass().getResource("/named-tailer/5.25ea1-backwards-compat").toURI());
        Path targetPath = Paths.get(OS.getTarget(), new String[0]).resolve(templatePath.getFileName());
        this.copyFolder(templatePath, targetPath);
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.builder().path(targetPath).build();
             ExcerptTailer tailerOne = queue.createTailer("replicated:tailerOne");
             ExcerptTailer tailerTwo = queue.createTailer("replicated:tailerTwo");
             ExcerptTailer tailerThree = queue.createTailer("replicated:tailerThree");){
            Assert.assertEquals((long)84512071483394L, (long)tailerOne.index());
            Assert.assertEquals((long)84512071483394L, (long)tailerTwo.index());
            Assert.assertEquals((long)84512071483394L, (long)tailerThree.index());
            try (LongValue tailerOneVersion = queue.indexVersionForId("replicated:tailerOne");
                 LongValue tailerTwoVersion = queue.indexVersionForId("replicated:tailerTwo");
                 LongValue tailerThreeVersion = queue.indexVersionForId("replicated:tailerThree");){
                Assert.assertEquals((long)0L, (long)tailerOneVersion.getValue());
                Assert.assertEquals((long)0L, (long)tailerTwoVersion.getValue());
                Assert.assertEquals((long)0L, (long)tailerThreeVersion.getValue());
            }
        }
        catch (Throwable throwable) {
            IOTools.deleteDirWithFiles((String[])new String[]{targetPath.toString()});
            throw throwable;
        }
        IOTools.deleteDirWithFiles((String[])new String[]{targetPath.toString()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void versionAndIndexRetentionAcrossMultipleLifecycles() {
        long index;
        Throwable throwable;
        File queuePath = this.getTmpDir();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.builder().path(queuePath).build();){
            throwable = null;
            try (ExcerptAppender appender = queue.createAppender();
                 ExcerptTailer tailer = queue.createTailer("replicated:named_1");){
                appender.writeText((CharSequence)"hello");
                tailer.readText();
                index = tailer.index();
                Assert.assertNotEquals((long)0L, (long)index);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        try {
            queue = SingleChronicleQueueBuilder.builder().path(queuePath).build();
            var5_3 = null;
            try {
                throwable = null;
                try (ExcerptTailer tailer = queue.createTailer("replicated:named_1");){
                    Assert.assertEquals((long)index, (long)tailer.index());
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable throwable4) {
                var5_3 = throwable4;
                throw throwable4;
            }
            finally {
                if (queue != null) {
                    if (var5_3 != null) {
                        try {
                            queue.close();
                        }
                        catch (Throwable throwable5) {
                            var5_3.addSuppressed(throwable5);
                        }
                    } else {
                        queue.close();
                    }
                }
            }
        }
        finally {
            IOTools.deleteDirWithFiles((File)queuePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void noVersionIncrements() {
        File queuePath = this.getTmpDir();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.builder().path(queuePath).build();
             ExcerptAppender appender = queue.createAppender();
             ExcerptTailer tailer = queue.createTailer("replicated:named_1");){
            LongValue indexVersion = queue.indexVersionForId("replicated:named_1");
            Assert.assertEquals((long)-1L, (long)indexVersion.getValue());
            indexVersion.close();
        }
        finally {
            IOTools.deleteDirWithFiles((File)queuePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void multipleVersionIncrements() {
        File queuePath = this.getTmpDir();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.builder().path(queuePath).build();
             ExcerptAppender appender = queue.createAppender();
             ExcerptTailer tailer = queue.createTailer("replicated:named_1");){
            int versions = 100;
            for (int i = 0; i < versions; ++i) {
                appender.writeText((CharSequence)"test");
                tailer.readText();
            }
            LongValue indexVersion = queue.indexVersionForId("replicated:named_1");
            Assert.assertEquals((long)100L, (long)indexVersion.getValue());
            indexVersion.close();
        }
        finally {
            IOTools.deleteDirWithFiles((File)queuePath);
        }
    }

    public void copyFolder(Path src, Path dest) throws IOException {
        try (Stream<Path> stream = Files.walk(src, new FileVisitOption[0]);){
            stream.forEach(source -> this.copy((Path)source, dest.resolve(src.relativize((Path)source))));
        }
    }

    private void copy(Path source, Path dest) {
        try {
            Files.copy(source, dest, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

