/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.table;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SingleTableStoreIntegrationTests
extends QueueTestCommon {
    private TestContext context;

    @Before
    public void beforeEach() {
        this.context = new TestContext();
    }

    @After
    public void after() throws IOException {
        this.context.close();
    }

    @Test
    public void baseCasePutAndGet() {
        this.context.newQueueInstance().tableStorePut((CharSequence)"a", 1L);
        Assert.assertEquals((long)1L, (long)this.context.newQueueInstance().tableStoreGet((CharSequence)"a"));
    }

    @Test
    public void getMissingKeyWithoutDefault() {
        Assert.assertEquals((long)Long.MIN_VALUE, (long)this.context.newQueueInstance().tableStoreGet((CharSequence)"test"));
    }

    @Test
    public void growNumberOfKeys() {
        SingleChronicleQueue queue1 = this.context.newQueueInstance();
        queue1.tableStorePut((CharSequence)"a", 1L);
        queue1.tableStorePut((CharSequence)"b", 2L);
        SingleChronicleQueue queue2 = this.context.newQueueInstance();
        queue2.tableStorePut((CharSequence)"c", 3L);
        SingleChronicleQueue queue3 = this.context.newQueueInstance();
        Assert.assertEquals((long)1L, (long)queue3.tableStoreGet((CharSequence)"a"));
        Assert.assertEquals((long)2L, (long)queue3.tableStoreGet((CharSequence)"b"));
        Assert.assertEquals((long)3L, (long)queue3.tableStoreGet((CharSequence)"c"));
    }

    @Test
    public void largeNumberOfKeyValuePairs() {
        int i;
        SingleChronicleQueue queue1 = this.context.newQueueInstance();
        int count = 5000;
        for (i = 0; i < count; ++i) {
            queue1.tableStorePut((CharSequence)("key.prefix." + i), (long)i);
        }
        for (i = 0; i < count; ++i) {
            Assert.assertEquals((long)i, (long)queue1.tableStoreGet((CharSequence)("key.prefix." + i)));
        }
    }

    @Test
    public void longKeyPutAndGet() {
        SingleChronicleQueue queue1 = this.context.newQueueInstance();
        StringBuilder keyBuffer = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < 121; ++i) {
            keyBuffer.append(random.nextInt(10));
        }
        String key = keyBuffer.toString();
        queue1.tableStorePut((CharSequence)key, 1L);
        Assert.assertEquals((long)1L, (long)this.context.newQueueInstance().tableStoreGet((CharSequence)key));
    }

    public class TestContext
    implements java.io.Closeable {
        private final File queuePath;
        private final List<SingleChronicleQueue> queues;

        public TestContext() {
            this.queuePath = SingleTableStoreIntegrationTests.this.getTmpDir();
            this.queues = new ArrayList<SingleChronicleQueue>();
        }

        public SingleChronicleQueue newQueueInstance() {
            SingleChronicleQueue queue = SingleChronicleQueueBuilder.builder().path(this.queuePath).build();
            this.queues.add(queue);
            return queue;
        }

        @Override
        public void close() throws IOException {
            this.queues.forEach(Closeable::closeQuietly);
            IOTools.deleteDirWithFiles((File)this.queuePath);
        }
    }
}

