/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single.stress.backwardstailer;

import java.io.File;
import java.nio.file.Paths;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.TailerDirection;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.stress.backwardstailer.BackwardsTailerToEndBoundaryJmhBenchmark;
import net.openhft.chronicle.queue.impl.single.stress.backwardstailer.BackwardsTailerToEndPerfAcceptanceTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackwardsTailerJmhState {
    private static final Logger log = LoggerFactory.getLogger(BackwardsTailerToEndPerfAcceptanceTest.class);
    protected ExcerptTailer tailer;
    private File queuePath;
    private SingleChronicleQueue queue;

    public void setup(int numberOfEntries) {
        this.queuePath = Paths.get(OS.getTarget(), BackwardsTailerToEndBoundaryJmhBenchmark.class.getSimpleName()).toFile();
        IOTools.deleteDirWithFiles((File)this.queuePath);
        RollCycles rollCycle = RollCycles.LARGE_DAILY;
        this.queue = SingleChronicleQueueBuilder.builder().path(this.queuePath).rollCycle((RollCycle)rollCycle).build();
        log.info("Populating queue with data");
        try (ExcerptAppender appender = this.queue.createAppender();){
            for (int i = 0; i < numberOfEntries; ++i) {
                appender.writeText((CharSequence)Integer.toString(i));
            }
        }
        log.info("Finished populating queue with data");
        this.tailer = this.queue.createTailer().direction(TailerDirection.BACKWARD);
        this.tailer.moveToIndex(0L);
    }

    public void runComplete() {
        this.tailer.toStart();
    }

    public void complete() {
        Closeable.closeQuietly((Object[])new Object[]{this.tailer, this.queue});
        IOTools.deleteDirWithFiles((File)this.queuePath);
    }

    public ExcerptTailer tailer() {
        return this.tailer;
    }

    public SingleChronicleQueue queue() {
        return this.queue;
    }
}

