/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single.stress;

import java.io.File;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.impl.RollingChronicleQueue;
import net.openhft.chronicle.queue.impl.single.stress.RollCycleMultiThreadStressTest;
import net.openhft.chronicle.queue.internal.main.InternalDumpMain;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.ValueIn;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@Ignore(value="double buffering is turned off currently")
public class RollCycleMultiThreadStressDoubleBufferTest
extends RollCycleMultiThreadStressTest {
    private AtomicBoolean queueDumped = new AtomicBoolean(false);

    public RollCycleMultiThreadStressDoubleBufferTest() {
        super(RollCycleMultiThreadStressTest.StressTestType.DOUBLEBUFFER);
    }

    @Override
    @Test
    public void stress() throws Exception {
        super.stress();
    }

    @Before
    public void setUp() {
        this.queueDumped = new AtomicBoolean(false);
    }

    public static void main(String[] args) throws Exception {
        new RollCycleMultiThreadStressDoubleBufferTest().run();
    }

    @Override
    protected RollCycleMultiThreadStressTest.ReaderCheckingStrategy getReaderCheckingStrategy() {
        return new DoubleBufferReaderCheckingStrategy(this.queueDumped);
    }

    class DoubleBufferReaderCheckingStrategy
    implements RollCycleMultiThreadStressTest.ReaderCheckingStrategy {
        private final AtomicBoolean queueDumped;
        private final HashSet<Integer> unexpectedValues = new HashSet();
        private final HashSet<Integer> skippedValue = new HashSet();
        private int outOfOrderCount = 0;

        DoubleBufferReaderCheckingStrategy(AtomicBoolean queueDumped) {
            this.queueDumped = queueDumped;
        }

        @Override
        public void checkDocument(DocumentContext dc, ExcerptTailer tailer, RollingChronicleQueue queue, int lastTailerCycle, int lastQueueCycle, int expected, ValueIn valueIn) {
            for (int i = 0; i < RollCycleMultiThreadStressDoubleBufferTest.this.NUMBER_OF_INTS; ++i) {
                int v = valueIn.int32();
                if (i != 0 || v == expected) continue;
                if (!this.unexpectedValues.remove(expected)) {
                    this.skippedValue.add(expected);
                }
                if (!this.skippedValue.remove(v)) {
                    this.unexpectedValues.add(v);
                }
                ++this.outOfOrderCount;
            }
        }

        @Override
        public void postReadCheck(RollingChronicleQueue queue) {
            Jvm.debug().on(this.getClass(), "Out-of-order count: " + this.outOfOrderCount);
            if (this.skippedValue.size() > 0 || this.unexpectedValues.size() > 0) {
                Jvm.error().on(this.getClass(), "Skipped " + this.skippedValue + ", Unexpected " + this.unexpectedValues);
                if (RollCycleMultiThreadStressDoubleBufferTest.this.DUMP_QUEUE && !this.queueDumped.getAndSet(true)) {
                    InternalDumpMain.dump((File)queue.file(), (PrintStream)System.out, (long)Long.MAX_VALUE);
                }
            }
        }
    }
}

