/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.TailerDirection;
import net.openhft.chronicle.queue.impl.single.HelloWorld;
import net.openhft.chronicle.queue.impl.single.OnEvents;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueStore;
import net.openhft.chronicle.queue.impl.single.ThreadLocalAppender;
import net.openhft.chronicle.queue.rollcycles.LegacyRollCycles;
import net.openhft.chronicle.queue.rollcycles.TestRollCycles;
import net.openhft.chronicle.testframework.ExecutorServiceUtil;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.MessageHistory;
import net.openhft.chronicle.wire.VanillaMessageHistory;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class StoreTailerTest
extends QueueTestCommon {
    private final Path dataDirectory = this.getTmpDir().toPath();

    @Override
    @Before
    public void threadDump() {
        super.threadDump();
    }

    @Test
    public void testEntryCount() {
        try (SingleChronicleQueue queue = ChronicleQueue.singleBuilder((Path)this.dataDirectory).build();
             ExcerptAppender appender = queue.createAppender();){
            Assert.assertEquals((long)0L, (long)queue.entryCount());
            try (DocumentContext dc = appender.writingDocument();){
                dc.wire().write((CharSequence)"test").text("value");
            }
            appender.sync();
            Assert.assertEquals((long)1L, (long)queue.entryCount());
        }
    }

    @Test
    public void shouldHandleCycleRollWhenInReadOnlyMode() {
        Assume.assumeFalse((String)"Read-only mode is not supported on Windows", (boolean)OS.isWindows());
        MutableTimeProvider timeProvider = new MutableTimeProvider();
        try (ChronicleQueue queue = this.build(this.createQueue(this.dataDirectory, (RollCycle)LegacyRollCycles.MINUTELY, 0, "cycleRoll", false).timeProvider((TimeProvider)timeProvider));
             ExcerptAppender appender = queue.createAppender();){
            OnEvents events = (OnEvents)appender.methodWriterBuilder(OnEvents.class).build();
            timeProvider.setTime(System.currentTimeMillis());
            events.onEvent("firstEvent");
            timeProvider.addTime(2L, TimeUnit.MINUTES);
            events.onEvent("secondEvent");
            appender.sync();
            try (ChronicleQueue readerQueue = this.build(this.createQueue(this.dataDirectory, (RollCycle)LegacyRollCycles.MINUTELY, 0, "cycleRoll", true).timeProvider((TimeProvider)timeProvider));){
                ExcerptTailer tailer = readerQueue.createTailer();
                tailer.sync();
                tailer.toStart();
                tailer.sync();
                try (DocumentContext context = tailer.readingDocument();){
                    Assert.assertTrue((boolean)context.isPresent());
                }
                tailer.sync();
                tailer.toEnd();
                tailer.sync();
                context = tailer.readingDocument();
                var11_17 = null;
                try {
                    Assert.assertFalse((boolean)context.isPresent());
                }
                catch (Throwable throwable) {
                    var11_17 = throwable;
                    throw throwable;
                }
                finally {
                    if (context != null) {
                        if (var11_17 != null) {
                            try {
                                context.close();
                            }
                            catch (Throwable throwable) {
                                var11_17.addSuppressed(throwable);
                            }
                        } else {
                            context.close();
                        }
                    }
                }
                tailer.sync();
            }
        }
    }

    @Test
    public void shouldConsiderSourceIdWhenDeterminingLastWrittenIndex() {
        try (ChronicleQueue firstInputQueue = this.createQueue(this.dataDirectory, (RollCycle)TestRollCycles.TEST_DAILY, 1, "firstInputQueue");
             ChronicleQueue secondInputQueue = this.createQueue(this.dataDirectory, (RollCycle)TestRollCycles.TEST_SECONDLY, 2, "secondInputQueue");
             ChronicleQueue outputQueue = this.createQueue(this.dataDirectory, (RollCycle)TestRollCycles.TEST_DAILY, 0, "outputQueue");){
            OnEvents firstWriter = (OnEvents)firstInputQueue.methodWriterBuilder(OnEvents.class).get();
            HelloWorld secondWriter = (HelloWorld)secondInputQueue.methodWriterBuilder(HelloWorld.class).get();
            firstWriter.onEvent("one");
            firstWriter.onEvent("two");
            secondWriter.hello("thirteen");
            secondWriter.hello("thirtyOne");
            OnEvents eventSink = (OnEvents)outputQueue.methodWriterBuilder(OnEvents.class).get();
            CapturingStringEvents outputWriter = new CapturingStringEvents(eventSink);
            MethodReader firstMethodReader = firstInputQueue.createTailer().methodReader(new Object[]{outputWriter});
            MethodReader secondMethodReader = secondInputQueue.createTailer().methodReader(new Object[]{outputWriter});
            Assert.assertTrue((boolean)firstMethodReader.readOne());
            Assert.assertTrue((boolean)firstMethodReader.readOne());
            Assert.assertFalse((boolean)firstMethodReader.readOne());
            Assert.assertTrue((boolean)secondMethodReader.readOne());
            Assert.assertTrue((boolean)secondMethodReader.readOne());
            Assert.assertFalse((boolean)secondMethodReader.readOne());
            secondInputQueue.createTailer().afterLastWritten(outputQueue);
        }
    }

    @Test
    public void checkAfterWrittenMessageAtIndexMovesToTheCorrectIndex() {
        try (ChronicleQueue firstInputQueue = this.createQueue(this.dataDirectory, (RollCycle)TestRollCycles.TEST_DAILY, 1, "firstInputQueue");
             ChronicleQueue secondInputQueue = this.createQueue(this.dataDirectory, (RollCycle)TestRollCycles.TEST_DAILY, 2, "secondInputQueue");
             ChronicleQueue outputQueue = this.createQueue(this.dataDirectory, (RollCycle)TestRollCycles.TEST_DAILY, 3, "outputQueue");){
            OnEvents firstWriter = (OnEvents)firstInputQueue.methodWriterBuilder(OnEvents.class).get();
            HelloWorld secondWriter = (HelloWorld)secondInputQueue.methodWriterBuilder(HelloWorld.class).get();
            firstWriter.onEvent("one");
            firstWriter.onEvent("two");
            secondWriter.hello("thirteen");
            secondWriter.hello("thirtyOne");
            OnEvents eventSink = (OnEvents)outputQueue.methodWriterBuilder(OnEvents.class).get();
            MessageHistory.get().reset();
            CapturingStringEvents outputWriter = new CapturingStringEvents(eventSink);
            ExcerptTailer tailer1 = firstInputQueue.createTailer();
            long index1 = tailer1.index();
            MethodReader firstMethodReader = tailer1.methodReader(new Object[]{outputWriter});
            ExcerptTailer tailer2 = secondInputQueue.createTailer();
            long index2 = tailer2.index();
            MethodReader secondMethodReader = tailer2.methodReader(new Object[]{outputWriter});
            Assert.assertTrue((boolean)firstMethodReader.readOne());
            Assert.assertTrue((boolean)secondMethodReader.readOne());
            VanillaMessageHistory mh = (VanillaMessageHistory)MessageHistory.get();
            mh.addSource(1, index1);
            mh.addTiming(System.nanoTime());
            mh.addSource(2, index2);
            mh.addTiming(System.nanoTime());
            outputWriter.onEvent("out1");
            ExcerptAppender appender = ThreadLocalAppender.acquireThreadLocalAppender((ChronicleQueue)outputQueue);
            long index = appender.lastIndexAppended();
            index1 = tailer1.index();
            index2 = tailer2.index();
            Assert.assertTrue((boolean)firstMethodReader.readOne());
            Assert.assertTrue((boolean)secondMethodReader.readOne());
            mh.reset();
            mh.addSource(1, index1);
            mh.addTiming(System.nanoTime());
            mh.addSource(2, index2);
            mh.addTiming(System.nanoTime());
            outputWriter.onEvent("out2");
            mh.reset();
            tailer1.afterWrittenMessageAtIndex(outputQueue, index);
            Assert.assertEquals((long)index1, (long)tailer1.index());
            tailer2.afterWrittenMessageAtIndex(outputQueue, index);
            Assert.assertEquals((long)index2, (long)tailer2.index());
        }
    }

    @Test
    public void shouldHandleCycleRoll() {
        File dir = this.getTmpDir();
        MutableTimeProvider timeProvider = new MutableTimeProvider();
        timeProvider.setTime(System.currentTimeMillis());
        try (SingleChronicleQueue chronicle = this.minutely(dir, timeProvider).build();
             SingleChronicleQueue chronicle2 = this.minutely(dir, timeProvider).build();
             ExcerptAppender append = chronicle2.createAppender();){
            ExcerptTailer tailer = chronicle.createTailer();
            timeProvider.addTime(10L, TimeUnit.MINUTES);
            append.writeDocument(w -> w.write((CharSequence)"test").text("text"));
            if (!tailer.readDocument(w -> w.read("test").text((Object)"text", Assert::assertEquals))) {
                Assert.fail((String)"readDocument false");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldHaltAtPartiallyInitialisedRollCycle() throws ExecutionException, InterruptedException {
        this.expectException("Renamed un-acquirable segment file to");
        File dir = this.getTmpDir();
        SetTimeProvider tp = new SetTimeProvider();
        try (SingleChronicleQueue producerQueue = this.createQueue(dir, (TimeProvider)tp, 500L);
             SingleChronicleQueue consumerQueue = this.createQueue(dir, (TimeProvider)tp, 1000L);){
            try (ExcerptAppender appender = producerQueue.createAppender();){
                appender.writeText((CharSequence)"one");
                appender.writeText((CharSequence)"two");
                tp.advanceMillis(TimeUnit.DAYS.toMillis(1L));
                appender.writeText((CharSequence)"three");
                appender.writeText((CharSequence)"four");
            }
            SingleChronicleQueueStore secondCycle = producerQueue.storeForCycle(1, 0L, false, null);
            MappedBytes bytes = secondCycle.bytes();
            bytes.writeInt(0L, Integer.MIN_VALUE);
            bytes.releaseLast();
            producerQueue.closeStore(secondCycle);
            ExecutorService ex = Executors.newFixedThreadPool(3);
            try (ExcerptTailer tailer = consumerQueue.createTailer();){
                String firstRead;
                Assert.assertEquals((Object)"one", (Object)tailer.readText());
                Assert.assertEquals((Object)"two", (Object)tailer.readText());
                Future<?> submit = ex.submit(() -> this.appendTwoMoreCycles(tp, producerQueue));
                while ((firstRead = tailer.readText()) == null) {
                    Jvm.pause((long)1L);
                }
                Assert.assertEquals((Object)"other-three", (Object)firstRead);
                Assert.assertEquals((Object)"other-four", (Object)tailer.readText());
                Assert.assertEquals((Object)"five", (Object)tailer.readText());
                Assert.assertEquals((Object)"six", (Object)tailer.readText());
                submit.get();
            }
            finally {
                ExecutorServiceUtil.shutdownAndWaitForTermination((ExecutorService)ex);
            }
        }
    }

    private void appendTwoMoreCycles(SetTimeProvider timeProvider, SingleChronicleQueue queue) {
        try (ExcerptAppender appender = queue.createAppender();){
            appender.writeText((CharSequence)"other-three");
            appender.writeText((CharSequence)"other-four");
            timeProvider.advanceMillis(TimeUnit.DAYS.toMillis(1L));
            appender.writeText((CharSequence)"five");
            appender.writeText((CharSequence)"six");
        }
    }

    private SingleChronicleQueue createQueue(File dir, TimeProvider timeProvider, long timeouMS) {
        return SingleChronicleQueueBuilder.binary((File)dir).timeProvider(timeProvider).rollCycle((RollCycle)RollCycles.FAST_DAILY).timeoutMS(timeouMS).build();
    }

    private SingleChronicleQueueBuilder minutely(@NotNull File file, TimeProvider timeProvider) {
        return SingleChronicleQueueBuilder.builder((File)file, (WireType)WireType.BINARY).rollCycle((RollCycle)LegacyRollCycles.MINUTELY).testBlockSize().timeProvider(timeProvider);
    }

    @NotNull
    private ChronicleQueue createQueue(Path dataDirectory, RollCycle rollCycle, int sourceId, String subdirectory) {
        return this.build(this.createQueue(dataDirectory, rollCycle, sourceId, subdirectory, false));
    }

    @NotNull
    private SingleChronicleQueueBuilder createQueue(Path dataDirectory, RollCycle rollCycle, int sourceId, String subdirectory, boolean readOnly) {
        return SingleChronicleQueueBuilder.binary((Path)dataDirectory.resolve(Paths.get(subdirectory, new String[0]))).sourceId(sourceId).testBlockSize().rollCycle(rollCycle).readOnly(readOnly);
    }

    private ChronicleQueue build(SingleChronicleQueueBuilder builder) {
        return builder.build();
    }

    @Test
    public void disableThreadSafety() throws InterruptedException {
        new ThreadSafetyTestingTemplate(){

            @Override
            void doOnFirstThread(SingleChronicleQueue singleChronicleQueue, ExcerptTailer tailer) {
                tailer.readText();
            }

            @Override
            void doOnSecondThread(ExcerptTailer tailer) {
                try {
                    tailer.readText();
                    Assert.fail();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                tailer.singleThreadedCheckDisabled(true);
                tailer.readText();
            }
        }.run();
    }

    @Test
    public void disableThreadSafetyWithMethodReader() throws InterruptedException {
        new ThreadSafetyTestingTemplate(){

            @Override
            void doOnFirstThread(SingleChronicleQueue queue, ExcerptTailer tailer) {
                StoreTailerTest.this.writeMethodCall(queue, "Testing1");
                StoreTailerTest.this.writeMethodCall(queue, "Testing2");
                Assert.assertEquals((Object)"Testing1", (Object)StoreTailerTest.this.readMethodCall(tailer));
            }

            @Override
            void doOnSecondThread(ExcerptTailer tailer) {
                try {
                    StoreTailerTest.this.readMethodCall(tailer);
                    Assert.fail();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                tailer.singleThreadedCheckDisabled(true);
                Assert.assertEquals((Object)"Testing2", (Object)StoreTailerTest.this.readMethodCall(tailer));
            }
        }.run();
    }

    @Test
    public void clearUsedByThread() throws InterruptedException {
        new ThreadSafetyTestingTemplate(){

            @Override
            void doOnFirstThread(SingleChronicleQueue singleChronicleQueue, ExcerptTailer tailer) {
                tailer.readText();
            }

            @Override
            void doOnSecondThread(ExcerptTailer tailer) {
                try {
                    tailer.readText();
                    Assert.fail();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                ((AbstractCloseable)tailer).singleThreadedCheckReset();
                tailer.readText();
            }
        }.run();
    }

    @Test
    public void clearUsedByThreadWithMethodReader() throws InterruptedException {
        new ThreadSafetyTestingTemplate(){

            @Override
            void doOnFirstThread(SingleChronicleQueue queue, ExcerptTailer tailer) {
                StoreTailerTest.this.writeMethodCall(queue, "Testing1");
                StoreTailerTest.this.writeMethodCall(queue, "Testing2");
                StoreTailerTest.this.writeMethodCall(queue, "Testing3");
                Assert.assertEquals((Object)"Testing1", (Object)StoreTailerTest.this.readMethodCall(tailer));
            }

            @Override
            void doOnSecondThread(ExcerptTailer tailer) {
                try {
                    StoreTailerTest.this.readMethodCall(tailer);
                    Assert.fail();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                ((AbstractCloseable)tailer).singleThreadedCheckReset();
                Assert.assertEquals((Object)"Testing2", (Object)StoreTailerTest.this.readMethodCall(tailer));
            }
        }.run();
    }

    private void writeMethodCall(SingleChronicleQueue queue, String message) {
        Foobar foobar = (Foobar)queue.methodWriter(Foobar.class, new Class[0]);
        foobar.say(message);
    }

    private String readMethodCall(ExcerptTailer tailer) {
        AtomicReference messageHolder = new AtomicReference();
        Object[] objectArray = new Object[1];
        objectArray[0] = messageHolder::set;
        MethodReader methodReader = tailer.methodReader(objectArray);
        methodReader.readOne();
        return (String)messageHolder.get();
    }

    @Test
    public void readMetaData() {
        File dir = this.getTmpDir();
        try (SingleChronicleQueue queue = ChronicleQueue.singleBuilder((File)dir).build();
             ExcerptTailer tailer = queue.createTailer();
             ExcerptAppender appender = queue.createAppender();){
            appender.writeText((CharSequence)"Hello World");
            try (DocumentContext dc = tailer.readingDocument(true);){
                Assert.assertTrue((boolean)dc.isPresent());
                Assert.assertTrue((boolean)dc.isMetaData());
                Assert.assertEquals((Object)"header", (Object)dc.wire().readEvent(String.class));
            }
        }
    }

    @Test
    public void toEndWorksWhenLastCycleIsEmpty() {
        Throwable throwable;
        ExcerptAppender appender;
        File dir = this.getTmpDir();
        SetTimeProvider stp = new SetTimeProvider();
        Supplier<SingleChronicleQueue> createQueue = () -> SingleChronicleQueueBuilder.binary((File)dir).timeProvider((TimeProvider)stp).rollCycle((RollCycle)TestRollCycles.TEST_SECONDLY).build();
        try (SingleChronicleQueue queue = createQueue.get();){
            appender = queue.createAppender();
            throwable = null;
            try {
                appender.writeText((CharSequence)"At index 0");
                appender.writeText((CharSequence)"At index 1");
                appender.writeText((CharSequence)"At index 2");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (appender != null) {
                    if (throwable != null) {
                        try {
                            appender.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        appender.close();
                    }
                }
            }
            stp.advanceMillis(100000L);
            appender = queue.createAppender();
            throwable = null;
            try (DocumentContext documentContext = appender.writingDocument();){
                documentContext.rollbackOnClose();
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (appender != null) {
                    if (throwable != null) {
                        try {
                            appender.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        appender.close();
                    }
                }
            }
        }
        queue = createQueue.get();
        var5_5 = null;
        try {
            appender = queue.createTailer();
            throwable = null;
            try {
                Assert.assertEquals((long)2L, (long)appender.direction(TailerDirection.BACKWARD).toEnd().index());
                Assert.assertEquals((long)3L, (long)appender.direction(TailerDirection.FORWARD).toEnd().index());
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (appender != null) {
                    if (throwable != null) {
                        try {
                            appender.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                    } else {
                        appender.close();
                    }
                }
            }
        }
        catch (Throwable throwable8) {
            var5_5 = throwable8;
            throw throwable8;
        }
        finally {
            if (queue != null) {
                if (var5_5 != null) {
                    try {
                        queue.close();
                    }
                    catch (Throwable throwable9) {
                        var5_5.addSuppressed(throwable9);
                    }
                } else {
                    queue.close();
                }
            }
        }
    }

    abstract class ThreadSafetyTestingTemplate {
        ThreadSafetyTestingTemplate() {
        }

        abstract void doOnFirstThread(SingleChronicleQueue var1, ExcerptTailer var2);

        abstract void doOnSecondThread(ExcerptTailer var1);

        public void run() throws InterruptedException {
            try (SingleChronicleQueue queue = ChronicleQueue.singleBuilder((Path)StoreTailerTest.this.dataDirectory).build();){
                LinkedBlockingQueue tq = new LinkedBlockingQueue();
                Thread t = new Thread(() -> {
                    ExcerptTailer tailer = queue.createTailer();
                    this.doOnFirstThread(queue, tailer);
                    tq.offer(tailer);
                    Jvm.pause((long)1000L);
                });
                t.start();
                this.doOnSecondThread((ExcerptTailer)tq.take());
                t.interrupt();
                t.join(1000L);
            }
        }
    }

    private static final class MutableTimeProvider
    implements TimeProvider {
        private long currentTimeMillis;

        private MutableTimeProvider() {
        }

        public long currentTimeMillis() {
            return this.currentTimeMillis;
        }

        void setTime(long millis) {
            this.currentTimeMillis = millis;
        }

        void addTime(long duration, TimeUnit unit) {
            this.currentTimeMillis += unit.toMillis(duration);
        }
    }

    private static final class CapturingStringEvents
    implements OnEvents,
    HelloWorld {
        private final OnEvents delegate;

        CapturingStringEvents(OnEvents delegate) {
            this.delegate = delegate;
        }

        @Override
        public void onEvent(String event) {
            this.delegate.onEvent(event);
        }

        @Override
        public void hello(String s) {
            this.delegate.onEvent(s);
        }
    }

    static interface Foobar {
        public void say(String var1);
    }
}

