/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.util.stream.Stream;
import net.openhft.chronicle.queue.TailerDirection;
import net.openhft.chronicle.queue.impl.single.IndexingTestCommon;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class IndexingToEndTest
extends IndexingTestCommon {
    IndexingToEndTest() {
    }

    @ParameterizedTest
    @MethodSource(value={"tailerDirections"})
    void fromStart_noData(TailerDirection tailerDirection) {
        this.tailer.direction(tailerDirection);
        Assertions.assertEquals((long)0L, (long)this.tailer.index());
        this.tailer.toEnd();
        Assertions.assertEquals((long)0L, (long)this.tailer.index());
    }

    @ParameterizedTest
    @MethodSource(value={"tailerDirections"})
    void fromStart_manyEntriesSingleCycle(TailerDirection tailerDirection) {
        this.tailer.direction(tailerDirection);
        Assertions.assertEquals((long)0L, (long)this.tailer.index());
        long lastIndexAppended = 0L;
        for (int i = 0; i < 1000; ++i) {
            this.appender.writeText((CharSequence)"<test>");
            lastIndexAppended = this.appender.lastIndexAppended();
        }
        this.tailer.toEnd();
        Assertions.assertEquals((long)this.expectedIndexAfterToEnd(lastIndexAppended, tailerDirection), (long)this.tailer.index());
    }

    @ParameterizedTest
    @MethodSource(value={"tailerDirections"})
    void fromStart_manyEntriesSingleCycle_idempotent(TailerDirection tailerDirection) {
        int i;
        this.tailer.direction(tailerDirection);
        Assertions.assertEquals((long)0L, (long)this.tailer.index());
        long lastIndexAppended = 0L;
        for (i = 0; i < 1000; ++i) {
            this.appender.writeText((CharSequence)"<test>");
            lastIndexAppended = this.appender.lastIndexAppended();
        }
        for (i = 0; i < 100; ++i) {
            this.tailer.toEnd();
            Assertions.assertEquals((long)this.expectedIndexAfterToEnd(lastIndexAppended, tailerDirection), (long)this.tailer.index());
        }
    }

    @ParameterizedTest
    @MethodSource(value={"tailerDirections"})
    void fromStart_manyEntriesMultiCycle(TailerDirection tailerDirection) {
        long lastIndexAppended = this.populateQueue(tailerDirection);
        this.tailer.toEnd();
        Assertions.assertEquals((int)2, (int)this.rollCycle().toCycle(lastIndexAppended));
        Assertions.assertEquals((long)this.expectedIndexAfterToEnd(lastIndexAppended, tailerDirection), (long)this.tailer.index());
    }

    @ParameterizedTest
    @MethodSource(value={"tailerDirections"})
    void fromMiddle_manyEntriesMultiCycle(TailerDirection tailerDirection) {
        long lastIndexAppended = this.populateQueue(tailerDirection);
        this.moveToMidpoint(lastIndexAppended);
        this.tailer.toEnd();
        Assertions.assertEquals((int)2, (int)this.rollCycle().toCycle(lastIndexAppended));
        Assertions.assertEquals((long)this.expectedIndexAfterToEnd(lastIndexAppended, tailerDirection), (long)this.tailer.index());
    }

    private void moveToMidpoint(long lastIndexAppended) {
        int cycle = this.queue.rollCycle().toCycle(lastIndexAppended);
        int middleCycle = cycle / 2;
        long desiredIndex = this.queue.rollCycle().toIndex(middleCycle, 0L);
        boolean moveToIndexResult = this.tailer.moveToIndex(desiredIndex);
        Assertions.assertTrue((boolean)moveToIndexResult);
        Assertions.assertEquals((long)desiredIndex, (long)this.tailer.index());
    }

    private long populateQueue(TailerDirection tailerDirection) {
        this.tailer.direction(tailerDirection);
        this.appender.writeText((CharSequence)"<init>");
        Assertions.assertEquals((long)0L, (long)this.tailer.index());
        long lastIndexAppended = 0L;
        for (int i = 0; i < 3; ++i) {
            this.appender.writeText((CharSequence)"<test>");
            this.timeProvider.advanceMillis(1001L);
            lastIndexAppended = this.appender.lastIndexAppended();
        }
        return lastIndexAppended;
    }

    public static Stream<TailerDirection> tailerDirections() {
        return Stream.of(TailerDirection.NONE, TailerDirection.FORWARD, TailerDirection.BACKWARD);
    }

    private long expectedIndexAfterToEnd(long lastIndexAppended, TailerDirection tailerDirection) {
        if (tailerDirection == TailerDirection.BACKWARD) {
            return lastIndexAppended;
        }
        return lastIndexAppended + 1L;
    }
}

