/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongConsumer;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class EntryCountNotBehindReadTest
extends QueueTestCommon {
    private static final int TOTAL_EVENTS = 100000;

    @Override
    @Before
    public void threadDump() {
        super.threadDump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExcerptsPerCycleNotBehind() throws IOException {
        File file = Files.createTempDirectory("exact-excerpts-per-cycle", new FileAttribute[0]).toFile();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)file).build();
             ExcerptTailer tailer = queue.createTailer();){
            CyclicBarrier startBarrier = new CyclicBarrier(3);
            AtomicLong lastIndex = new AtomicLong();
            Thread reader = new Thread(() -> this.runReader(queue, startBarrier, lastIndex::set));
            this.startWriter(queue, startBarrier);
            reader.start();
            EntryCountNotBehindReadTest.waitOn(startBarrier);
            while (reader.isAlive()) {
                long readIndex = lastIndex.get();
                if (readIndex == 0L) continue;
                this.checkExactExcerptCount(queue, readIndex, tailer);
            }
        }
        finally {
            IOTools.deleteDirWithFiles((File)file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testToEndNotBehind() throws IOException {
        File file = Files.createTempDirectory("to-end", new FileAttribute[0]).toFile();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)file).build();){
            CyclicBarrier startBarrier = new CyclicBarrier(3);
            AtomicLong lastIndex = new AtomicLong();
            Thread reader = new Thread(() -> this.runReader(queue, startBarrier, lastIndex::set));
            this.startWriter(queue, startBarrier);
            reader.start();
            EntryCountNotBehindReadTest.waitOn(startBarrier);
            while (reader.isAlive()) {
                long readIndex = lastIndex.get();
                if (readIndex == 0L) continue;
                this.checkToEnd(queue, readIndex);
            }
        }
        finally {
            IOTools.deleteDirWithFiles((File)file);
        }
    }

    private void checkExactExcerptCount(SingleChronicleQueue queue, long readIndex, ExcerptTailer tailer) {
        long excerptCount;
        RollCycle cycleType = queue.rollCycle();
        int cycle = cycleType.toCycle(readIndex);
        long readCount = cycleType.toSequenceNumber(readIndex) + 1L;
        Assert.assertFalse((readCount > (excerptCount = tailer.excerptsInCycle(cycle)) ? 1 : 0) != 0);
    }

    private void checkToEnd(SingleChronicleQueue queue, long readIndex) {
        RollCycle cycleType = queue.rollCycle();
        int cycle = cycleType.toCycle(readIndex);
        long readCount = cycleType.toSequenceNumber(readIndex) + 1L;
        long excerptCount = 0L;
        try (ExcerptTailer tailer = queue.createTailer();){
            if (tailer.moveToCycle(cycle)) {
                excerptCount = cycleType.toSequenceNumber(tailer.toEnd().index());
            }
        }
        Assert.assertFalse((readCount > excerptCount ? 1 : 0) != 0);
    }

    private void startWriter(SingleChronicleQueue queue, CyclicBarrier startBarrier) {
        new Thread(() -> {
            EntryCountNotBehindReadTest.waitOn(startBarrier);
            try (ExcerptAppender excerptAppender = queue.createAppender();){
                for (int i = 0; i < 100000; ++i) {
                    excerptAppender.writingDocument().close();
                }
            }
        }).start();
    }

    private void runReader(SingleChronicleQueue queue, CyclicBarrier startBarrier, LongConsumer onRead) {
        try (ExcerptTailer tailer = queue.createTailer();){
            EntryCountNotBehindReadTest.waitOn(startBarrier);
            int count = 0;
            while (count < 100000) {
                DocumentContext entry = tailer.readingDocument();
                Throwable throwable = null;
                try {
                    if (!entry.isData() || entry.isNotComplete()) continue;
                    onRead.accept(entry.index());
                    ++count;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (entry == null) continue;
                    if (throwable != null) {
                        try {
                            entry.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    entry.close();
                }
            }
        }
    }

    private static void waitOn(CyclicBarrier barrier) {
        try {
            barrier.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | BrokenBarrierException | TimeoutException e) {
            throw new IllegalStateException(e);
        }
    }
}

