/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.cleanup;

import java.util.concurrent.atomic.AtomicInteger;
import net.openhft.chronicle.bytes.PageUtil;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.BackgroundResourceReleaser;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.core.util.Time;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.rollcycles.LegacyRollCycles;
import net.openhft.chronicle.testframework.FlakyTestRunner;
import org.junit.Assert;
import org.junit.Test;

public class OnReleaseTest
extends QueueTestCommon {
    @Test
    public void onRelease() throws Throwable {
        FlakyTestRunner.builder(this::onRelease0).build().run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRelease0() {
        String path = OS.getTarget() + "/onRelease-" + Time.uniqueId();
        SetTimeProvider stp = new SetTimeProvider();
        AtomicInteger writeRoll = new AtomicInteger();
        AtomicInteger readRoll = new AtomicInteger();
        try (SingleChronicleQueue writeQ = SingleChronicleQueueBuilder.binary((String)path).rollCycle((RollCycle)LegacyRollCycles.MINUTELY).timeProvider((TimeProvider)stp).storeFileListener((c, f) -> {
            System.out.println("write released " + f);
            writeRoll.incrementAndGet();
        }).build();
             SingleChronicleQueue readQ = SingleChronicleQueueBuilder.binary((String)path).rollCycle((RollCycle)LegacyRollCycles.MINUTELY).timeProvider((TimeProvider)stp).storeFileListener((c, f) -> {
            System.out.println("read released " + f);
            readRoll.incrementAndGet();
        }).build();
             ExcerptAppender appender = writeQ.createAppender();
             ExcerptTailer tailer = readQ.createTailer();){
            int messageCount = PageUtil.isHugePage((String)path) ? 10 : 500;
            for (int i = 0; i < messageCount; ++i) {
                appender.writeText((CharSequence)("hello-" + i));
                Assert.assertNotNull((Object)tailer.readText());
                BackgroundResourceReleaser.releasePendingResources();
                Assert.assertEquals((long)i, (long)writeRoll.get());
                Assert.assertEquals((long)i, (long)readRoll.get());
                stp.advanceMillis(66000L);
            }
        }
        catch (Throwable throwable) {
            IOTools.deleteDirWithFiles((String[])new String[]{path});
            throw throwable;
        }
        IOTools.deleteDirWithFiles((String[])new String[]{path});
    }
}

