/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.bench;

import net.openhft.affinity.AffinityLock;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.BackgroundResourceReleaser;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.util.Time;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.rollcycles.SparseRollCycles;
import net.openhft.chronicle.wire.DocumentContext;

public class ThroughputPerfMain {
    private static final int TIME = Integer.getInteger("time", 30);
    private static final int SIZE = Integer.getInteger("size", 40);
    private static final String PATH = System.getProperty("path", OS.TMP);
    private static final long blockSizeMB = Long.getLong("blockSizeMB", OS.isSparseFileSupported() ? 524288L : 256L);
    private static BytesStore nbs;

    public static void main(String[] args) {
        String base = PATH + "/delete-" + Time.uniqueId() + ".me";
        long start = System.nanoTime();
        long count = 0L;
        nbs = BytesStore.nativeStoreWithFixedCapacity((long)SIZE);
        AffinityLock lock = AffinityLock.acquireCore();
        try (SingleChronicleQueue q = ChronicleQueue.singleBuilder((String)base).rollCycle((RollCycle)SparseRollCycles.LARGE_HOURLY_XSPARSE).blockSize(blockSizeMB << 20).build();
             ExcerptAppender appender = q.createAppender();){
            do {
                try (DocumentContext dc = appender.writingDocument();){
                    dc.wire().bytes().write(nbs);
                }
                ++count;
            } while ((double)start + (double)TIME * 1.0E9 > (double)System.nanoTime());
        }
        nbs.releaseLast();
        long mid = System.nanoTime();
        long time1 = mid - start;
        NativeBytes bytes = Bytes.allocateElasticDirect((long)SIZE);
        try (SingleChronicleQueue q = ChronicleQueue.singleBuilder((String)base).rollCycle((RollCycle)SparseRollCycles.LARGE_HOURLY_XSPARSE).blockSize(blockSizeMB << 20).build();){
            ExcerptTailer tailer = q.createTailer();
            for (long i = 0L; i < count; ++i) {
                try (DocumentContext dc = tailer.readingDocument();){
                    bytes.clear();
                    bytes.write((BytesStore)dc.wire().bytes());
                    continue;
                }
            }
        }
        bytes.releaseLast();
        long end = System.nanoTime();
        long time2 = end - mid;
        lock.close();
        System.out.println("-Dtime=" + TIME + " -Dsize=" + SIZE + " -Dpath=" + PATH + " - DblockSizeMB=" + blockSizeMB);
        System.out.printf("Writing %,d messages took %.3f seconds, at a rate of %,d per second, with an average latency of %,d ns%n", count, (double)time1 / 1.0E9, (long)(1.0E9 * (double)count / (double)time1), time1 / count);
        System.out.printf("Reading %,d messages took %.3f seconds, at a rate of %,d per second, with an average latency of %,d ns%n", count, (double)time2 / 1.0E9, (long)(1.0E9 * (double)count / (double)time2), time2 / count);
        BackgroundResourceReleaser.releasePendingResources();
        System.gc();
        IOTools.deleteDirWithFiles((String)base, (int)2);
    }
}

