/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.bench;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.util.NanoSampler;
import net.openhft.chronicle.jlbh.JLBH;
import net.openhft.chronicle.jlbh.JLBHOptions;
import net.openhft.chronicle.jlbh.JLBHTask;
import net.openhft.chronicle.jlbh.TeamCityHelper;
import net.openhft.chronicle.queue.ChronicleQueue;

public class MethodReaderSkipBenchmark
implements JLBHTask {
    private static final String PAYLOAD = "this is a string which is here to provide a payload for the method reader to skip over";
    private static int iterations;
    private JLBH jlbh;
    private ChronicleQueue queue;
    private NanoSampler noopSampler;
    private NanoSampler wroteSampler;
    private AnInterface writer;
    private MethodReader reader;
    private int counter = 0;

    public static void main(String[] args) {
        iterations = Integer.getInteger("benchmarkIterations", 100000);
        System.out.println("Iterations: " + iterations);
        int throughput = Integer.getInteger("benchmarkThroughput", 20000);
        System.out.println("Throughput: " + throughput);
        JLBHOptions lth = new JLBHOptions().warmUpIterations(100000).iterations(iterations).throughput(throughput).recordOSJitter(false).accountForCoordinatedOmission(true).skipFirstRun(true).runs(5).jlbhTask((JLBHTask)new MethodReaderSkipBenchmark());
        new JLBH(lth).start();
    }

    public void init(JLBH jlbh) {
        this.jlbh = jlbh;
        this.noopSampler = jlbh.addProbe("noop");
        this.wroteSampler = jlbh.addProbe("wrote");
        String benchmarkQueuePath = System.getProperty("benchmarkQueuePath");
        if (benchmarkQueuePath != null) {
            System.out.println("Creating queue in dir: " + benchmarkQueuePath);
            IOTools.deleteDirWithFiles((String)benchmarkQueuePath, (int)10);
            this.queue = ChronicleQueue.single((String)benchmarkQueuePath);
        } else {
            System.out.println("Creating queue in temp dir");
            try {
                this.queue = ChronicleQueue.single((String)Files.createTempDirectory("temp", new FileAttribute[0]).toString());
            }
            catch (IOException e) {
                throw new IORuntimeException((Throwable)e);
            }
        }
        this.writer = (AnInterface)this.queue.methodWriter(AnInterface.class, new Class[0]);
        this.reader = this.queue.createTailer().methodReader(new Object[]{s -> {
            throw new IllegalStateException("should not be called");
        }});
    }

    public void run(long startTimeNS) {
        boolean writeSomething;
        boolean bl = writeSomething = this.counter++ % 2 == 0;
        if (writeSomething) {
            this.writer.stringMethod(PAYLOAD);
        }
        long beforeReadNS = System.nanoTime();
        this.reader.readOne();
        long endTimeNS = System.nanoTime();
        if (writeSomething) {
            this.wroteSampler.sampleNanos(endTimeNS - beforeReadNS);
        } else {
            this.noopSampler.sampleNanos(endTimeNS - beforeReadNS);
        }
        this.jlbh.sample(endTimeNS - startTimeNS);
    }

    public void complete() {
        this.queue.close();
        TeamCityHelper.teamCityStatsLastRun((String)this.getClass().getSimpleName(), (JLBH)this.jlbh, (long)iterations, (PrintStream)System.out);
    }

    static interface AnotherInterface {
        public void otherMethod(String var1);
    }

    static interface AnInterface {
        public void stringMethod(String var1);
    }
}

