/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.bench;

import java.io.PrintStream;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.io.BackgroundResourceReleaser;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.jlbh.JLBH;
import net.openhft.chronicle.jlbh.JLBHOptions;
import net.openhft.chronicle.jlbh.JLBHTask;
import net.openhft.chronicle.jlbh.TeamCityHelper;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.InternalAppender;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;

public class InternalAppenderJLBH
implements JLBHTask {
    private static final String QUEUE_PATH = "internalAppend";
    private static final int ITERATIONS = 200000;
    private static final int WARMUP_ITERATIONS = 50000;
    private final RollCycle rollCycle;
    private SingleChronicleQueue queue;
    private SetTimeProvider timeProvider;
    private InternalAppender appender;
    private int sequenceNumber;
    private Bytes<?> payload;
    private JLBH jlbh;

    public InternalAppenderJLBH(RollCycle rollCycle) {
        this.rollCycle = rollCycle;
    }

    public static void main(String ... args) {
        new JLBH(new JLBHOptions().jlbhTask((JLBHTask)new InternalAppenderJLBH((RollCycle)RollCycles.DEFAULT)).iterations(200000).warmUpIterations(50000).accountForCoordinatedOmission(false).runs(3)).start();
    }

    public void init(JLBH jlbh) {
        IOTools.deleteDirWithFiles((String[])new String[]{QUEUE_PATH});
        this.timeProvider = new SetTimeProvider();
        this.payload = Bytes.from((String)"hello world");
        this.queue = SingleChronicleQueueBuilder.binary((String)QUEUE_PATH).rollCycle(this.rollCycle).timeProvider((TimeProvider)this.timeProvider).build();
        this.appender = (InternalAppender)this.queue.acquireAppender();
        this.jlbh = jlbh;
    }

    public void run(long startTimeNS) {
        long index = this.rollCycle.toIndex(0, (long)this.sequenceNumber);
        this.appender.writeBytes(index, this.payload);
        this.jlbh.sample(System.nanoTime() - startTimeNS);
        ++this.sequenceNumber;
    }

    public void complete() {
        TeamCityHelper.teamCityStatsLastRun((String)(InternalAppenderJLBH.class.getSimpleName() + "-SAFE"), (JLBH)this.jlbh, (long)200000L, (PrintStream)System.out);
        Closeable.closeQuietly((Object[])new Object[]{this.appender, this.queue});
        BackgroundResourceReleaser.releasePendingResources();
        IOTools.deleteDirWithFiles((String[])new String[]{QUEUE_PATH});
    }

    static {
        System.setProperty("jvm.resource.tracing", "false");
    }
}

