/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.nio.file.Paths;
import java.util.Random;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.UncheckedBytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.util.Histogram;
import net.openhft.chronicle.core.util.Time;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class TailerCloseInParallelTest
extends QueueTestCommon {
    static String file = OS.getTarget() + "/deleteme-" + Time.uniqueId();
    static final int size = 1024;
    static int s32;
    static long s64;
    static float f32;
    static double f64;
    static String s;
    static Random random;

    @Override
    @Before
    public void threadDump() {
        super.threadDump();
    }

    @AfterClass
    public static void cleanup() {
        IOTools.deleteDirWithFiles((String)file, (int)3);
    }

    @Test
    public void runTenTimes() throws InterruptedException {
        this.finishedNormally = false;
        Assume.assumeTrue((boolean)OS.is64Bit());
        for (int t = 10; t >= 1; --t) {
            try {
                TailerCloseInParallelTest.doPerfTest(file, bytes -> TailerCloseInParallelTest.writeMany(bytes, 1024), bytes -> TailerCloseInParallelTest.readMany(bytes, 1024), 2000, t == 1);
                continue;
            }
            catch (ClosedIllegalStateException ex) {
                System.err.println("Caught expected: " + (Object)((Object)ex));
                break;
            }
        }
        Paths.get(file, new String[0]).toFile().delete();
        this.finishedNormally = true;
    }

    static void doPerfTest(String file, TestWriter<Bytes<?>> writer, TestReader<Bytes<?>> reader, int count, boolean print) throws InterruptedException {
        Histogram writeHdr = new Histogram(30, 7);
        Histogram readHdr = new Histogram(30, 7);
        try (SingleChronicleQueue chronicle = SingleChronicleQueueBuilder.single((String)file).testBlockSize().rollCycle((RollCycle)RollCycles.FIVE_MINUTELY).build();
             ExcerptTailer tailer0 = chronicle.createTailer();){
            Bytes bytes02;
            Throwable throwable;
            int i;
            System.err.println("End is " + Long.toHexString(tailer0.toEnd().index()));
            Thread thread = new Thread(() -> {
                tailer0.singleThreadedCheckReset();
                for (int i = 0; i < random.nextInt(10); ++i) {
                    Jvm.pause((long)1L);
                    DocumentContext dc = tailer0.readingDocument();
                    Throwable throwable = null;
                    if (dc == null) continue;
                    if (throwable != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        continue;
                    }
                    dc.close();
                }
                Closeable.closeQuietly((Object)tailer0);
            });
            thread.start();
            UncheckedBytes bytes = new UncheckedBytes(BytesStore.empty().bytesForRead());
            try (ExcerptAppender appender = chronicle.createAppender();){
                for (i = 0; i < count; ++i) {
                    long start = System.nanoTime();
                    throwable = null;
                    try (DocumentContext dc = appender.writingDocument();){
                        bytes02 = dc.wire().bytes();
                        bytes02.ensureCapacity(1024L);
                        bytes.setBytes(bytes02);
                        bytes.readPosition(bytes.writePosition());
                        writer.writeTo((Bytes<?>)bytes);
                        bytes02.writePosition(bytes.writePosition());
                    }
                    catch (Throwable bytes02) {
                        throwable = bytes02;
                        throw bytes02;
                    }
                    long time = System.nanoTime() - start;
                    writeHdr.sample((double)time);
                }
                System.err.println("... Wrote " + Long.toHexString(appender.lastIndexAppended()));
            }
            var14_18 = null;
            try (ExcerptTailer tailer = chronicle.createTailer();){
                for (i = 0; i < count; ++i) {
                    long start2 = System.nanoTime();
                    throwable = null;
                    try (DocumentContext dc = tailer.readingDocument();){
                        Assert.assertTrue((boolean)dc.isPresent());
                        bytes02 = dc.wire().bytes();
                        bytes.setBytes(bytes02);
                        reader.readFrom((Bytes<?>)bytes);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    long time2 = System.nanoTime() - start2;
                    readHdr.sample((double)time2);
                }
                System.err.println("... End is now " + Long.toHexString(tailer.toEnd().index()));
                if (print) {
                    System.out.println("Write latencies " + writeHdr.toMicrosFormat());
                    System.out.println("Read latencies " + readHdr.toMicrosFormat());
                }
            }
            catch (Throwable throwable3) {
                var14_18 = throwable3;
                throw throwable3;
            }
            bytes.releaseLast();
            thread.join();
        }
    }

    static void writeMany(Bytes<?> bytes, int size) {
        for (int i = 0; i < size; i += 32) {
            bytes.writeInt(i);
            bytes.writeFloat((float)i);
            bytes.writeLong((long)i);
            bytes.writeDouble((double)i);
            bytes.writeUtf8("Hello!!");
        }
    }

    static void readMany(Bytes<?> bytes, int size) {
        for (int i = 0; i < size; i += 32) {
            s32 = bytes.readInt();
            f32 = bytes.readFloat();
            s64 = bytes.readLong();
            f64 = bytes.readDouble();
            s = bytes.readUtf8();
            Assert.assertEquals((Object)"Hello!!", (Object)s);
        }
    }

    static {
        random = new Random();
    }

    static interface TestReader<T> {
        public void readFrom(T var1);
    }

    static interface TestWriter<T> {
        public void writeTo(T var1);
    }
}

