/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.io.InvalidMarshallableException;
import net.openhft.chronicle.core.util.Time;
import net.openhft.chronicle.queue.BufferMode;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.threads.NamedThreadFactory;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OvertakeTest
extends QueueTestCommon {
    private String path;
    private long a_index;
    private int messages = 500;

    private static long doReadBad(@NotNull ExcerptTailer tailer, int expected, boolean additionalClose) {
        int[] i = new int[]{0};
        long t_index = 0L;
        while (true) {
            DocumentContext dc = tailer.readingDocument();
            Throwable throwable = null;
            try {
                if (!dc.isPresent()) break;
                t_index = tailer.index();
                dc.wire().read("log").marshallable(m -> {
                    String msg = m.read("msg").text();
                    Assert.assertNotNull((Object)msg);
                    i[0] = i[0] + 1;
                });
                if (!additionalClose) continue;
                dc.close();
                continue;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dc == null) continue;
                if (throwable != null) {
                    try {
                        dc.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dc.close();
                continue;
            }
            break;
        }
        Assert.assertEquals((long)expected, (long)i[0]);
        return t_index;
    }

    @Before
    public void before() {
        this.path = OS.getTarget() + "/" + this.getClass().getSimpleName() + "-" + Time.uniqueId();
        try (SingleChronicleQueue appender_queue = ChronicleQueue.singleBuilder((String)this.path).testBlockSize().writeBufferMode(BufferMode.None).build();
             ExcerptAppender appender = appender_queue.createAppender();){
            for (int i = 0; i < this.messages; ++i) {
                long l = i;
                appender.writeDocument(wireOut -> wireOut.write((CharSequence)"log").marshallable(m -> {
                    m.write((CharSequence)"msg").text("hello world ola multi-verse");
                    m.write((CharSequence)"ts").int64(l);
                }));
            }
            this.a_index = appender.lastIndexAppended();
        }
    }

    @Override
    @Before
    public void threadDump() {
        super.threadDump();
    }

    @Test
    public void appendAndTail() {
        try (SingleChronicleQueue tailer_queue = ChronicleQueue.singleBuilder((String)this.path).testBlockSize().writeBufferMode(BufferMode.None).build();){
            ExcerptTailer tailer = tailer_queue.createTailer();
            tailer = tailer.toStart();
            long t_index = OvertakeTest.doReadBad(tailer, this.messages, false);
            Assert.assertEquals((long)this.a_index, (long)t_index);
            tailer = tailer_queue.createTailer();
            tailer = tailer.toStart();
            t_index = OvertakeTest.doReadBad(tailer, this.messages, true);
            Assert.assertEquals((long)this.a_index, (long)t_index);
        }
    }

    @Override
    public void tearDown() {
        try {
            IOTools.deleteDirWithFiles((String)this.path, (int)2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void threadingTest() throws InterruptedException, ExecutionException, TimeoutException {
        ExecutorService execService = Executors.newFixedThreadPool(2, (ThreadFactory)new NamedThreadFactory("test"));
        SynchronousQueue<Long> sync = new SynchronousQueue<Long>();
        MyAppender myapp = new MyAppender(sync);
        Future<Long> f = execService.submit(myapp);
        try (SingleChronicleQueue tailer_queue = ChronicleQueue.singleBuilder((String)this.path).testBlockSize().writeBufferMode(BufferMode.None).build();){
            long t_index = 0L;
            MyTailer mytailer = new MyTailer((ChronicleQueue)tailer_queue, t_index, sync);
            Future<Long> f2 = execService.submit(mytailer);
            t_index = f2.get(10L, TimeUnit.SECONDS);
            this.a_index = f.get(10L, TimeUnit.SECONDS);
            Assert.assertEquals((long)this.a_index, (long)t_index);
        }
        execService.shutdown();
        execService.awaitTermination(1L, TimeUnit.SECONDS);
    }

    static /* synthetic */ String access$000(OvertakeTest x0) {
        return x0.path;
    }

    class MyTailer
    implements Callable<Long> {
        ChronicleQueue queue;
        long startIndex;
        SynchronousQueue<Long> sync;

        MyTailer(ChronicleQueue q, long s, SynchronousQueue<Long> sync) {
            this.queue = q;
            this.startIndex = s;
            this.sync = sync;
        }

        @Override
        public Long call() throws InterruptedException {
            ExcerptTailer tailer = this.queue.createTailer();
            tailer.moveToIndex(this.startIndex);
            Long fromWriter = this.sync.take();
            long index = OvertakeTest.doReadBad(tailer, OvertakeTest.this.messages + 50, false);
            if (index != fromWriter) {
                // empty if block
            }
            this.sync.put(index);
            fromWriter = this.sync.take();
            index = OvertakeTest.doReadBad(tailer, 50, false);
            if (index != fromWriter) {
                // empty if block
            }
            return index;
        }
    }

    class MyAppender
    implements Callable<Long> {
        SynchronousQueue<Long> sync;

        MyAppender(SynchronousQueue<Long> sync) {
            this.sync = sync;
        }

        /*
         * Exception decompiling
         */
        @Override
        public Long call() throws InterruptedException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static /* synthetic */ void lambda$call$3(WireOut wireOut) throws InvalidMarshallableException {
            wireOut.write((CharSequence)"log").marshallable(m -> m.write((CharSequence)"msg").text("hello world2 "));
        }

        private static /* synthetic */ void lambda$call$1(WireOut wireOut) throws InvalidMarshallableException {
            wireOut.write((CharSequence)"log").marshallable(m -> m.write((CharSequence)"msg").text("hello world2 "));
        }
    }
}

