/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.util.function.BiConsumer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.HexDumpBytesDescription;
import net.openhft.chronicle.bytes.util.BinaryLengthLength;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Memory;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.InvalidMarshallableException;
import net.openhft.chronicle.core.time.SystemTimeProvider;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.HashWire;
import net.openhft.chronicle.wire.MessageHistory;
import net.openhft.chronicle.wire.SelfDescribingMarshallable;
import net.openhft.chronicle.wire.SourceContext;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.converter.NanoTime;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaMessageHistory
extends SelfDescribingMarshallable
implements MessageHistory {
    public static final int MESSAGE_HISTORY_LENGTH = 128;
    public static final int MAX_LENGTH = 4098;
    private static final ThreadLocal<MessageHistory> THREAD_LOCAL = ThreadLocal.withInitial(() -> {
        @NotNull VanillaMessageHistory veh = new VanillaMessageHistory();
        veh.addSourceDetails(true);
        return veh;
    });
    private static final boolean HISTORY_SELF_DESCRIBING = Jvm.getBoolean("history.self.describing");
    private static final boolean HISTORY_AS_BYTES = Jvm.getBoolean("history.as.bytes", !HISTORY_SELF_DESCRIBING);
    private static final boolean HISTORY_WALL_CLOCK = Jvm.getBoolean("history.wall.clock");
    private boolean useBytesMarshallable = HISTORY_AS_BYTES;
    private boolean historyWallClock = HISTORY_WALL_CLOCK;
    @NotNull
    private final int[] sourceIdArray = new int[128];
    @NotNull
    private final long[] sourceIndexArray = new long[128];
    @NotNull
    private final long[] timingsArray = new long[256];
    private final transient BiConsumer<VanillaMessageHistory, ValueOut> acceptSourcesConsumer = this::acceptSources;
    private final transient BiConsumer<VanillaMessageHistory, ValueOut> acceptTimingsConsumer = this::acceptTimings;
    private transient boolean dirty;
    private int sources;
    private int timings;
    private boolean addSourceDetails = false;

    static MessageHistory getThreadLocal() {
        return THREAD_LOCAL.get();
    }

    static void setThreadLocal(MessageHistory md) {
        if (md == null) {
            THREAD_LOCAL.remove();
        } else {
            THREAD_LOCAL.set(md);
        }
    }

    private static void acceptSourcesRead(VanillaMessageHistory t, ValueIn in) {
        while (in.hasNextSequenceItem()) {
            t.addSource(in.int32(), in.int64());
        }
    }

    private static void acceptTimingsRead(VanillaMessageHistory t, ValueIn in) {
        while (in.hasNextSequenceItem()) {
            t.addTiming(in.int64());
        }
    }

    public void addSourceDetails(boolean addSourceDetails) {
        this.addSourceDetails = addSourceDetails;
    }

    @Override
    public void reset() {
        this.timings = 0;
        this.sources = 0;
    }

    public boolean addSourceDetails() {
        return this.addSourceDetails;
    }

    @Override
    public void reset(int sourceId, long sourceIndex) {
        this.sources = 1;
        this.sourceIdArray[0] = sourceId;
        this.sourceIndexArray[0] = sourceIndex;
        this.timings = 1;
        this.timingsArray[0] = this.nanoTime();
    }

    @Override
    public int lastSourceId() {
        return this.sources <= 0 ? -1 : this.sourceIdArray[this.sources - 1];
    }

    @Override
    public long lastSourceIndex() {
        return this.sources <= 0 ? -1L : this.sourceIndexArray[this.sources - 1];
    }

    @Override
    public int timings() {
        return this.timings;
    }

    @Override
    public long timing(int n) {
        return this.timingsArray[n];
    }

    @Override
    public int sources() {
        return this.sources;
    }

    @Override
    public int sourceId(int n) {
        return this.sourceIdArray[n];
    }

    @Override
    public boolean sourceIdsEndsWith(int[] sourceIds) {
        int start = this.sources - sourceIds.length;
        if (start < 0) {
            return false;
        }
        for (int i = 0; i < sourceIds.length; ++i) {
            if (this.sourceId(start + i) == sourceIds[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public long sourceIndex(int n) {
        return this.sourceIndexArray[n];
    }

    @Override
    public void readMarshallable(@NotNull WireIn wire) throws IORuntimeException, InvalidMarshallableException {
        Bytes<?> bytes = wire.bytes();
        if (bytes.peekUnsignedByte() == 134) {
            bytes.readSkip(1L);
            if (bytes.canReadDirect(4098L)) {
                this.readMarshallableDirect(bytes);
            } else {
                this.readMarshallable0(bytes);
            }
        } else {
            this.sources = 0;
            wire.read("sources").sequence(this, VanillaMessageHistory::acceptSourcesRead);
            this.timings = 0;
            wire.read("timings").sequence(this, VanillaMessageHistory::acceptTimingsRead);
        }
        if (this.addSourceDetails) {
            @Nullable Object o = wire.parent();
            if (o instanceof SourceContext) {
                @Nullable SourceContext dc = (SourceContext)o;
                this.addSource(dc.sourceId(), dc.index());
            }
            this.addTiming(this.nanoTime());
        }
    }

    @Override
    public void writeMarshallable(@NotNull WireOut wire) {
        if (this.useBytesMarshallable && wire.isBinary()) {
            wire.bytes().writeUnsignedByte(134);
            this.writeMarshallable(wire.bytes());
        } else {
            wire.write("sources").sequence(this, this.acceptSourcesConsumer);
            wire.write("timings").sequence(this, this.acceptTimingsConsumer);
        }
        this.dirty = false;
    }

    @Override
    public void readMarshallable(@NotNull BytesIn<?> bytes) throws IORuntimeException {
        if (bytes.canReadDirect(4098L)) {
            this.readMarshallableDirect(bytes);
        } else {
            this.readMarshallable0(bytes);
        }
        assert (!this.addSourceDetails) : "Bytes marshalling does not yet support addSourceDetails";
    }

    private void readMarshallableDirect(@NotNull BytesIn<?> bytes) {
        int i;
        long addr;
        long start = addr = bytes.addressForRead(bytes.readPosition());
        Memory memory = OS.memory();
        this.sources = memory.readByte(addr++);
        for (i = 0; i < this.sources; ++i) {
            this.sourceIdArray[i] = memory.readInt(addr);
            addr += 4L;
        }
        for (i = 0; i < this.sources; ++i) {
            this.sourceIndexArray[i] = memory.readLong(addr);
            addr += 8L;
        }
        this.timings = memory.readByte(addr++);
        for (i = 0; i < this.timings; ++i) {
            this.timingsArray[i] = memory.readLong(addr);
            addr += 8L;
        }
        bytes.readSkip(addr - start);
    }

    private void readMarshallable0(@NotNull BytesIn<?> bytes) {
        int i;
        this.sources = bytes.readUnsignedByte();
        for (i = 0; i < this.sources; ++i) {
            this.sourceIdArray[i] = bytes.readInt();
        }
        for (i = 0; i < this.sources; ++i) {
            this.sourceIndexArray[i] = bytes.readLong();
        }
        this.timings = bytes.readUnsignedByte();
        for (i = 0; i < this.timings; ++i) {
            this.timingsArray[i] = bytes.readLong();
        }
    }

    @Override
    public void writeMarshallable(@NotNull BytesOut<?> b) {
        if (b.canWriteDirect(4098L)) {
            this.writeMarshallableDirect(b);
        } else {
            this.writeMarshallable0(b);
        }
    }

    private void writeMarshallableDirect(BytesOut<?> b) {
        int i;
        long addr;
        long start = addr = b.addressForWritePosition();
        Memory memory = OS.memory();
        memory.writeByte(addr++, (byte)this.sources);
        for (i = 0; i < this.sources; ++i) {
            memory.writeInt(addr, this.sourceIdArray[i]);
            addr += 4L;
        }
        for (i = 0; i < this.sources; ++i) {
            memory.writeLong(addr, this.sourceIndexArray[i]);
            addr += 8L;
        }
        memory.writeByte(addr++, (byte)(this.timings + 1));
        for (i = 0; i < this.timings; ++i) {
            memory.writeLong(addr, this.timingsArray[i]);
            addr += 8L;
        }
        memory.writeLong(addr, this.nanoTime());
        b.writeSkip((addr += 8L) - start);
    }

    public void writeMarshallable0(@NotNull BytesOut<?> b) {
        int i;
        BytesOut<?> bytes = b;
        ((BytesOut)bytes.writeHexDumpDescription("sources")).writeUnsignedByte(this.sources);
        for (i = 0; i < this.sources; ++i) {
            bytes.writeInt(this.sourceIdArray[i]);
        }
        for (i = 0; i < this.sources; ++i) {
            bytes.writeLong(this.sourceIndexArray[i]);
        }
        ((BytesOut)bytes.writeHexDumpDescription("timings")).writeUnsignedByte(this.timings + 1);
        for (i = 0; i < this.timings; ++i) {
            bytes.writeLong(this.timingsArray[i]);
        }
        bytes.writeLong(this.nanoTime());
        this.dirty = false;
    }

    protected long nanoTime() {
        return this.historyWallClock ? SystemTimeProvider.CLOCK.currentTimeNanos() : System.nanoTime();
    }

    private void acceptSources(VanillaMessageHistory t, ValueOut out) {
        HexDumpBytesDescription<?> b = this.bytesComment(out);
        for (int i = 0; i < t.sources; ++i) {
            if (b != null) {
                b.writeHexDumpDescription("source id & index");
            }
            out.uint32(t.sourceIdArray[i]);
            out.int64_0x(t.sourceIndexArray[i]);
        }
    }

    private void acceptTimings(VanillaMessageHistory t, ValueOut out) {
        HexDumpBytesDescription<?> b = this.bytesComment(out);
        for (int i = 0; i < t.timings; ++i) {
            if (b != null) {
                b.writeHexDumpDescription("timing in nanos");
            }
            out.int64(t.timingsArray[i]);
        }
        if (!(out.wireOut() instanceof HashWire) && this.addSourceDetails) {
            out.int64(this.nanoTime());
        }
    }

    @Nullable
    private HexDumpBytesDescription<?> bytesComment(ValueOut out) {
        WireOut wireOut = out.wireOut();
        Bytes<?> b = null;
        if (!(wireOut instanceof HashWire) && !(b = wireOut.bytes()).retainedHexDumpDescription()) {
            b = null;
        }
        return b;
    }

    public void addSource(int id, long index) {
        this.sourceIdArray[this.sources] = id;
        this.sourceIndexArray[this.sources++] = index;
        this.dirty = true;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    public void addTiming(long l) {
        if (this.timings >= this.timingsArray.length) {
            throw new IllegalStateException("Have exceeded message history size: " + this);
        }
        this.timingsArray[this.timings++] = l;
    }

    @Override
    public String toString() {
        return "VanillaMessageHistory { sources: [" + this.toStringSources() + "], timings: [" + this.toStringTimings() + "], addSourceDetails=" + this.addSourceDetails + " }";
    }

    @NotNull
    public VanillaMessageHistory deepCopy() throws InvalidMarshallableException {
        @NotNull VanillaMessageHistory copy = (VanillaMessageHistory)super.deepCopy();
        copy.timingsArray[this.timings] = 0L;
        copy.timings = this.timings;
        return copy;
    }

    private CharSequence toStringSources() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.sources; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.sourceIdArray[i]).append("=0x").append(Long.toHexString(this.sourceIndexArray[i]));
        }
        return sb;
    }

    private CharSequence toStringTimings() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.timings; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            if (this.historyWallClock) {
                sb.append(' ').append(NanoTime.INSTANCE.asString(this.timingsArray[i]));
                continue;
            }
            sb.append(this.timingsArray[i]);
        }
        if (this.historyWallClock) {
            sb.append(' ');
        }
        return sb;
    }

    @Override
    public BinaryLengthLength binaryLengthLength() {
        return BinaryLengthLength.LENGTH_16BIT;
    }

    @Override
    public void doWriteHistory(DocumentContext dc) {
        Wire wire = dc.wire();
        ValueOut valueOut = this.useBytesMarshallable ? wire.writeEventId(-1) : wire.writeEventName("history");
        valueOut.marshallable(this);
    }

    public void useBytesMarshallable(boolean useBytesMarshallable) {
        this.useBytesMarshallable = useBytesMarshallable;
    }

    public void historyWallClock(boolean historyWallClock) {
        this.historyWallClock = historyWallClock;
    }
}

