/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads.internal;

import java.util.function.LongSupplier;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.threads.ThreadHolder;
import net.openhft.chronicle.threads.ThreadMonitor;

public class ThreadMonitorHarness
implements ThreadMonitor {
    private final ThreadHolder thread;
    private final LongSupplier timeSupplier;
    private long lastActionCall = Long.MAX_VALUE;
    private long lastStartedNS = Long.MAX_VALUE;

    public ThreadMonitorHarness(ThreadHolder thread, LongSupplier timeSupplier) {
        this.thread = thread;
        this.timeSupplier = timeSupplier;
    }

    public ThreadMonitorHarness(ThreadHolder thread) {
        this(thread, System::nanoTime);
    }

    @Override
    public boolean action() throws InvalidEventHandlerException {
        if (!this.thread.isAlive()) {
            this.thread.reportFinished();
            throw new InvalidEventHandlerException();
        }
        long startedNS = this.thread.startedNS();
        long nowNS = this.timeSupplier.getAsLong();
        long actionCallDelay = nowNS - this.lastActionCall;
        this.lastActionCall = nowNS;
        if (startedNS == 0L || startedNS == Long.MAX_VALUE) {
            return false;
        }
        if (startedNS != this.lastStartedNS) {
            this.thread.resetTimers();
            this.lastStartedNS = startedNS;
        }
        if (actionCallDelay > this.thread.timingToleranceNS()) {
            if (this.thread.isAlive()) {
                this.thread.monitorThreadDelayed(actionCallDelay);
            }
            return true;
        }
        if (!this.thread.shouldLog(nowNS)) {
            return false;
        }
        this.thread.dumpThread(startedNS, nowNS);
        return false;
    }

    public String toString() {
        return "ThreadMonitorHarness<" + this.thread.getName() + ">";
    }
}

