/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.impl.single.HelloWorld;
import net.openhft.chronicle.queue.impl.single.OnEvents;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.rollcycles.LegacyRollCycles;
import net.openhft.chronicle.queue.rollcycles.TestRollCycles;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.MessageHistory;
import net.openhft.chronicle.wire.VanillaMessageHistory;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class StoreTailerTest
extends QueueTestCommon {
    private final Path dataDirectory = this.getTmpDir().toPath();

    @Override
    @Before
    public void threadDump() {
        super.threadDump();
    }

    @Test
    public void testEntryCount() {
        try (SingleChronicleQueue queue = ChronicleQueue.singleBuilder((Path)this.dataDirectory).build();
             ExcerptAppender appender = queue.createAppender();){
            Assert.assertEquals((long)0L, (long)queue.entryCount());
            try (DocumentContext dc = appender.writingDocument();){
                dc.wire().write((CharSequence)"test").text("value");
            }
            appender.sync();
            Assert.assertEquals((long)1L, (long)queue.entryCount());
        }
    }

    @Test
    public void shouldHandleCycleRollWhenInReadOnlyMode() {
        Assume.assumeFalse((String)"Read-only mode is not supported on Windows", (boolean)OS.isWindows());
        MutableTimeProvider timeProvider = new MutableTimeProvider();
        try (ChronicleQueue queue = this.build(this.createQueue(this.dataDirectory, (RollCycle)LegacyRollCycles.MINUTELY, 0, "cycleRoll", false).timeProvider((TimeProvider)timeProvider));
             ExcerptAppender appender = queue.createAppender();){
            OnEvents events = (OnEvents)appender.methodWriterBuilder(OnEvents.class).build();
            timeProvider.setTime(System.currentTimeMillis());
            events.onEvent("firstEvent");
            timeProvider.addTime(2L, TimeUnit.MINUTES);
            events.onEvent("secondEvent");
            appender.sync();
            try (ChronicleQueue readerQueue = this.build(this.createQueue(this.dataDirectory, (RollCycle)LegacyRollCycles.MINUTELY, 0, "cycleRoll", true).timeProvider((TimeProvider)timeProvider));){
                ExcerptTailer tailer = readerQueue.createTailer();
                tailer.sync();
                tailer.toStart();
                tailer.sync();
                try (DocumentContext context = tailer.readingDocument();){
                    Assert.assertTrue((boolean)context.isPresent());
                }
                tailer.sync();
                tailer.toEnd();
                tailer.sync();
                context = tailer.readingDocument();
                var11_17 = null;
                try {
                    Assert.assertFalse((boolean)context.isPresent());
                }
                catch (Throwable throwable) {
                    var11_17 = throwable;
                    throw throwable;
                }
                finally {
                    if (context != null) {
                        if (var11_17 != null) {
                            try {
                                context.close();
                            }
                            catch (Throwable throwable) {
                                var11_17.addSuppressed(throwable);
                            }
                        } else {
                            context.close();
                        }
                    }
                }
                tailer.sync();
            }
        }
    }

    @Test
    public void shouldConsiderSourceIdWhenDeterminingLastWrittenIndex() {
        try (ChronicleQueue firstInputQueue = this.createQueue(this.dataDirectory, (RollCycle)TestRollCycles.TEST_DAILY, 1, "firstInputQueue");
             ChronicleQueue secondInputQueue = this.createQueue(this.dataDirectory, (RollCycle)TestRollCycles.TEST_SECONDLY, 2, "secondInputQueue");
             ChronicleQueue outputQueue = this.createQueue(this.dataDirectory, (RollCycle)TestRollCycles.TEST_DAILY, 0, "outputQueue");){
            OnEvents firstWriter = (OnEvents)firstInputQueue.methodWriterBuilder(OnEvents.class).get();
            HelloWorld secondWriter = (HelloWorld)secondInputQueue.methodWriterBuilder(HelloWorld.class).get();
            firstWriter.onEvent("one");
            firstWriter.onEvent("two");
            secondWriter.hello("thirteen");
            secondWriter.hello("thirtyOne");
            OnEvents eventSink = (OnEvents)outputQueue.methodWriterBuilder(OnEvents.class).get();
            CapturingStringEvents outputWriter = new CapturingStringEvents(eventSink);
            MethodReader firstMethodReader = firstInputQueue.createTailer().methodReader(new Object[]{outputWriter});
            MethodReader secondMethodReader = secondInputQueue.createTailer().methodReader(new Object[]{outputWriter});
            Assert.assertTrue((boolean)firstMethodReader.readOne());
            Assert.assertTrue((boolean)firstMethodReader.readOne());
            Assert.assertFalse((boolean)firstMethodReader.readOne());
            Assert.assertTrue((boolean)secondMethodReader.readOne());
            Assert.assertTrue((boolean)secondMethodReader.readOne());
            Assert.assertFalse((boolean)secondMethodReader.readOne());
            secondInputQueue.createTailer().afterLastWritten(outputQueue);
        }
    }

    @Test
    public void checkAfterWrittenMessageAtIndexMovesToTheCorrectIndex() {
        try (ChronicleQueue firstInputQueue = this.createQueue(this.dataDirectory, (RollCycle)TestRollCycles.TEST_DAILY, 1, "firstInputQueue");
             ChronicleQueue secondInputQueue = this.createQueue(this.dataDirectory, (RollCycle)TestRollCycles.TEST_DAILY, 2, "secondInputQueue");
             ChronicleQueue outputQueue = this.createQueue(this.dataDirectory, (RollCycle)TestRollCycles.TEST_DAILY, 3, "outputQueue");){
            OnEvents firstWriter = (OnEvents)firstInputQueue.methodWriterBuilder(OnEvents.class).get();
            HelloWorld secondWriter = (HelloWorld)secondInputQueue.methodWriterBuilder(HelloWorld.class).get();
            firstWriter.onEvent("one");
            firstWriter.onEvent("two");
            secondWriter.hello("thirteen");
            secondWriter.hello("thirtyOne");
            OnEvents eventSink = (OnEvents)outputQueue.methodWriterBuilder(OnEvents.class).get();
            MessageHistory.get().reset();
            CapturingStringEvents outputWriter = new CapturingStringEvents(eventSink);
            ExcerptTailer tailer1 = firstInputQueue.createTailer();
            long index1 = tailer1.index();
            MethodReader firstMethodReader = tailer1.methodReader(new Object[]{outputWriter});
            ExcerptTailer tailer2 = secondInputQueue.createTailer();
            long index2 = tailer2.index();
            MethodReader secondMethodReader = tailer2.methodReader(new Object[]{outputWriter});
            Assert.assertTrue((boolean)firstMethodReader.readOne());
            Assert.assertTrue((boolean)secondMethodReader.readOne());
            VanillaMessageHistory mh = (VanillaMessageHistory)MessageHistory.get();
            mh.addSource(1, index1);
            mh.addTiming(System.nanoTime());
            mh.addSource(2, index2);
            mh.addTiming(System.nanoTime());
            outputWriter.onEvent("out1");
            long index = outputQueue.acquireAppender().lastIndexAppended();
            index1 = tailer1.index();
            index2 = tailer2.index();
            Assert.assertTrue((boolean)firstMethodReader.readOne());
            Assert.assertTrue((boolean)secondMethodReader.readOne());
            mh.reset();
            mh.addSource(1, index1);
            mh.addTiming(System.nanoTime());
            mh.addSource(2, index2);
            mh.addTiming(System.nanoTime());
            outputWriter.onEvent("out2");
            mh.reset();
            tailer1.afterWrittenMessageAtIndex(outputQueue, index);
            Assert.assertEquals((long)index1, (long)tailer1.index());
            tailer2.afterWrittenMessageAtIndex(outputQueue, index);
            Assert.assertEquals((long)index2, (long)tailer2.index());
        }
    }

    @Test
    public void shouldHandleCycleRoll() {
        File dir = this.getTmpDir();
        MutableTimeProvider timeProvider = new MutableTimeProvider();
        timeProvider.setTime(System.currentTimeMillis());
        try (SingleChronicleQueue chronicle = this.minutely(dir, timeProvider).build();
             SingleChronicleQueue chronicle2 = this.minutely(dir, timeProvider).build();
             ExcerptAppender append = chronicle2.createAppender();){
            ExcerptTailer tailer = chronicle.createTailer();
            timeProvider.addTime(10L, TimeUnit.MINUTES);
            append.writeDocument(w -> w.write((CharSequence)"test").text("text"));
            if (!tailer.readDocument(w -> w.read("test").text((Object)"text", Assert::assertEquals))) {
                Assert.fail((String)"readDocument false");
            }
        }
    }

    private SingleChronicleQueueBuilder minutely(@NotNull File file, TimeProvider timeProvider) {
        return SingleChronicleQueueBuilder.builder((File)file, (WireType)WireType.BINARY).rollCycle((RollCycle)LegacyRollCycles.MINUTELY).testBlockSize().timeProvider(timeProvider);
    }

    @NotNull
    private ChronicleQueue createQueue(Path dataDirectory, RollCycle rollCycle, int sourceId, String subdirectory) {
        return this.build(this.createQueue(dataDirectory, rollCycle, sourceId, subdirectory, false));
    }

    @NotNull
    private SingleChronicleQueueBuilder createQueue(Path dataDirectory, RollCycle rollCycle, int sourceId, String subdirectory, boolean readOnly) {
        return SingleChronicleQueueBuilder.binary((Path)dataDirectory.resolve(Paths.get(subdirectory, new String[0]))).sourceId(sourceId).testBlockSize().rollCycle(rollCycle).readOnly(readOnly);
    }

    private ChronicleQueue build(SingleChronicleQueueBuilder builder) {
        return builder.build();
    }

    @Test
    public void disableThreadSafety() throws InterruptedException {
        new ThreadSafetyTestingTemplate(){

            @Override
            void doOnFirstThread(SingleChronicleQueue singleChronicleQueue, ExcerptTailer tailer) {
                tailer.readText();
            }

            @Override
            void doOnSecondThread(ExcerptTailer tailer) {
                try {
                    tailer.readText();
                    Assert.fail();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                tailer.singleThreadedCheckDisabled(true);
                tailer.readText();
            }
        }.run();
    }

    @Test
    public void disableThreadSafetyWithMethodReader() throws InterruptedException {
        new ThreadSafetyTestingTemplate(){

            @Override
            void doOnFirstThread(SingleChronicleQueue queue, ExcerptTailer tailer) {
                StoreTailerTest.this.writeMethodCall(queue, "Testing1");
                StoreTailerTest.this.writeMethodCall(queue, "Testing2");
                Assert.assertEquals((Object)"Testing1", (Object)StoreTailerTest.this.readMethodCall(tailer));
            }

            @Override
            void doOnSecondThread(ExcerptTailer tailer) {
                try {
                    StoreTailerTest.this.readMethodCall(tailer);
                    Assert.fail();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                tailer.singleThreadedCheckDisabled(true);
                Assert.assertEquals((Object)"Testing2", (Object)StoreTailerTest.this.readMethodCall(tailer));
            }
        }.run();
    }

    @Test
    public void clearUsedByThread() throws InterruptedException {
        new ThreadSafetyTestingTemplate(){

            @Override
            void doOnFirstThread(SingleChronicleQueue singleChronicleQueue, ExcerptTailer tailer) {
                tailer.readText();
            }

            @Override
            void doOnSecondThread(ExcerptTailer tailer) {
                try {
                    tailer.readText();
                    Assert.fail();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                ((AbstractCloseable)tailer).singleThreadedCheckReset();
                tailer.readText();
            }
        }.run();
    }

    @Test
    public void clearUsedByThreadWithMethodReader() throws InterruptedException {
        new ThreadSafetyTestingTemplate(){

            @Override
            void doOnFirstThread(SingleChronicleQueue queue, ExcerptTailer tailer) {
                StoreTailerTest.this.writeMethodCall(queue, "Testing1");
                StoreTailerTest.this.writeMethodCall(queue, "Testing2");
                StoreTailerTest.this.writeMethodCall(queue, "Testing3");
                Assert.assertEquals((Object)"Testing1", (Object)StoreTailerTest.this.readMethodCall(tailer));
            }

            @Override
            void doOnSecondThread(ExcerptTailer tailer) {
                try {
                    StoreTailerTest.this.readMethodCall(tailer);
                    Assert.fail();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                ((AbstractCloseable)tailer).singleThreadedCheckReset();
                Assert.assertEquals((Object)"Testing2", (Object)StoreTailerTest.this.readMethodCall(tailer));
            }
        }.run();
    }

    private void writeMethodCall(SingleChronicleQueue queue, String message) {
        Foobar foobar = (Foobar)queue.methodWriter(Foobar.class, new Class[0]);
        foobar.say(message);
    }

    private String readMethodCall(ExcerptTailer tailer) {
        AtomicReference messageHolder = new AtomicReference();
        Object[] objectArray = new Object[1];
        objectArray[0] = messageHolder::set;
        MethodReader methodReader = tailer.methodReader(objectArray);
        methodReader.readOne();
        return (String)messageHolder.get();
    }

    @Test
    public void readMetaData() {
        File dir = this.getTmpDir();
        try (SingleChronicleQueue queue = ChronicleQueue.singleBuilder((File)dir).build();
             ExcerptTailer tailer = queue.createTailer();
             ExcerptAppender appender = queue.createAppender();){
            appender.writeText((CharSequence)"Hello World");
            try (DocumentContext dc = tailer.readingDocument(true);){
                Assert.assertTrue((boolean)dc.isPresent());
                Assert.assertTrue((boolean)dc.isMetaData());
                Assert.assertEquals((Object)"header", (Object)dc.wire().readEvent(String.class));
            }
        }
    }

    abstract class ThreadSafetyTestingTemplate {
        ThreadSafetyTestingTemplate() {
        }

        abstract void doOnFirstThread(SingleChronicleQueue var1, ExcerptTailer var2);

        abstract void doOnSecondThread(ExcerptTailer var1);

        public void run() throws InterruptedException {
            try (SingleChronicleQueue queue = ChronicleQueue.singleBuilder((Path)StoreTailerTest.this.dataDirectory).build();){
                LinkedBlockingQueue tq = new LinkedBlockingQueue();
                Thread t = new Thread(() -> {
                    ExcerptTailer tailer = queue.createTailer();
                    this.doOnFirstThread(queue, tailer);
                    tq.offer(tailer);
                    Jvm.pause((long)1000L);
                });
                t.start();
                this.doOnSecondThread((ExcerptTailer)tq.take());
                t.interrupt();
                t.join(1000L);
            }
        }
    }

    private static final class MutableTimeProvider
    implements TimeProvider {
        private long currentTimeMillis;

        private MutableTimeProvider() {
        }

        public long currentTimeMillis() {
            return this.currentTimeMillis;
        }

        void setTime(long millis) {
            this.currentTimeMillis = millis;
        }

        void addTime(long duration, TimeUnit unit) {
            this.currentTimeMillis += unit.toMillis(duration);
        }
    }

    private static final class CapturingStringEvents
    implements OnEvents,
    HelloWorld {
        private final OnEvents delegate;

        CapturingStringEvents(OnEvents delegate) {
            this.delegate = delegate;
        }

        @Override
        public void onEvent(String event) {
            this.delegate.onEvent(event);
        }

        @Override
        public void hello(String s) {
            this.delegate.onEvent(s);
        }
    }

    static interface Foobar {
        public void say(String var1);
    }
}

