/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.nio.file.Path;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.bytes.PageUtil;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.impl.StoreFileListener;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.rollcycles.TestRollCycles;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class RollCycleTest
extends QueueTestCommon {
    @Override
    @Before
    public void threadDump() {
        super.threadDump();
    }

    @Test
    public void newRollCycleIgnored() throws InterruptedException {
        File path = this.getTmpDir();
        SetTimeProvider timeProvider = new SetTimeProvider();
        ParallelQueueObserver observer = new ParallelQueueObserver((TimeProvider)timeProvider, path.toPath());
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)path).testBlockSize().rollCycle((RollCycle)TestRollCycles.TEST_DAILY).timeProvider((TimeProvider)timeProvider).build();
             ExcerptAppender appender = queue.createAppender();){
            Thread thread = new Thread(observer);
            thread.start();
            observer.await();
            timeProvider.advanceMillis(TimeUnit.DAYS.toMillis(2L));
            appender.writeText((CharSequence)"0");
            for (int i = 0; i < 5000 && observer.documentsRead != 1; ++i) {
                timeProvider.advanceMicros(100L);
                Thread.sleep(1L);
            }
            thread.interrupt();
        }
        Assert.assertEquals((long)1L, (long)observer.documentsRead);
        observer.queue.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void newRollCycleIgnored2() throws InterruptedException {
        this.finishedNormally = false;
        File path = this.getTmpDir();
        Assume.assumeFalse((String)"Ignored on hugetlbfs as byte offsets will be different due to page size", (boolean)PageUtil.isHugePage((String)path.getAbsolutePath()));
        SetTimeProvider timeProvider = new SetTimeProvider();
        ParallelQueueObserver observer = new ParallelQueueObserver((TimeProvider)timeProvider, path.toPath());
        try (ChronicleQueue queue0 = observer.queue;){
            int cyclesToWrite = 3;
            Thread thread = new Thread(observer);
            try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)path).blockSize(65536).rollCycle((RollCycle)TestRollCycles.TEST_DAILY).timeProvider((TimeProvider)timeProvider).build();
                 ExcerptAppender appender = queue.createAppender();){
                int i;
                appender.writeText((CharSequence)"0");
                thread.start();
                observer.await();
                for (i = 1; i <= cyclesToWrite; ++i) {
                    timeProvider.advanceMillis(TimeUnit.DAYS.toMillis(2L));
                    appender.writeText((CharSequence)Integer.toString(i));
                }
                Assert.assertEquals((Object)"--- !!meta-data #binary\nheader: !STStore {\n  wireType: !WireType BINARY_LIGHT,\n  metadata: !SCQMeta {\n    roll: !SCQSRoll { length: 86400000, format: yyyyMMdd'T1', epoch: 0 },\n    deltaCheckpointInterval: 64,\n    sourceId: 0\n  }\n}\n# position: 180, header: 0\n--- !!data #binary\nlisting.highestCycle: 6\n# position: 216, header: 1\n--- !!data #binary\nlisting.lowestCycle: 0\n# position: 256, header: 2\n--- !!data #binary\nlisting.modCount: 9\n# position: 288, header: 3\n--- !!data #binary\nchronicle.write.lock: -9223372036854775808\n# position: 328, header: 4\n--- !!data #binary\nchronicle.append.lock: -9223372036854775808\n# position: 368, header: 5\n--- !!data #binary\nchronicle.lastIndexReplicated: -1\n# position: 416, header: 6\n--- !!data #binary\nchronicle.lastAcknowledgedIndexReplicated: -1\n# position: 472, header: 7\n--- !!data #binary\nchronicle.lastIndexMSynced: -1\n...\n# 130548 bytes remaining\n--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    400,\n    1717986918400\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 200,\n    lastIndex: 1\n  },\n  dataFormat: 1\n}\n# position: 200, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  304,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 304, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 1\n  400,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 400, header: 0\n--- !!data #binary\n\"0\"\n# position: 408, header: 0 EOF\n--- !!not-ready-meta-data #binary\n...\n# 130660 bytes remaining\n--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    400,\n    1717986918400\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 200,\n    lastIndex: 1\n  },\n  dataFormat: 1\n}\n# position: 200, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  304,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 304, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 1\n  400,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 400, header: 0\n--- !!data #binary\n\"1\"\n# position: 408, header: 0 EOF\n--- !!not-ready-meta-data #binary\n...\n# 130660 bytes remaining\n--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    400,\n    1717986918400\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 200,\n    lastIndex: 1\n  },\n  dataFormat: 1\n}\n# position: 200, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  304,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 304, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 1\n  400,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 400, header: 0\n--- !!data #binary\n\"2\"\n# position: 408, header: 0 EOF\n--- !!not-ready-meta-data #binary\n...\n# 130660 bytes remaining\n--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    400,\n    1717986918400\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 200,\n    lastIndex: 1\n  },\n  dataFormat: 1\n}\n# position: 200, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  304,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 304, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 1\n  400,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 400, header: 0\n--- !!data #binary\n\"3\"\n...\n# 130660 bytes remaining\n", (Object)queue.dump());
                for (i = 0; i < 5000 && observer.documentsRead != 1 + cyclesToWrite; ++i) {
                    Thread.sleep(1L);
                }
            }
            finally {
                thread.interrupt();
            }
            Assert.assertEquals((long)(1 + cyclesToWrite), (long)observer.documentsRead);
        }
        this.finishedNormally = true;
    }

    @After
    public void clearInterrupt() {
        Thread.interrupted();
    }

    class ParallelQueueObserver
    implements Runnable,
    StoreFileListener {
        ChronicleQueue queue;
        CountDownLatch progressLatch;
        volatile int documentsRead;

        public ParallelQueueObserver(@NotNull TimeProvider timeProvider, Path path) {
            this.queue = SingleChronicleQueueBuilder.binary((File)path.toFile()).testBlockSize().rollCycle((RollCycle)TestRollCycles.TEST_DAILY).timeProvider(timeProvider).storeFileListener((StoreFileListener)this).build();
            this.documentsRead = 0;
            this.progressLatch = new CountDownLatch(1);
        }

        @Override
        public void run() {
            ExcerptTailer tailer = this.queue.createTailer();
            this.progressLatch.countDown();
            int lastDocId = -1;
            while (!Thread.currentThread().isInterrupted()) {
                String readText = tailer.readText();
                if (readText == null) continue;
                ++this.documentsRead;
                int docId = Integer.parseInt(readText);
                Assert.assertEquals((long)docId, (long)(lastDocId + 1));
                lastDocId = docId;
            }
        }

        public void await() throws InterruptedException {
            this.progressLatch.await();
        }

        public int documentsRead() {
            return this.documentsRead;
        }

        public void onAcquired(int cycle, File file) {
        }

        public void onReleased(int cycle, File file) {
        }
    }
}

