/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.TestKey;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.StoreTailer;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IndexTest
extends QueueTestCommon {
    @NotNull
    private final WireType wireType;

    public IndexTest(@NotNull WireType wireType) {
        this.wireType = wireType;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{{WireType.BINARY}});
    }

    @Test
    public void test() throws IOException {
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)this.getTmpDir()).testBlockSize().wireType(this.wireType).build();
             ExcerptAppender appender = queue.createAppender();){
            int i = 0;
            while (i < 5) {
                int n = i++;
                appender.writeDocument(w -> w.write((WireKey)TestKey.test).int32(n));
                int cycle = queue.lastCycle();
                long index0 = queue.rollCycle().toIndex(cycle, (long)n);
                long indexA = appender.lastIndexAppended();
                this.accessHexEquals(index0, indexA);
            }
        }
    }

    @Test
    public void shouldShortCircuitIndexLookupWhenNewIndexIsCloseToPreviousIndex() {
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)this.getTmpDir()).testBlockSize().wireType(this.wireType).build();
             ExcerptAppender appender = queue.createAppender();){
            int messageCount = 75;
            long[] indices = new long[75];
            for (int i = 0; i < 75; ++i) {
                try (DocumentContext ctx = appender.writingDocument();){
                    ctx.wire().write((CharSequence)"event").int32(i);
                    indices[i] = ctx.index();
                    continue;
                }
            }
            StoreTailer tailer = (StoreTailer)queue.createTailer();
            tailer.moveToIndex(indices[0]);
            Assert.assertEquals((long)indices[0], (long)tailer.index());
            Assert.assertEquals((long)1L, (long)tailer.getIndexMoveCount());
            tailer.moveToIndex(indices[0]);
            Assert.assertEquals((long)indices[0], (long)tailer.index());
            Assert.assertEquals((long)1L, (long)tailer.getIndexMoveCount());
            tailer.moveToIndex(indices[2]);
            Assert.assertEquals((long)indices[2], (long)tailer.index());
            Assert.assertEquals((long)1L, (long)tailer.getIndexMoveCount());
            tailer.moveToIndex(indices[72]);
            Assert.assertEquals((long)indices[72], (long)tailer.index());
            Assert.assertEquals((long)2L, (long)tailer.getIndexMoveCount());
            tailer.moveToIndex(indices[69]);
            Assert.assertEquals((long)indices[69], (long)tailer.index());
            Assert.assertEquals((long)3L, (long)tailer.getIndexMoveCount());
        }
    }

    public void accessHexEquals(long index0, long indexA) {
        Assert.assertEquals((String)(Long.toHexString(index0) + " != " + Long.toHexString(indexA)), (long)index0, (long)indexA);
    }
}

