/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.testframework.process.JavaProcessBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EmptyRollCycleTest
extends QueueTestCommon {
    public static final String EMPTY_ROLL_CYCLE_NAME = "19700101-0020X.cq4";
    private Path dataDirectory;

    @Before
    public void setUp() {
        this.dataDirectory = IOTools.createTempDirectory((String)"EmptyRollCycleTest");
    }

    @Override
    @After
    public void tearDown() {
        IOTools.deleteDirWithFiles((File)this.dataDirectory.toFile());
    }

    @Test
    public void tailerShouldTolerateEmptyRollCycleAtEnd() throws IOException {
        this.ignoreException("Channel closed while unlocking");
        this.createQueueWithEmptyRollCycleAtEnd();
        try (SingleChronicleQueue queue = ChronicleQueue.singleBuilder((Path)this.dataDirectory).rollCycle((RollCycle)RollCycles.TEN_MINUTELY).timeoutMS(100L).build();
             ExcerptTailer tailer = queue.createTailer();){
            int expectedValue = 0;
            while (true) {
                DocumentContext readingDocument = tailer.readingDocument();
                Throwable throwable = null;
                try {
                    if (!readingDocument.isPresent()) break;
                    Assert.assertEquals((long)expectedValue++, (long)readingDocument.wire().read("test").int32());
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (readingDocument == null) continue;
                    if (throwable != null) {
                        try {
                            readingDocument.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    readingDocument.close();
                    continue;
                }
                break;
            }
            Assert.assertEquals((long)2L, (long)expectedValue);
        }
    }

    @Test
    public void appenderShouldTolerateEmptyRollCycleAtEnd() throws IOException {
        Throwable throwable;
        Throwable throwable2;
        this.ignoreException("Channel closed while unlocking");
        this.ignoreException("Renamed un-acquirable segment file");
        this.createQueueWithEmptyRollCycleAtEnd();
        long indexWritten = -1L;
        try (SingleChronicleQueue queue = ChronicleQueue.singleBuilder((Path)this.dataDirectory).rollCycle((RollCycle)RollCycles.TEN_MINUTELY).timeoutMS(100L).build();){
            throwable2 = null;
            try (ExcerptAppender appender = queue.createAppender();){
                throwable = null;
                try (DocumentContext dc = appender.writingDocument();){
                    dc.wire().write((CharSequence)"test").text("appending");
                    indexWritten = dc.index();
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable dc) {
                throwable2 = dc;
                throw dc;
            }
        }
        queue = ChronicleQueue.singleBuilder((Path)this.dataDirectory).rollCycle((RollCycle)RollCycles.TEN_MINUTELY).build();
        var4_3 = null;
        try {
            throwable2 = null;
            try (ExcerptTailer tailer = queue.createTailer();){
                tailer.moveToIndex(indexWritten);
                throwable = null;
                try (DocumentContext readingDocument = tailer.readingDocument();){
                    Assert.assertTrue((boolean)readingDocument.isPresent());
                    Assert.assertEquals((Object)"appending", (Object)readingDocument.wire().read("test").text());
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
        }
        catch (Throwable throwable6) {
            var4_3 = throwable6;
            throw throwable6;
        }
        finally {
            if (queue != null) {
                if (var4_3 != null) {
                    try {
                        queue.close();
                    }
                    catch (Throwable throwable7) {
                        var4_3.addSuppressed(throwable7);
                    }
                } else {
                    queue.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void appropriateExceptionIsThrownWhenLockCannotBeAcquiredForRecovery() throws IOException, InterruptedException {
        this.createQueueWithEmptyRollCycleAtEnd();
        Path emptyRollCycle = this.dataDirectory.resolve(EMPTY_ROLL_CYCLE_NAME);
        Process start = JavaProcessBuilder.create(LockingProcess.class).withProgramArguments(new String[]{emptyRollCycle.toString()}).start();
        try {
            this.waitForFileToBeLocked(emptyRollCycle);
            try (SingleChronicleQueue queue = ChronicleQueue.singleBuilder((Path)this.dataDirectory).rollCycle((RollCycle)RollCycles.TEN_MINUTELY).timeoutMS(100L).build();
                 ExcerptTailer tailer = queue.createTailer();){
                for (int i = 0; i < 2; ++i) {
                    try (DocumentContext readingDocument = tailer.readingDocument();){
                        Assert.assertTrue((boolean)readingDocument.isPresent());
                        continue;
                    }
                }
                Assert.assertEquals((Object)false, (Object)tailer.readingDocument().isPresent());
            }
        }
        finally {
            start.destroy();
            Assert.assertTrue((boolean)start.waitFor(5L, TimeUnit.SECONDS));
        }
    }

    private void createQueueWithEmptyRollCycleAtEnd() throws IOException {
        SetTimeProvider timeProvider = new SetTimeProvider();
        try (SingleChronicleQueue queue = ChronicleQueue.singleBuilder((Path)this.dataDirectory).timeProvider((TimeProvider)timeProvider).rollCycle((RollCycle)RollCycles.TEN_MINUTELY).build();
             ExcerptAppender appender = queue.createAppender();){
            for (int i = 0; i < 3; ++i) {
                try (DocumentContext documentContext = appender.writingDocument();){
                    documentContext.wire().write((CharSequence)"test").int32(i);
                }
                timeProvider.advanceMillis(TimeUnit.MINUTES.toMillis(10L));
            }
        }
        Path lastRollCycle = this.dataDirectory.resolve(EMPTY_ROLL_CYCLE_NAME);
        Files.delete(lastRollCycle);
        Files.createFile(lastRollCycle, new FileAttribute[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitForFileToBeLocked(Path path) throws IOException {
        try (FileChannel open = FileChannel.open(path, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);){
            while (true) {
                Throwable throwable;
                FileLock fileLock;
                block25: {
                    block26: {
                        fileLock = open.tryLock();
                        throwable = null;
                        try {
                            if (fileLock != null) break block25;
                            if (fileLock == null) return;
                            if (throwable == null) break block26;
                        }
                        catch (Throwable throwable2) {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (fileLock == null) throw throwable3;
                                if (throwable != null) {
                                    try {
                                        fileLock.close();
                                        throw throwable3;
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                        throw throwable3;
                                    }
                                }
                                fileLock.close();
                                throw throwable3;
                            }
                        }
                        try {
                            fileLock.close();
                            return;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                            return;
                        }
                    }
                    fileLock.close();
                    return;
                }
                if (fileLock == null) continue;
                if (throwable != null) {
                    try {
                        fileLock.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                fileLock.close();
            }
        }
    }

    private static class LockingProcess {
        private LockingProcess() {
        }

        public static void main(String[] args) throws IOException {
            String fileName = args[0];
            try (FileChannel open = FileChannel.open(Paths.get(fileName, new String[0]), StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);){
                open.lock();
                while (!Thread.currentThread().isInterrupted()) {
                    Jvm.pause((long)1L);
                }
            }
        }
    }
}

