/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.OptionalLong;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.BackgroundResourceReleaser;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.TailerDirection;
import net.openhft.chronicle.queue.impl.StoreFileListener;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Ignore;
import org.junit.Test;

public class TestDeleteQueueFile
extends QueueTestCommon {
    private static final int NUM_REPEATS = 10;
    private static final int CYCLES_TO_DELETE_PER_ITERATION = 20;
    private final Path tempQueueDir = this.getTmpDir().toPath();

    @Test
    public void testRefreshDirectoryListingWillUpdateFirstAndLastIndicesCorrectly() throws IOException {
        Assume.assumeFalse((boolean)OS.isWindows());
        try (QueueWithCycleDetails queueWithCycleDetails = this.createQueueWithNRollCycles(3, null);){
            Files.delete(Paths.get(queueWithCycleDetails.rollCycles.get((int)0).filename, new String[0]));
            Files.delete(Paths.get(queueWithCycleDetails.rollCycles.get((int)2).filename, new String[0]));
            SingleChronicleQueue queue = queueWithCycleDetails.queue;
            queue.refreshDirectoryListing();
            RollCycleDetails secondCycle = queueWithCycleDetails.rollCycles.get(1);
            Assert.assertEquals((Object)Long.toHexString(secondCycle.firstIndex), (Object)Long.toHexString(queue.firstIndex()));
            Assert.assertEquals((Object)Long.toHexString(secondCycle.lastIndex), (Object)Long.toHexString(queue.lastIndex()));
            ExcerptTailer excerptTailer2 = queue.createTailer();
            Assert.assertEquals((Object)Long.toHexString(secondCycle.firstIndex), (Object)Long.toHexString(excerptTailer2.index()));
            this.readText(excerptTailer2, "test2");
        }
    }

    @Test
    public void tailerToStartWorksInFaceOfDeletedStoreFile() throws IOException {
        Assume.assumeFalse((boolean)OS.isWindows());
        try (QueueWithCycleDetails queueWithCycleDetails = this.createQueueWithNRollCycles(3, null);){
            SingleChronicleQueue queue = queueWithCycleDetails.queue;
            RollCycleDetails firstCycle = queueWithCycleDetails.rollCycles.get(0);
            RollCycleDetails secondCycle = queueWithCycleDetails.rollCycles.get(1);
            RollCycleDetails thirdCycle = queueWithCycleDetails.rollCycles.get(2);
            ExcerptTailer tailer = queue.createTailer();
            Assert.assertEquals((Object)Long.toHexString(firstCycle.firstIndex), (Object)Long.toHexString(tailer.toStart().index()));
            Assert.assertEquals((Object)Long.toHexString(thirdCycle.lastIndex + 1L), (Object)Long.toHexString(tailer.toEnd().index()));
            Files.delete(Paths.get(firstCycle.filename, new String[0]));
            Assert.assertEquals((Object)Long.toHexString(secondCycle.firstIndex), (Object)Long.toHexString(tailer.toStart().index()));
        }
    }

    @Ignore(value="https://github.com/OpenHFT/Chronicle-Queue/issues/1151")
    @Test
    public void tailerToStartFromStartWorksInFaceOfDeletedStoreFile() throws IOException {
        Assume.assumeFalse((boolean)OS.isWindows());
        try (QueueWithCycleDetails queueWithCycleDetails = this.createQueueWithNRollCycles(3, null);){
            SingleChronicleQueue queue = queueWithCycleDetails.queue;
            RollCycleDetails firstCycle = queueWithCycleDetails.rollCycles.get(0);
            RollCycleDetails secondCycle = queueWithCycleDetails.rollCycles.get(1);
            RollCycleDetails thirdCycle = queueWithCycleDetails.rollCycles.get(2);
            ExcerptTailer tailer = queue.createTailer();
            Assert.assertEquals((Object)Long.toHexString(thirdCycle.lastIndex + 1L), (Object)Long.toHexString(tailer.toEnd().index()));
            Assert.assertEquals((Object)Long.toHexString(firstCycle.firstIndex), (Object)Long.toHexString(tailer.toStart().index()));
            Files.delete(Paths.get(firstCycle.filename, new String[0]));
            Assert.assertEquals((Object)Long.toHexString(secondCycle.firstIndex), (Object)Long.toHexString(tailer.toStart().index()));
        }
    }

    @Test
    public void tailerToEndWorksInFaceOfDeletedStoreFile() throws IOException {
        Assume.assumeFalse((boolean)OS.isWindows());
        try (QueueWithCycleDetails queueWithCycleDetails = this.createQueueWithNRollCycles(3, null);){
            SingleChronicleQueue queue = queueWithCycleDetails.queue;
            RollCycleDetails firstCycle = queueWithCycleDetails.rollCycles.get(0);
            RollCycleDetails secondCycle = queueWithCycleDetails.rollCycles.get(1);
            RollCycleDetails thirdCycle = queueWithCycleDetails.rollCycles.get(2);
            ExcerptTailer tailer = queue.createTailer();
            Assert.assertEquals((Object)Long.toHexString(thirdCycle.lastIndex + 1L), (Object)Long.toHexString(tailer.toEnd().index()));
            Assert.assertEquals((Object)Long.toHexString(firstCycle.firstIndex), (Object)Long.toHexString(tailer.toStart().index()));
            Files.delete(Paths.get(thirdCycle.filename, new String[0]));
            Assert.assertEquals((Object)Long.toHexString(secondCycle.lastIndex + 1L), (Object)Long.toHexString(tailer.toEnd().index()));
        }
    }

    @Ignore(value="https://github.com/OpenHFT/Chronicle-Queue/issues/1151")
    @Test
    public void tailerToEndFromEndWorksInFaceOfDeletedStoreFile() throws IOException {
        Assume.assumeFalse((boolean)OS.isWindows());
        try (QueueWithCycleDetails queueWithCycleDetails = this.createQueueWithNRollCycles(3, null);){
            SingleChronicleQueue queue = queueWithCycleDetails.queue;
            RollCycleDetails firstCycle = queueWithCycleDetails.rollCycles.get(0);
            RollCycleDetails secondCycle = queueWithCycleDetails.rollCycles.get(1);
            RollCycleDetails thirdCycle = queueWithCycleDetails.rollCycles.get(2);
            ExcerptTailer tailer = queue.createTailer();
            Assert.assertEquals((Object)Long.toHexString(firstCycle.firstIndex), (Object)Long.toHexString(tailer.toStart().index()));
            Assert.assertEquals((Object)Long.toHexString(thirdCycle.lastIndex + 1L), (Object)Long.toHexString(tailer.toEnd().index()));
            Files.delete(Paths.get(thirdCycle.filename, new String[0]));
            Assert.assertEquals((Object)Long.toHexString(secondCycle.lastIndex + 1L), (Object)Long.toHexString(tailer.toEnd().index()));
        }
    }

    @Test
    public void firstAndLastIndexAreRefreshedAfterForceRefreshInterval() throws IOException {
        Assume.assumeFalse((boolean)OS.isWindows());
        try (QueueWithCycleDetails queueWithCycleDetails = this.createQueueWithNRollCycles(3, builder -> builder.forceDirectoryListingRefreshIntervalMs(250L));){
            SingleChronicleQueue queue = queueWithCycleDetails.queue;
            RollCycleDetails firstCycle = queueWithCycleDetails.rollCycles.get(0);
            RollCycleDetails secondCycle = queueWithCycleDetails.rollCycles.get(1);
            RollCycleDetails thirdCycle = queueWithCycleDetails.rollCycles.get(2);
            ExcerptTailer tailer = queue.createTailer();
            Assert.assertEquals((Object)Long.toHexString(firstCycle.firstIndex), (Object)Long.toHexString(tailer.toStart().index()));
            Assert.assertEquals((Object)Long.toHexString(thirdCycle.lastIndex + 1L), (Object)Long.toHexString(tailer.toEnd().index()));
            Files.delete(Paths.get(firstCycle.filename, new String[0]));
            Assert.assertEquals((Object)Long.toHexString(firstCycle.firstIndex), (Object)Long.toHexString(queue.firstIndex()));
            Assert.assertEquals((Object)Long.toHexString(firstCycle.firstIndex), (Object)Long.toHexString(queue.firstIndex()));
            Jvm.pause((long)260L);
            Assert.assertEquals((Object)Long.toHexString(secondCycle.firstIndex), (Object)Long.toHexString(queue.firstIndex()));
        }
    }

    @Test
    public void tailingThroughDeletedCyclesWillRefreshThenRetry_Writable() throws IOException {
        this.tailingThroughDeletedCyclesWillRefreshThenRetry(qwcd -> qwcd.queue);
    }

    @Test
    public void tailingThroughDeletedCyclesWillRefreshThenRetry_ReadOnly() throws IOException {
        this.tailingThroughDeletedCyclesWillRefreshThenRetry(qwcd -> SingleChronicleQueueBuilder.binary((String)qwcd.queue.fileAbsolutePath()).rollCycle((RollCycle)RollCycles.FAST_DAILY).readOnly(true).build());
    }

    @Test
    public void deletingOldFilesChaosTest() throws InterruptedException {
        this.ignoreException("The current cycle seems to have been deleted from under the queue, scanning to find the next remaining cycle");
        int numberOfCycles = 300;
        AtomicBoolean running = new AtomicBoolean(true);
        try (QueueWithCycleDetails queueWithCycleDetails = this.createQueueWithNRollCycles(300, null);){
            Thread backwardTailerThread = new Thread(() -> new QueueTailer(running, queueWithCycleDetails, TailerDirection.BACKWARD));
            Thread forwardTailerThread = new Thread(() -> new QueueTailer(running, queueWithCycleDetails, TailerDirection.FORWARD));
            Thread deleterThread = new Thread(() -> this.progressivelyTruncateOldRollCycles(queueWithCycleDetails));
            backwardTailerThread.start();
            forwardTailerThread.start();
            deleterThread.start();
            deleterThread.join();
            running.set(false);
            forwardTailerThread.join();
            backwardTailerThread.join();
        }
    }

    @Test
    public void deleteFileFromUnderTailerTest_StartOfRange() throws IOException {
        this.deleteFileFromUnderTailerTest(10, 0);
    }

    @Test
    public void deleteFileFromUnderTailerTest_MiddleOfRange() throws IOException {
        this.deleteFileFromUnderTailerTest(10, 5);
    }

    @Test
    public void deleteFileFromUnderTailerTest_EndOfRange() throws IOException {
        this.deleteFileFromUnderTailerTest(10, 8);
    }

    public void deleteFileFromUnderTailerTest(int numberOfCycles, int currentCycleIndex) throws IOException {
        Assume.assumeFalse((boolean)OS.isWindows());
        this.ignoreException("The current cycle seems to have been deleted from under the queue, scanning to find the next remaining cycle");
        try (QueueWithCycleDetails queueWithCycleDetails = this.createQueueWithNRollCycles(numberOfCycles, null);
             ExcerptTailer tailer = queueWithCycleDetails.queue.createTailer();){
            long lastIndexRead;
            RollCycleDetails rollCycleBeingRead = queueWithCycleDetails.rollCycles.get(currentCycleIndex);
            RollCycleDetails nextRollCycleToBeRead = queueWithCycleDetails.rollCycles.get(currentCycleIndex + 1);
            long expectedLastIndexRead = queueWithCycleDetails.rollCycles.stream().filter(rc -> rc != nextRollCycleToBeRead).mapToLong(rc -> rc.lastIndex).reduce(-1L, Long::max);
            tailer.moveToIndex(rollCycleBeingRead.firstIndex);
            try (DocumentContext documentContext = tailer.readingDocument();){
                lastIndexRead = documentContext.index();
            }
            Jvm.startup().on(TestDeleteQueueFile.class, "First index read was " + Long.toHexString(lastIndexRead));
            Files.delete(Paths.get(rollCycleBeingRead.filename, new String[0]));
            Files.delete(Paths.get(nextRollCycleToBeRead.filename, new String[0]));
            queueWithCycleDetails.queue.refreshDirectoryListing();
            while (true) {
                documentContext = tailer.readingDocument();
                var14_15 = null;
                try {
                    if (!documentContext.isPresent()) break;
                    lastIndexRead = documentContext.index();
                    continue;
                }
                catch (Throwable throwable) {
                    var14_15 = throwable;
                    throw throwable;
                }
                finally {
                    if (documentContext == null) continue;
                    if (var14_15 != null) {
                        try {
                            documentContext.close();
                        }
                        catch (Throwable throwable) {
                            var14_15.addSuppressed(throwable);
                        }
                        continue;
                    }
                    documentContext.close();
                    continue;
                }
                break;
            }
            Jvm.startup().on(TestDeleteQueueFile.class, "Last index read was " + Long.toHexString(lastIndexRead));
            Assert.assertEquals((Object)Long.toHexString(expectedLastIndexRead), (Object)Long.toHexString(lastIndexRead));
        }
    }

    private void progressivelyTruncateOldRollCycles(QueueWithCycleDetails queueWithCycleDetails) {
        try {
            int deletedUpTo = 0;
            int numberOfCycles = queueWithCycleDetails.rollCycles.size();
            while (!queueWithCycleDetails.rollCycles.isEmpty()) {
                Jvm.startup().on(TestDeleteQueueFile.class, "Deleting from " + deletedUpTo + " to " + (deletedUpTo + 20));
                for (int i = 0; i < 20; ++i) {
                    RollCycleDetails rollCycleDetails = queueWithCycleDetails.rollCycles.remove(0);
                    Jvm.startup().on(TestDeleteQueueFile.class, "Deleting " + rollCycleDetails.filename + " (" + deletedUpTo + "/" + numberOfCycles + "), firstIndex=" + Long.toHexString(rollCycleDetails.firstIndex) + ", lastIndex=" + Long.toHexString(rollCycleDetails.lastIndex));
                    Files.delete(Paths.get(rollCycleDetails.filename, new String[0]));
                    ++deletedUpTo;
                }
                queueWithCycleDetails.queue.refreshDirectoryListing();
                Jvm.pause((long)1000L);
            }
        }
        catch (IOException e) {
            Jvm.error().on(TestDeleteQueueFile.class, "Error occurred", (Throwable)e);
        }
    }

    private void deleteAllRollCyclesInRandomOrder(QueueWithCycleDetails queueWithCycleDetails) {
        try {
            int numberOfCycles = queueWithCycleDetails.rollCycles.size();
            int deleted = 0;
            while (queueWithCycleDetails.rollCycles.size() > 1) {
                int index = ThreadLocalRandom.current().nextInt(1, queueWithCycleDetails.rollCycles.size());
                RollCycleDetails rollCycleDetails = queueWithCycleDetails.rollCycles.remove(index);
                Jvm.startup().on(TestDeleteQueueFile.class, "Deleting " + rollCycleDetails.rollCycle + ": " + rollCycleDetails.filename + " (" + ++deleted + "/" + numberOfCycles + "), firstIndex=" + Long.toHexString(rollCycleDetails.firstIndex) + ", lastIndex=" + Long.toHexString(rollCycleDetails.lastIndex));
                Files.delete(Paths.get(rollCycleDetails.filename, new String[0]));
                queueWithCycleDetails.queue.refreshDirectoryListing();
                Jvm.pause((long)20L);
            }
        }
        catch (IOException e) {
            Jvm.error().on(TestDeleteQueueFile.class, "Error occurred", (Throwable)e);
        }
    }

    @Test
    public void deletingRandomRollCyclesChaosTest() throws InterruptedException {
        Assume.assumeFalse((boolean)OS.isWindows());
        this.ignoreException("The current cycle seems to have been deleted from under the queue, scanning to find the next remaining cycle");
        int numberOfCycles = 300;
        AtomicBoolean running = new AtomicBoolean(true);
        try (QueueWithCycleDetails queueWithCycleDetails = this.createQueueWithNRollCycles(300, null);){
            Thread forwardTailerThread = new Thread(new QueueTailer(running, queueWithCycleDetails, TailerDirection.FORWARD));
            Thread backwardTailerThread = new Thread(new QueueTailer(running, queueWithCycleDetails, TailerDirection.BACKWARD));
            Thread deleteRandomCyclesThread = new Thread(() -> this.deleteAllRollCyclesInRandomOrder(queueWithCycleDetails));
            backwardTailerThread.start();
            forwardTailerThread.start();
            deleteRandomCyclesThread.start();
            deleteRandomCyclesThread.join();
            running.set(false);
            backwardTailerThread.join();
            forwardTailerThread.join();
        }
    }

    public void tailingThroughDeletedCyclesWillRefreshThenRetry(Function<QueueWithCycleDetails, SingleChronicleQueue> queueCreator) throws IOException {
        Assume.assumeFalse((boolean)OS.isWindows());
        this.expectException("The current cycle seems to have been deleted from under the queue, scanning to find the next remaining cycle");
        try (QueueWithCycleDetails queueWithCycleDetails = this.createQueueWithNRollCycles(3, null);
             SingleChronicleQueue queue = queueCreator.apply(queueWithCycleDetails);){
            RollCycleDetails firstCycle = queueWithCycleDetails.rollCycles.get(0);
            RollCycleDetails secondCycle = queueWithCycleDetails.rollCycles.get(1);
            RollCycleDetails thirdCycle = queueWithCycleDetails.rollCycles.get(2);
            ExcerptTailer tailer = queue.createTailer();
            Files.delete(Paths.get(firstCycle.filename, new String[0]));
            Files.delete(Paths.get(secondCycle.filename, new String[0]));
            Files.delete(Paths.get(thirdCycle.filename, new String[0]));
            int counter = 0;
            while (true) {
                DocumentContext documentContext = tailer.readingDocument();
                Throwable throwable = null;
                try {
                    if (!documentContext.isPresent()) break;
                    ++counter;
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (documentContext == null) continue;
                    if (throwable != null) {
                        try {
                            documentContext.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    documentContext.close();
                    continue;
                }
                break;
            }
            Assert.assertEquals((long)10L, (long)counter);
        }
    }

    private QueueWithCycleDetails createQueueWithNRollCycles(int numberOfCycles, Consumer<SingleChronicleQueueBuilder> builderConsumer) {
        List rollCycleDetails;
        SetTimeProvider timeProvider = new SetTimeProvider();
        QueueStoreFileListener listener = new QueueStoreFileListener();
        SingleChronicleQueueBuilder queueBuilder = SingleChronicleQueueBuilder.binary((Path)this.tempQueueDir.resolve("unitTestQueue")).rollCycle((RollCycle)RollCycles.FAST_DAILY).timeProvider((TimeProvider)timeProvider).storeFileListener((StoreFileListener)listener);
        if (builderConsumer != null) {
            builderConsumer.accept(queueBuilder);
        }
        SingleChronicleQueue queue = queueBuilder.build();
        try (ExcerptAppender appender = queue.createAppender();){
            Assert.assertEquals((long)Long.MAX_VALUE, (long)queue.firstIndex());
            rollCycleDetails = IntStream.range(0, numberOfCycles).mapToObj(i -> {
                long firstIndexInCycle = this.writeTextAndReturnFirstIndex(appender, "test" + (i + 1));
                long lastIndexInCycle = appender.lastIndexAppended();
                timeProvider.advanceMillis(TimeUnit.DAYS.toMillis(1L));
                BackgroundResourceReleaser.releasePendingResources();
                return new RollCycleDetails(queue.rollCycle().toCycle(firstIndexInCycle), firstIndexInCycle, lastIndexInCycle, listener.lastFileAcquired.getAbsolutePath());
            }).collect(Collectors.toList());
        }
        Assert.assertEquals((long)numberOfCycles, (long)rollCycleDetails.size());
        var9_8 = null;
        try (ExcerptTailer excerptTailer = queue.createTailer();){
            for (int i2 = 0; i2 < numberOfCycles; ++i2) {
                this.readText(excerptTailer, "test" + (i2 + 1));
            }
        }
        catch (Throwable throwable) {
            var9_8 = throwable;
            throw throwable;
        }
        return new QueueWithCycleDetails(queue, new CopyOnWriteArrayList<RollCycleDetails>(rollCycleDetails));
    }

    private long writeTextAndReturnFirstIndex(ExcerptAppender appender, String text) {
        long firstIndex = -1L;
        for (int i = 0; i < 10; ++i) {
            appender.writeText((CharSequence)text);
            if (firstIndex >= 0L) continue;
            firstIndex = appender.lastIndexAppended();
        }
        return firstIndex;
    }

    private void readText(ExcerptTailer tailer, String text) {
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((Object)text, (Object)tailer.readText());
        }
    }

    static final class QueueStoreFileListener
    implements StoreFileListener {
        private File lastFileAcquired;

        QueueStoreFileListener() {
        }

        public void onReleased(int cycle, File file) {
        }

        public void onAcquired(int cycle, File file) {
            Jvm.debug().on(TestDeleteQueueFile.class, "onAcquired called cycle: " + cycle + ", file: " + file);
            this.lastFileAcquired = file;
        }
    }

    static class RollCycleDetails {
        final int rollCycle;
        final long firstIndex;
        final long lastIndex;
        final String filename;

        RollCycleDetails(int rollCycle, long firstIndex, long lastIndex, String filename) {
            this.rollCycle = rollCycle;
            this.firstIndex = firstIndex;
            this.lastIndex = lastIndex;
            this.filename = filename;
        }
    }

    static class QueueWithCycleDetails
    extends AbstractCloseable {
        final SingleChronicleQueue queue;
        final List<RollCycleDetails> rollCycles;

        QueueWithCycleDetails(SingleChronicleQueue queue, List<RollCycleDetails> rollCycles) {
            this.queue = queue;
            this.rollCycles = rollCycles;
        }

        protected void performClose() throws IllegalStateException {
            Closeable.closeQuietly((Object)this.queue);
        }
    }

    private static class QueueTailer
    implements Runnable {
        private final AtomicBoolean running;
        private final QueueWithCycleDetails queueWithCycleDetails;
        private final TailerDirection direction;

        QueueTailer(AtomicBoolean running, QueueWithCycleDetails queueWithCycleDetails, TailerDirection direction) {
            this.running = running;
            this.queueWithCycleDetails = queueWithCycleDetails;
            this.direction = direction;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (this.running.get()) {
                    ExcerptTailer tailer;
                    block31: {
                        tailer = this.queueWithCycleDetails.queue.createTailer().direction(this.direction);
                        Throwable throwable = null;
                        try {
                            if (this.direction == TailerDirection.BACKWARD) {
                                tailer.toEnd();
                            } else {
                                tailer.toStart();
                            }
                            Jvm.startup().on(TestDeleteQueueFile.class, this.direction + " Tailer starting at index=" + Long.toHexString(tailer.index()) + ", cycle=" + this.queueWithCycleDetails.queue.rollCycle().toCycle(tailer.index()));
                            int cyclesRead = 0;
                            long lastReadIndex = -5L;
                            int currentCycle = -1;
                            while (this.running.get()) {
                                try {
                                    DocumentContext documentContext = tailer.readingDocument();
                                    Throwable throwable2 = null;
                                    try {
                                        if (!documentContext.isPresent()) {
                                            this.logIterationResult(this.direction, tailer, cyclesRead, lastReadIndex);
                                            break;
                                        }
                                        lastReadIndex = documentContext.index();
                                        int cycle = this.queueWithCycleDetails.queue.rollCycle().toCycle(lastReadIndex);
                                        if (cycle == currentCycle) continue;
                                        Jvm.startup().on(TestDeleteQueueFile.class, this.direction + " reading cycle " + cycle);
                                        currentCycle = cycle;
                                        ++cyclesRead;
                                    }
                                    catch (Throwable throwable3) {
                                        throwable2 = throwable3;
                                        throw throwable3;
                                    }
                                    finally {
                                        if (documentContext == null) continue;
                                        if (throwable2 != null) {
                                            try {
                                                documentContext.close();
                                            }
                                            catch (Throwable throwable4) {
                                                throwable2.addSuppressed(throwable4);
                                            }
                                            continue;
                                        }
                                        documentContext.close();
                                    }
                                }
                                catch (RuntimeException e) {
                                    Jvm.error().on(TestDeleteQueueFile.class, "Failed after reading " + lastReadIndex);
                                    throw e;
                                }
                            }
                            if (tailer == null) continue;
                            if (throwable == null) break block31;
                        }
                        catch (Throwable throwable5) {
                            try {
                                throwable = throwable5;
                                throw throwable5;
                            }
                            catch (Throwable throwable6) {
                                if (tailer == null) throw throwable6;
                                if (throwable == null) {
                                    tailer.close();
                                    throw throwable6;
                                }
                                try {
                                    tailer.close();
                                    throw throwable6;
                                }
                                catch (Throwable throwable7) {
                                    throwable.addSuppressed(throwable7);
                                    throw throwable6;
                                }
                            }
                        }
                        try {
                            tailer.close();
                            continue;
                        }
                        catch (Throwable throwable8) {
                            throwable.addSuppressed(throwable8);
                            continue;
                        }
                    }
                    tailer.close();
                }
            }
            catch (Exception e) {
                Jvm.error().on(TestDeleteQueueFile.class, "Error occurred", (Throwable)e);
            }
            Jvm.startup().on(TestDeleteQueueFile.class, "Tailer thread terminated: " + this.direction);
        }

        private OptionalLong lastAvailableIndex() {
            return this.queueWithCycleDetails.rollCycles.stream().mapToLong(rc -> rc.lastIndex).reduce(Long::max);
        }

        private OptionalLong firstAvailableIndex() {
            return this.queueWithCycleDetails.rollCycles.stream().mapToLong(rc -> rc.firstIndex).findFirst();
        }

        private int remainingCycles() {
            return this.queueWithCycleDetails.rollCycles.size();
        }

        private void logIterationResult(TailerDirection direction, ExcerptTailer tailer, int cyclesRead, long lastReadIndex) {
            int remainingCycles = this.remainingCycles();
            if (cyclesRead < remainingCycles) {
                Jvm.error().on(TestDeleteQueueFile.class, direction + " didn't read all remaining cycles cyclesRead=" + cyclesRead + ", cyclesRemaining=" + remainingCycles);
            }
            if (direction == TailerDirection.FORWARD) {
                this.lastAvailableIndex().ifPresent(lastIndex -> {
                    if (lastReadIndex < lastIndex) {
                        this.logError(tailer, lastIndex, cyclesRead);
                    }
                });
                return;
            }
            if (direction == TailerDirection.BACKWARD) {
                this.firstAvailableIndex().ifPresent(firstIndex -> {
                    if (lastReadIndex > firstIndex) {
                        this.logError(tailer, firstIndex, cyclesRead);
                    }
                });
                return;
            }
            Jvm.startup().on(TestDeleteQueueFile.class, direction + " Tailer read " + cyclesRead + " cycles of " + remainingCycles + " remaining (read should always be >= remaining)");
        }

        private void logError(ExcerptTailer tailer, long lastIndex, int cyclesRead) {
            String firstLast = this.direction == TailerDirection.BACKWARD ? "first" : "last";
            String error = String.format("Didn't get to %s. lastReadIndex=%x, lastReadCycle=%d, %sIndex=%x, %sCycle=%d, cyclesRead=%d", this.direction == TailerDirection.BACKWARD ? "start" : "end", tailer.lastReadIndex(), this.queueWithCycleDetails.queue.rollCycle().toCycle(tailer.lastReadIndex()), firstLast, lastIndex, firstLast, this.queueWithCycleDetails.queue.rollCycle().toCycle(lastIndex), cyclesRead);
            Jvm.error().on(TestDeleteQueueFile.class, error);
        }
    }
}

