/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.util.concurrent.ArrayBlockingQueue;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.TailerDirection;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.MessageHistory;
import net.openhft.chronicle.wire.SelfDescribingMarshallable;
import net.openhft.chronicle.wire.VanillaMessageHistory;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Test;

public class ReadOneBackwardsTest
extends QueueTestCommon {
    @Test
    public void test() {
        this.doTest(false);
    }

    @Test
    public void testScanning() {
        this.doTest(true);
    }

    public void doTest(boolean scanning) {
        ArrayBlockingQueue blockingQueue = new ArrayBlockingQueue(128);
        try (SingleChronicleQueue q = SingleChronicleQueueBuilder.single((File)this.getTmpDir()).sourceId(1).build();){
            MyDtoListener myOut = (MyDtoListener)q.methodWriter(MyDtoListener.class, new Class[0]);
            SnapshotListener snapshotOut = (SnapshotListener)q.methodWriter(SnapshotListener.class, new Class[0]);
            this.generateHistory(1);
            myOut.myDto(new MyDto());
            this.generateHistory(2);
            snapshotOut.snapshot(new SnapshotDTO("data"));
            this.generateHistory(3);
            myOut.myDto(new MyDto());
            this.generateHistory(4);
            myOut.myDto(new MyDto());
            ExcerptTailer tailer = q.createTailer().toEnd().direction(TailerDirection.BACKWARD);
            Object[] objectArray = new Object[1];
            objectArray[0] = blockingQueue::add;
            MethodReader reader = tailer.methodReaderBuilder().scanning(scanning).warnMissing(false).build(objectArray);
            if (!scanning) {
                Assert.assertTrue((boolean)reader.readOne());
                Assert.assertTrue((boolean)reader.readOne());
            }
            Assert.assertTrue((boolean)blockingQueue.isEmpty());
            Assert.assertTrue((boolean)reader.readOne());
            SnapshotDTO snapshotDTO = (SnapshotDTO)((Object)blockingQueue.poll());
            Assert.assertNotNull((Object)((Object)snapshotDTO));
            Assert.assertEquals((Object)"data", (Object)snapshotDTO.data);
            if (!scanning) {
                Assert.assertTrue((boolean)reader.readOne());
            }
            Assert.assertFalse((boolean)reader.readOne());
        }
    }

    @NotNull
    private VanillaMessageHistory generateHistory(int value) {
        VanillaMessageHistory messageHistory = (VanillaMessageHistory)MessageHistory.get();
        messageHistory.reset();
        messageHistory.addSource(value, (long)value);
        return messageHistory;
    }

    static class SnapshotDTO
    extends SelfDescribingMarshallable {
        String data;

        public SnapshotDTO(String data) {
            this.data = data;
        }
    }

    static class MyDto
    extends SelfDescribingMarshallable {
        String data;

        MyDto() {
        }
    }

    static interface SnapshotListener {
        public void snapshot(SnapshotDTO var1);
    }

    static interface MyDtoListener {
        public void myDto(MyDto var1);
    }
}

