/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.util.Time;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import org.junit.Assert;
import org.junit.Test;

public class LastAcknowledgedTest
extends QueueTestCommon {
    @Test
    public void testLastAcknowledge() {
        long lastIndexAppended;
        String name = OS.getTarget() + "/testLastAcknowledge-" + Time.uniqueId();
        try (SingleChronicleQueue q = SingleChronicleQueueBuilder.single((String)name).testBlockSize().build();
             ExcerptAppender excerptAppender = q.createAppender();){
            excerptAppender.writeText((CharSequence)"Hello World");
            lastIndexAppended = excerptAppender.lastIndexAppended();
            ExcerptTailer tailer = q.createTailer();
            try (DocumentContext dc = tailer.readingDocument();){
                Assert.assertTrue((boolean)dc.isData());
                Assert.assertEquals((long)lastIndexAppended, (long)tailer.index());
            }
            ExcerptTailer tailer2 = q.createTailer();
            tailer2.readAfterReplicaAcknowledged(true);
            try (DocumentContext dc = tailer2.readingDocument();){
                Assert.assertFalse((boolean)dc.isPresent());
            }
        }
        q = SingleChronicleQueueBuilder.single((String)name).testBlockSize().build();
        var5_3 = null;
        try {
            Assert.assertEquals((long)-1L, (long)q.lastAcknowledgedIndexReplicated());
            q.lastAcknowledgedIndexReplicated(lastIndexAppended - 1L);
            ExcerptTailer tailer2 = q.createTailer();
            tailer2.readAfterReplicaAcknowledged(true);
            try (DocumentContext dc = tailer2.readingDocument();){
                Assert.assertFalse((boolean)dc.isPresent());
            }
            q.lastAcknowledgedIndexReplicated(lastIndexAppended);
            dc = tailer2.readingDocument();
            var8_11 = null;
            try {
                Assert.assertTrue((boolean)dc.isData());
                Assert.assertEquals((long)lastIndexAppended, (long)tailer2.index());
            }
            catch (Throwable throwable) {
                var8_11 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var8_11 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var8_11.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            var5_3 = throwable;
            throw throwable;
        }
        finally {
            if (q != null) {
                if (var5_3 != null) {
                    try {
                        q.close();
                    }
                    catch (Throwable throwable) {
                        var5_3.addSuppressed(throwable);
                    }
                } else {
                    q.close();
                }
            }
        }
    }
}

