/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import net.openhft.chronicle.bytes.MappedUniqueTimeProvider;
import net.openhft.chronicle.bytes.PageUtil;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.shutdown.PriorityHook;
import net.openhft.chronicle.core.time.SystemTimeProvider;
import org.jetbrains.annotations.NotNull;

public class DirectoryUtils {
    @NotNull
    public static File tempDir(String name) {
        String replacedName = name.replaceAll("[\\[\\]\\s]+", "_").replace(':', '_');
        File tmpDir = new File(OS.getTarget(), replacedName + "-" + DirectoryUtils.uniqueId());
        DeleteStatic.INSTANCE.add(tmpDir);
        tmpDir.deleteOnExit();
        if (OS.isMacOSX()) {
            Jvm.debug().on(DirectoryUtils.class, "Tmp dir: " + tmpDir);
        }
        return tmpDir;
    }

    public static String uniqueId() {
        long l;
        try {
            l = MappedUniqueTimeProvider.INSTANCE.currentTimeMicros();
        }
        catch (IllegalStateException var3) {
            l = SystemTimeProvider.INSTANCE.currentTimeMicros();
        }
        return Long.toString(l, 36);
    }

    @Deprecated
    public static void deleteDir(@NotNull String dir) {
        IOTools.deleteDirWithFiles((File)new File(dir));
    }

    @Deprecated
    public static void deleteDir(@NotNull File dir) {
        IOTools.deleteDirWithFiles((File)dir);
    }

    static {
        if (PageUtil.isHugePage((String)OS.getTarget())) {
            System.setProperty("timestamp.dir", System.getProperty("java.io.tmpdir"));
        }
    }

    static enum DeleteStatic {
        INSTANCE;

        final Set<File> toDeleteList = Collections.synchronizedSet(new LinkedHashSet());

        private DeleteStatic() {
            PriorityHook.add((int)100, () -> this.toDeleteList.forEach(IOTools::deleteDirWithFiles));
        }

        synchronized void add(File path) {
            this.toDeleteList.add(path);
        }
    }
}

