/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.testframework.process.JavaProcessBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class CheckHalfWrittenMsgNotSeenByTailerTest
extends QueueTestCommon {
    @Test
    public void checkTailerOnlyReadsTwoMessageOneProcess() throws InterruptedException {
        Assume.assumeTrue((!OS.isWindows() ? 1 : 0) != 0);
        File queueDirectory = DirectoryUtils.tempDir("halfWritten");
        HalfWriteAMessage.writeIncompleteMessage(queueDirectory.toString(), false);
        for (int i = 0; i < 3; ++i) {
            System.gc();
            Jvm.pause((long)50L);
        }
        try (ChronicleQueue single = ChronicleQueue.single((String)queueDirectory.getPath());
             ExcerptTailer tailer = single.createTailer();){
            try (DocumentContext dc = tailer.readingDocument();){
                Assert.assertTrue((boolean)dc.isPresent());
                Assert.assertEquals((Object)"hello world 1", (Object)dc.wire().read("key1").text());
                Assert.assertEquals((Object)"hello world 2", (Object)dc.wire().read("key2").text());
            }
            dc = tailer.readingDocument();
            var7_12 = null;
            try {
                Assert.assertTrue((boolean)dc.isPresent());
                Assert.assertEquals((Object)"hello world 3", (Object)dc.wire().read("key1").text());
                Assert.assertEquals((Object)"hello world 4", (Object)dc.wire().read("key2").text());
            }
            catch (Throwable throwable) {
                var7_12 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var7_12 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var7_12.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            dc = tailer.readingDocument();
            var7_12 = null;
            try {
                boolean present = dc.isPresent();
                if (present) {
                    System.out.println(dc.wire().bytes().toHexString());
                    String key = (String)dc.wire().readEvent(String.class);
                    String value = dc.wire().getValueIn().text();
                    Assert.fail((String)("key: " + key + ", value: " + value));
                }
            }
            catch (Throwable throwable) {
                var7_12 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var7_12 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var7_12.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
        }
    }

    @Test
    public void checkTailerOnlyReadsTwoMessageTwoProcesses() throws IOException, InterruptedException {
        Assume.assumeTrue((OS.isLinux() && OS.is64Bit() ? 1 : 0) != 0);
        File queueDirectory = DirectoryUtils.tempDir("halfWritten");
        CheckHalfWrittenMsgNotSeenByTailerTest.runCommand(JavaProcessBuilder.create(HalfWriteAMessage.class).withProgramArguments(new String[]{queueDirectory.getAbsolutePath()}).start());
        try (ChronicleQueue single = ChronicleQueue.single((String)queueDirectory.getPath());
             ExcerptTailer tailer = single.createTailer();){
            try (DocumentContext dc = tailer.readingDocument();){
                Assert.assertTrue((boolean)dc.isPresent());
                Assert.assertEquals((Object)"hello world 1", (Object)dc.wire().read("key1").text());
                Assert.assertEquals((Object)"hello world 2", (Object)dc.wire().read("key2").text());
            }
            dc = tailer.readingDocument();
            var7_11 = null;
            try {
                Assert.assertTrue((boolean)dc.isPresent());
                Assert.assertEquals((Object)"hello world 3", (Object)dc.wire().read("key1").text());
                Assert.assertEquals((Object)"hello world 4", (Object)dc.wire().read("key2").text());
            }
            catch (Throwable throwable) {
                var7_11 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var7_11 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var7_11.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            dc = tailer.readingDocument();
            var7_11 = null;
            try {
                boolean present = dc.isPresent();
                if (present) {
                    Jvm.error().on(this.getClass(), "Found an excerpt " + dc.wire().bytes().toHexString());
                    String key = (String)dc.wire().readEvent(String.class);
                    String value = dc.wire().getValueIn().text();
                    Assert.fail((String)("key: " + key + ", value: " + value));
                }
            }
            catch (Throwable throwable) {
                var7_11 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var7_11 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var7_11.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
        }
    }

    private static void runCommand(Process p) throws IOException, InterruptedException {
        String s;
        BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
        BufferedReader stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        while ((s = stdInput.readLine()) != null) {
            System.out.println(s);
            if (!"== FINISHED WRITING DATA ==".equals(s)) continue;
            return;
        }
        System.out.println("Here is the standard error of the command (if any):\n");
        while ((s = stdError.readLine()) != null) {
            System.out.println(s);
        }
        p.waitFor();
    }

    static {
        HalfWriteAMessage.class.getName();
    }

    public static class HalfWriteAMessage {
        public static void main(String[] args) throws InterruptedException {
            HalfWriteAMessage.writeIncompleteMessage(args[0], true);
        }

        private static void writeIncompleteMessage(String arg, boolean exit) throws InterruptedException {
            System.out.println("half writing a message to " + arg);
            try (ChronicleQueue single = ChronicleQueue.single((String)arg);
                 ExcerptAppender excerptAppender = single.createAppender();){
                try (DocumentContext dc = excerptAppender.writingDocument();){
                    dc.wire().write((CharSequence)"key1").text("hello world 1");
                    dc.wire().write((CharSequence)"key2").text("hello world 2");
                }
                dc = excerptAppender.writingDocument();
                var7_11 = null;
                try {
                    dc.wire().write((CharSequence)"key1").text("hello world 3");
                    dc.wire().write((CharSequence)"key2").text("hello world 4");
                }
                catch (Throwable throwable) {
                    var7_11 = throwable;
                    throw throwable;
                }
                finally {
                    if (dc != null) {
                        if (var7_11 != null) {
                            try {
                                dc.close();
                            }
                            catch (Throwable throwable) {
                                var7_11.addSuppressed(throwable);
                            }
                        } else {
                            dc.close();
                        }
                    }
                }
                dc = excerptAppender.writingDocument();
                dc.wire().write((CharSequence)"key1").text("hello world 5");
                Thread.sleep(1L);
                System.out.println("== FINISHED WRITING DATA ==");
                if (exit) {
                    System.exit(-1);
                }
                dc.wire().write((CharSequence)"key2").text("hello world 6");
            }
        }
    }
}

