/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import java.nio.BufferUnderflowException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.bytes.StopCharTesters;
import net.openhft.chronicle.bytes.StopCharsTester;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.InvalidMarshallableException;
import net.openhft.chronicle.core.threads.ThreadLocalHelper;
import net.openhft.chronicle.core.util.ClassNotFoundRuntimeException;
import net.openhft.chronicle.wire.AbstractWire;
import net.openhft.chronicle.wire.Quotes;
import net.openhft.chronicle.wire.SerializationStrategy;
import net.openhft.chronicle.wire.TextReadDocumentContext;
import net.openhft.chronicle.wire.TextStopCharsTesters;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.TextWriteDocumentContext;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.YamlWireOut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSONWire
extends TextWire {
    @NotNull
    public static final Bytes<byte[]> ULL = Bytes.from("ull");
    static final BytesStore COMMA = BytesStore.from(",");
    static final ThreadLocal<WeakReference<StopCharsTester>> STRICT_ESCAPED_END_OF_TEXT_JSON = new ThreadLocal();
    static final Supplier<StopCharsTester> STRICT_END_OF_TEXT_JSON_ESCAPING = TextStopCharsTesters.STRICT_END_OF_TEXT_JSON::escaping;
    boolean useTypes;

    public JSONWire() {
        this(Bytes.allocateElasticOnHeap());
    }

    public JSONWire(@NotNull Bytes<?> bytes, boolean use8bit) {
        super(bytes, use8bit);
        this.trimFirstCurly(false);
    }

    public JSONWire(@NotNull Bytes<?> bytes) {
        this(bytes, false);
    }

    @NotNull
    public static JSONWire from(@NotNull String text) {
        return new JSONWire(Bytes.from(text));
    }

    public static String asText(@NotNull Wire wire) throws InvalidMarshallableException {
        long pos = wire.bytes().readPosition();
        @NotNull JSONWire tw = new JSONWire(NativeBytes.nativeBytes());
        wire.copyTo(tw);
        wire.bytes().readPosition(pos);
        return tw.toString();
    }

    static boolean isWrapper(Class<?> type) {
        return type == Integer.class || type == Long.class || type == Float.class || type == Double.class || type == Short.class || type == Character.class || type == Byte.class || type == Boolean.class || type == Void.class;
    }

    @Override
    protected Class defaultKeyClass() {
        return String.class;
    }

    public JSONWire useTypes(boolean outputTypes) {
        this.useTypes = outputTypes;
        return this;
    }

    public boolean useTypes() {
        return this.useTypes;
    }

    @Override
    @NotNull
    public TextWire useTextDocuments() {
        this.readContext = new JSONReadDocumentContext(this);
        this.writeContext = this.trimFirstCurly() ? new TextWriteDocumentContext(this) : new JSONWriteDocumentContext(this);
        return this;
    }

    @Override
    @NotNull
    protected JSONValueOut createValueOut() {
        return new JSONValueOut();
    }

    @Override
    @NotNull
    protected TextWire.TextValueIn createValueIn() {
        return new JSONValueIn(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public double float64() {
                boolean isNull;
                JSONWire.this.consumePadding();
                JSONWire.this.valueIn.skipType();
                switch (JSONWire.this.peekCode()) {
                    case 91: 
                    case 123: {
                        Jvm.warn().on(this.getClass(), "Unable to read " + JSONWire.this.valueIn.objectBestEffort() + " as a double.");
                        return 0.0;
                    }
                }
                long l = JSONWire.this.bytes.readLimit();
                try {
                    JSONWire.this.bytes.readLimit(JSONWire.this.bytes.readPosition() + 4L);
                    isNull = "null".contentEquals(JSONWire.this.bytes);
                }
                finally {
                    JSONWire.this.bytes.readLimit(l);
                }
                if (isNull) {
                    JSONWire.this.bytes.readSkip("null".length());
                    JSONWire.this.consumePadding();
                }
                double v = isNull ? Double.NaN : JSONWire.this.bytes.parseDouble();
                this.checkRewind();
                return v;
            }

            @Override
            public void checkRewind() {
                int ch = this.peekBack();
                if (ch == 58 || ch == 125 || ch == 93) {
                    JSONWire.this.bytes.readSkip(-1L);
                } else if (ch != 108 && ch > 70 && (ch < 97 || ch > 102)) {
                    throw new IllegalArgumentException("Unexpected character in number '" + (char)ch + '\'');
                }
            }
        };
    }

    @Override
    public void copyTo(@NotNull WireOut wire) throws InvalidMarshallableException {
        if (wire.getClass() == this.getClass()) {
            Bytes<?> bytes0 = this.bytes();
            long length = bytes0.readRemaining();
            wire.bytes().write(this.bytes, bytes0.readPosition(), length);
            this.bytes.readSkip(length);
            return;
        }
        this.consumePadding();
        this.trimCurlyBrackets();
        while (this.bytes.readRemaining() > 1L) {
            this.copyOne(wire, true, true);
            this.consumePadding();
        }
    }

    private void trimCurlyBrackets() {
        if (this.peekNextByte() == 125) {
            this.bytes.readSkip(1L);
            this.consumePadding();
            while (this.peekPreviousByte() <= 32) {
                this.bytes.writeSkip(-1L);
            }
            if (this.peekPreviousByte() == 125) {
                this.bytes.writeSkip(-1L);
            }
        }
    }

    private int peekPreviousByte() {
        return this.bytes.peekUnsignedByte(this.bytes.readLimit() - 1L);
    }

    public void copyOne(@NotNull WireOut wire, boolean inMap, boolean topLevel) throws InvalidMarshallableException {
        int ch = this.bytes.readUnsignedByte();
        switch (ch) {
            case 34: 
            case 39: {
                this.copyQuote(wire, ch, inMap, topLevel);
                if (inMap) {
                    this.consumePadding();
                    int ch2 = this.bytes.readUnsignedByte();
                    if (ch2 != 58) {
                        throw new IORuntimeException("Expected a ':' but got a '" + (char)ch);
                    }
                    this.copyOne(wire, false, false);
                }
                return;
            }
            case 123: {
                if (this.isTypePrefix()) {
                    this.copyTypePrefix(wire);
                } else {
                    this.copyMap(wire);
                }
                return;
            }
            case 91: {
                this.copySequence(wire);
                return;
            }
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.copyNumber(wire);
                return;
            }
            case 110: {
                if (!this.bytes.startsWith(ULL) || Character.isLetterOrDigit(this.bytes.peekUnsignedByte(this.bytes.readPosition() + 3L))) break;
                this.bytes.readSkip(3L);
                this.consumePadding();
                wire.getValueOut().nu11();
                return;
            }
        }
        this.bytes.readSkip(-1L);
        throw new IORuntimeException("Unexpected chars '" + this.bytes.parse8bit(StopCharTesters.CONTROL_STOP) + "'");
    }

    private void copyTypePrefix(WireOut wire) throws InvalidMarshallableException {
        StringBuilder sb = this.acquireStringBuilder();
        this.getValueIn().text(sb);
        sb.deleteCharAt(0);
        wire.getValueOut().typePrefix(sb);
        this.consumePadding();
        int ch = this.bytes.readUnsignedByte();
        if (ch != 58) {
            throw new IORuntimeException("Expected a ':' after the type " + sb + " but got a " + (char)ch);
        }
        this.copyOne(wire, true, false);
        this.consumePadding();
        int ch2 = this.bytes.readUnsignedByte();
        if (ch2 != 125) {
            throw new IORuntimeException("Expected a '}' after the type " + sb + " but got a " + (char)ch);
        }
    }

    private boolean isTypePrefix() {
        long rp = this.bytes.readPosition();
        return this.bytes.peekUnsignedByte(rp) == 34 && this.bytes.peekUnsignedByte(rp + 1L) == 64;
    }

    private void copyQuote(WireOut wire, int ch, boolean inMap, boolean topLevel) throws InvalidMarshallableException {
        int ch2;
        StringBuilder sb = this.acquireStringBuilder();
        while (this.bytes.readRemaining() > 0L && (ch2 = this.bytes.readUnsignedByte()) != ch) {
            sb.append((char)ch2);
            if (ch2 != 92) continue;
            sb.append((char)this.bytes.readUnsignedByte());
        }
        JSONWire.unescape(sb);
        if (topLevel) {
            wire.writeEvent(String.class, sb);
        } else if (inMap) {
            wire.write(sb);
        } else {
            wire.getValueOut().text(sb);
        }
    }

    private void copyMap(WireOut wire) throws InvalidMarshallableException {
        wire.getValueOut().marshallable(out -> {
            this.consumePadding();
            while (this.bytes.readRemaining() > 0L) {
                int ch = this.peekNextByte();
                if (ch == 125) {
                    this.bytes.readSkip(1L);
                    return;
                }
                this.copyOne(wire, true, false);
                this.expectComma('}');
            }
        });
    }

    private void expectComma(char end) {
        this.consumePadding();
        int ch = this.peekNextByte();
        if (ch == end) {
            return;
        }
        if (ch != 44) {
            throw new IORuntimeException("Expected a comma or '" + end + "' not a '" + (char)ch + "'");
        }
        this.bytes.readSkip(1L);
        this.consumePadding();
    }

    private void copySequence(WireOut wire) {
        wire.getValueOut().sequence(out -> {
            this.consumePadding();
            while (this.bytes.readRemaining() > 1L) {
                int ch = this.peekNextByte();
                if (ch == 93) {
                    this.bytes.readSkip(1L);
                    return;
                }
                this.copyOne(wire, false, false);
                this.expectComma(']');
            }
        });
    }

    private int peekNextByte() {
        return this.bytes.peekUnsignedByte(this.bytes.readPosition());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyNumber(WireOut wire) {
        this.bytes.readSkip(-1L);
        long rp = this.bytes.readPosition();
        boolean decimal = false;
        block6: while (true) {
            int ch2 = this.peekNextByte();
            switch (ch2) {
                case 43: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.bytes.readSkip(1L);
                    if (wire.isBinary()) {
                        decimal |= ch2 == 46;
                        continue block6;
                    }
                    wire.bytes().append((char)ch2);
                    continue block6;
                }
            }
            break;
        }
        if (wire.isBinary()) {
            long rl = this.bytes.readLimit();
            try {
                this.bytes.readPositionRemaining(rp, this.bytes.readPosition() - rp);
                if (decimal) {
                    wire.getValueOut().float64(this.bytes.parseDouble());
                }
                wire.getValueOut().int64(this.bytes.parseLong());
            }
            finally {
                this.bytes.readLimit(rl);
            }
        } else {
            wire.bytes().append(",");
        }
    }

    @Override
    @NotNull
    protected Quotes needsQuotes(@NotNull CharSequence s) {
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch != '\"' && ch >= ' ' && ch != '\\') continue;
            return Quotes.DOUBLE;
        }
        return Quotes.NONE;
    }

    @Override
    void escape(@NotNull CharSequence s) {
        this.bytes.writeUnsignedByte(34);
        if (this.needsQuotes(s) == Quotes.NONE) {
            this.bytes.appendUtf8(s);
        } else {
            this.escape0(s, Quotes.DOUBLE);
        }
        this.bytes.writeUnsignedByte(34);
    }

    @Override
    protected void escape0(@NotNull CharSequence s, @NotNull Quotes quotes) {
        block9: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\b': {
                    this.bytes.append("\\b");
                    continue block9;
                }
                case '\t': {
                    this.bytes.append("\\t");
                    continue block9;
                }
                case '\f': {
                    this.bytes.append("\\f");
                    continue block9;
                }
                case '\n': {
                    this.bytes.append("\\n");
                    continue block9;
                }
                case '\r': {
                    this.bytes.append("\\r");
                    continue block9;
                }
                case '\"': {
                    if (ch == quotes.q) {
                        ((Bytes)this.bytes.writeUnsignedByte(92)).writeUnsignedByte(ch);
                        continue block9;
                    }
                    this.bytes.writeUnsignedByte(ch);
                    continue block9;
                }
                case '\\': {
                    ((Bytes)this.bytes.writeUnsignedByte(92)).writeUnsignedByte(ch);
                    continue block9;
                }
                default: {
                    if (ch < ' ' || ch > '\u007f') {
                        this.appendU4(ch);
                        continue block9;
                    }
                    this.bytes.append(ch);
                }
            }
        }
    }

    @Override
    public ValueOut writeEvent(Class expectedType, Object eventKey) throws InvalidMarshallableException {
        return super.writeEvent(String.class, "" + eventKey);
    }

    @Override
    public void writeStartEvent() {
    }

    @Override
    @NotNull
    protected StringBuilder readField(@NotNull StringBuilder sb) {
        this.consumePadding();
        int code = this.peekCode();
        if (code == 125) {
            sb.setLength(0);
            return sb;
        }
        if (code == 123) {
            if (this.valueIn.stack.level > 0) {
                throw new IORuntimeException("Expected field name, but got { at " + this.bytes.toDebugString(64L));
            }
            this.valueIn.pushState();
            this.bytes.readSkip(1L);
        }
        return super.readField(sb);
    }

    @Override
    @NotNull
    protected StopCharsTester getStrictEscapingEndOfText() {
        StopCharsTester escaping = ThreadLocalHelper.getTL(STRICT_ESCAPED_END_OF_TEXT_JSON, STRICT_END_OF_TEXT_JSON_ESCAPING);
        escaping.isStopChar(32, 32);
        return escaping;
    }

    class JSONValueIn
    extends TextWire.TextValueIn {
        JSONValueIn() {
            super(JSONWire.this);
        }

        @Override
        public boolean isNull() {
            JSONWire.this.consumePadding();
            if (JSONWire.this.peekStringIgnoreCase("null")) {
                JSONWire.this.bytes.readSkip(4L);
                JSONWire.this.consumePadding(1);
                return true;
            }
            return false;
        }

        @Override
        public String text() {
            @Nullable String text = super.text();
            return text == null || text.equals("null") ? null : text;
        }

        @Override
        protected boolean isASeparator(int nextChar) {
            return true;
        }

        @Override
        @Nullable
        public Object object() throws InvalidMarshallableException {
            return JSONWire.this.useTypes ? this.parseType() : super.object();
        }

        @Override
        @Nullable
        public <E> E object(@Nullable Class<E> clazz) throws InvalidMarshallableException {
            return JSONWire.this.useTypes ? this.parseType(null, clazz, true) : super.object(null, clazz, true);
        }

        @Override
        public <E> E object(@Nullable E using, @Nullable Class clazz, boolean bestEffort) throws InvalidMarshallableException {
            return JSONWire.this.useTypes ? this.parseType(using, clazz, bestEffort) : super.object(using, clazz, bestEffort);
        }

        @Override
        public Class typePrefix() {
            return super.typePrefix();
        }

        @Override
        public Object typePrefixOrObject(Class tClass) {
            return super.typePrefixOrObject(tClass);
        }

        @Override
        public Type typeLiteral(BiFunction<CharSequence, ClassNotFoundException, Type> unresolvedHandler) {
            JSONWire.this.consumePadding();
            StringBuilder stringBuilder = JSONWire.this.acquireStringBuilder();
            this.text(stringBuilder);
            try {
                return this.classLookup().forName(stringBuilder);
            }
            catch (ClassNotFoundRuntimeException e) {
                return unresolvedHandler.apply(stringBuilder, e.getCause());
            }
        }

        @Override
        @Nullable
        public Object marshallable(@NotNull Object object, @NotNull SerializationStrategy strategy) throws BufferUnderflowException, IORuntimeException, InvalidMarshallableException {
            return super.marshallable(object, strategy);
        }

        @Override
        public boolean isTyped() {
            return JSONWire.this.useTypes || super.isTyped();
        }

        private Object parseType() throws InvalidMarshallableException {
            if (!this.hasTypeDefinition()) {
                return super.object();
            }
            StringBuilder sb = JSONWire.this.acquireStringBuilder();
            sb.setLength(0);
            this.wireIn().read(sb);
            Class<?> clazz = this.classLookup().forName(sb.subSequence(1, sb.length()));
            return this.parseType(null, clazz, true);
        }

        private <E> E parseType(@Nullable E using, @Nullable Class clazz, boolean bestEffort) throws InvalidMarshallableException {
            if (!this.hasTypeDefinition()) {
                return super.object(using, clazz, bestEffort);
            }
            StringBuilder sb = JSONWire.this.acquireStringBuilder();
            sb.setLength(0);
            this.readTypeDefinition(sb);
            Class<?> overrideClass = this.classLookup().forName(sb.subSequence(1, sb.length()));
            if (clazz != null && !clazz.isAssignableFrom(overrideClass)) {
                throw new ClassCastException("Unable to cast " + overrideClass.getName() + " to " + clazz.getName());
            }
            if (using != null && !overrideClass.isInstance(using)) {
                throw new ClassCastException("Unable to reuse a " + using.getClass().getName() + " as a " + overrideClass.getName());
            }
            E result = super.object(using, overrideClass, bestEffort);
            JSONWire.this.consumePadding();
            char endBracket = JSONWire.this.bytes.readChar();
            assert (endBracket == '}') : "Missing end bracket }, got " + endBracket + " from " + JSONWire.this.bytes;
            JSONWire.this.consumePadding(1);
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean hasTypeDefinition() {
            long readPos = JSONWire.this.bytes.readPosition();
            try {
                JSONWire.this.consumePadding();
                if (JSONWire.this.bytes.readChar() != '{') {
                    boolean bl = false;
                    return bl;
                }
                JSONWire.this.consumePadding();
                if (JSONWire.this.bytes.readChar() != '\"') {
                    boolean bl = false;
                    return bl;
                }
                JSONWire.this.consumePadding();
                boolean bl = JSONWire.this.bytes.readChar() == '@';
                return bl;
            }
            finally {
                JSONWire.this.bytes.readPosition(readPos);
            }
        }

        void readTypeDefinition(StringBuilder sb) {
            JSONWire.this.consumePadding();
            if (JSONWire.this.bytes.readChar() != '{') {
                throw new IORuntimeException("Expected { but got " + JSONWire.this.bytes);
            }
            JSONWire.this.consumePadding();
            this.text(sb);
            JSONWire.this.consumePadding();
            char colon = JSONWire.this.bytes.readChar();
            assert (colon == ':') : "Expected : but got " + colon;
        }

        public boolean useTypes() {
            return JSONWire.this.useTypes;
        }
    }

    class JSONValueOut
    extends YamlWireOut.YamlValueOut {
        JSONValueOut() {
            super(JSONWire.this);
        }

        @Override
        protected void trimWhiteSpace() {
            if (JSONWire.this.bytes.endsWith('\n') || JSONWire.this.bytes.endsWith(' ')) {
                JSONWire.this.bytes.writeSkip(-1L);
            }
        }

        @Override
        protected void indent() {
        }

        @Override
        @NotNull
        public String nullOut() {
            return "null";
        }

        @Override
        @NotNull
        public JSONWire typeLiteral(@Nullable CharSequence type) {
            return (JSONWire)this.text(type);
        }

        @Override
        @NotNull
        public JSONValueOut typePrefix(@NotNull CharSequence typeName) {
            if (JSONWire.this.useTypes) {
                this.startBlock('{');
                JSONWire.this.bytes.append("\"@");
                JSONWire.this.bytes.append(typeName);
                JSONWire.this.bytes.append("\":");
            }
            return this;
        }

        @Override
        public void endTypePrefix() {
            super.endTypePrefix();
            if (JSONWire.this.useTypes) {
                this.endBlock('}');
                this.elementSeparator();
            }
        }

        @Override
        public void elementSeparator() {
            this.sep = COMMA;
        }

        @Override
        protected void asTestQuoted(String s, Quotes quotes) {
            JSONWire.this.bytes.append('\"');
            JSONWire.this.escape0(s, quotes);
            JSONWire.this.bytes.append('\"');
        }

        @Override
        protected void popState() {
        }

        @Override
        protected void pushState() {
            this.leaf = true;
        }

        @Override
        protected void afterOpen() {
            this.sep = YamlWireOut.EMPTY;
        }

        @Override
        protected void afterClose() {
        }

        @Override
        protected void addNewLine(long pos) {
        }

        @Override
        protected void newLine() {
        }

        @Override
        protected void endField() {
            this.sep = COMMA;
        }

        @Override
        protected void fieldValueSeperator() {
            JSONWire.this.bytes.writeUnsignedByte(58);
        }

        @Override
        public void writeComment(@NotNull CharSequence s) {
        }

        @Override
        protected String doubleToString(double d) {
            return Double.isNaN(d) ? "null" : super.doubleToString(d);
        }

        @Override
        protected String floatToString(float f) {
            return Float.isNaN(f) ? "null" : super.floatToString(f);
        }

        @Override
        @NotNull
        public JSONWire rawText(CharSequence value) {
            JSONWire.this.bytes.writeByte((byte)34);
            super.rawText(value);
            JSONWire.this.bytes.writeByte((byte)34);
            return JSONWire.this;
        }

        @Override
        @NotNull
        public JSONWire date(LocalDate localDate) {
            return (JSONWire)this.text(localDate.toString());
        }

        @Override
        @NotNull
        public JSONWire dateTime(LocalDateTime localDateTime) {
            return (JSONWire)this.text(localDateTime.toString());
        }

        @Override
        @NotNull
        public <V> JSONWire object(@NotNull Class<V> expectedType, V v) throws InvalidMarshallableException {
            return (JSONWire)(JSONWire.this.useTypes ? super.object(v) : super.object(expectedType, v));
        }

        @Override
        @NotNull
        public JSONValueOut typePrefix(Class type) {
            if (type.isPrimitive() || JSONWire.isWrapper(type) || type.isEnum()) {
                return this;
            }
            return (JSONValueOut)super.typePrefix(type);
        }

        @Override
        @NotNull
        public <K, V> JSONWire marshallable(@Nullable Map<K, V> map, @NotNull Class<K> kClass, @NotNull Class<V> vClass, boolean leaf) throws InvalidMarshallableException {
            return (JSONWire)super.marshallable(map, String.class, vClass, leaf);
        }

        @Override
        @NotNull
        public JSONWire time(LocalTime localTime) {
            return (JSONWire)super.time(localTime);
        }
    }

    class JSONWriteDocumentContext
    extends TextWriteDocumentContext {
        private long start;

        public JSONWriteDocumentContext(Wire wire) {
            super(wire);
        }

        @Override
        public boolean isEmpty() {
            return this.wire().bytes().writePosition() == this.position + 1L;
        }

        @Override
        public void start(boolean metaData) {
            int count = this.count;
            super.start(metaData);
            if (count == 0) {
                JSONWire.this.bytes.append('{');
                this.start = JSONWire.this.bytes.writePosition();
            }
        }

        @Override
        public void close() {
            super.close();
            if (this.count == 0) {
                if (JSONWire.this.bytes.writePosition() == this.start) {
                    JSONWire.this.bytes.writeSkip(-1L);
                } else {
                    JSONWire.this.bytes.append('}');
                }
            }
        }
    }

    class JSONReadDocumentContext
    extends TextReadDocumentContext {
        private int first;

        public JSONReadDocumentContext(AbstractWire wire) {
            super(wire);
        }

        @Override
        public void start() {
            this.first = JSONWire.this.bytes.peekUnsignedByte();
            if (this.first == 123) {
                JSONWire.this.bytes.readSkip(1L);
                long lastOffset = JSONWire.this.bytes.readLimit() - 1L;
                if (JSONWire.this.bytes.peekUnsignedByte(lastOffset) == 125) {
                    JSONWire.this.bytes.readLimit(lastOffset);
                }
            }
            super.start();
        }

        @Override
        public void close() {
            if (this.first == 123) {
                JSONWire.this.consumePadding();
                if (JSONWire.this.bytes.peekUnsignedByte() == 125) {
                    JSONWire.this.bytes.readSkip(1L);
                }
            }
            super.close();
        }
    }
}

